/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.upgrade.v2_6_0;

import com.liferay.fragment.internal.upgrade.v2_6_0.util.FragmentEntryTable;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Statement;

public class FragmentEntryUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.upgradeSchema();
        this.upgradeFragmentEntryCounter();
        this.upgradeFragmentEntryHeadIdAndHeadStatusApproved();
        this.upgradeFragmentEntryHeadIdAndHeadStatusDraft();
    }

    protected void upgradeFragmentEntryCounter() throws Exception {
        this.runSQL(StringBundler.concat((String[])new String[]{"insert into Counter (name, currentId) select '", FragmentEntry.class.getName(), "', max(fragmentEntryId) from FragmentEntry"}));
    }

    protected void upgradeFragmentEntryHeadIdAndHeadStatusApproved() throws Exception {
        try (Statement s = this.connection.createStatement();){
            StringBundler sb = new StringBundler(3);
            sb.append("update FragmentEntry set headId = -1 * fragmentEntryId");
            sb.append(", head = [$TRUE$] where status = ");
            sb.append(0);
            s.execute(SQLTransformer.transform((String)sb.toString()));
        }
    }

    protected void upgradeFragmentEntryHeadIdAndHeadStatusDraft() throws Exception {
        try (Statement s = this.connection.createStatement();){
            StringBundler sb = new StringBundler(3);
            sb.append("update FragmentEntry set headId = fragmentEntryId, ");
            sb.append("head = [$FALSE$] where status != ");
            sb.append(0);
            s.execute(SQLTransformer.transform((String)sb.toString()));
        }
    }

    protected void upgradeSchema() throws Exception {
        this.alter(FragmentEntryTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "headId", "LONG"), new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "head", "BOOLEAN")});
    }
}

