/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.validator;

import com.liferay.fragment.exception.FragmentEntryConfigurationException;
import com.liferay.fragment.validator.FragmentEntryValidator;
import com.liferay.petra.json.validator.JSONValidator;
import com.liferay.petra.json.validator.JSONValidatorException;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={FragmentEntryValidator.class})
public class FragmentEntryValidatorImpl
implements FragmentEntryValidator {
    public void validateConfiguration(String configuration) throws FragmentEntryConfigurationException {
        this.validateConfigurationValues(configuration, null);
    }

    public void validateConfigurationValues(String configuration, JSONObject valuesJSONObject) throws FragmentEntryConfigurationException {
        if (Validator.isNull((String)configuration)) {
            return;
        }
        InputStream configurationJSONSchemaInputStream = FragmentEntryValidatorImpl.class.getResourceAsStream("dependencies/configuration-json-schema.json");
        try {
            JSONValidator.validate((String)configuration, (InputStream)configurationJSONSchemaInputStream);
            JSONObject configurationJSONObject = JSONFactoryUtil.createJSONObject((String)configuration);
            JSONArray fieldSetsJSONArray = configurationJSONObject.getJSONArray("fieldSets");
            HashSet<String> fieldNames = new HashSet<String>();
            for (int fieldSetIndex = 0; fieldSetIndex < fieldSetsJSONArray.length(); ++fieldSetIndex) {
                JSONObject fieldSetJSONObject = fieldSetsJSONArray.getJSONObject(fieldSetIndex);
                JSONArray fieldsJSONArray = fieldSetJSONObject.getJSONArray("fields");
                for (int fieldIndex = 0; fieldIndex < fieldsJSONArray.length(); ++fieldIndex) {
                    JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(fieldIndex);
                    String fieldName = fieldJSONObject.getString("name");
                    if (fieldNames.contains(fieldName)) {
                        throw new FragmentEntryConfigurationException("Field names must be unique");
                    }
                    JSONObject typeOptionsJSONObject = fieldJSONObject.getJSONObject("typeOptions");
                    if (typeOptionsJSONObject != null) {
                        String value;
                        String defaultValue = fieldJSONObject.getString("defaultValue");
                        if (!this._checkValidationRules(defaultValue, typeOptionsJSONObject.getJSONObject("validation"))) {
                            throw new FragmentEntryConfigurationException("Invalid default configuration value for field " + fieldName);
                        }
                        if (valuesJSONObject != null && !this._checkValidationRules(value = valuesJSONObject.getString(fieldName), typeOptionsJSONObject.getJSONObject("validation"))) {
                            throw new FragmentEntryConfigurationException("Invalid configuration value for field " + fieldName);
                        }
                    }
                    fieldNames.add(fieldName);
                }
            }
        }
        catch (JSONException jsonException) {
            throw new FragmentEntryConfigurationException(this._getMessage(jsonException.getMessage()), (Throwable)jsonException);
        }
        catch (JSONValidatorException jsonValidatorException) {
            throw new FragmentEntryConfigurationException(this._getMessage(jsonValidatorException.getMessage()), (Throwable)jsonValidatorException);
        }
    }

    private boolean _checkValidationRules(String value, JSONObject validationJSONObject) {
        if (Validator.isNull((String)value) || validationJSONObject == null) {
            return true;
        }
        String type = validationJSONObject.getString("type");
        if (Objects.equals(type, "email")) {
            return Validator.isEmailAddress((String)value);
        }
        if (Objects.equals(type, "number")) {
            long max = validationJSONObject.getLong("max", Long.MAX_VALUE);
            long min = validationJSONObject.getLong("min", Long.MIN_VALUE);
            boolean valid = false;
            if (Validator.isNumber((String)value) && GetterUtil.getLong((String)value) <= max && GetterUtil.getLong((String)value) >= min) {
                valid = true;
            }
            return valid;
        }
        if (Objects.equals(type, "pattern")) {
            String regexp = validationJSONObject.getString("regexp");
            return value.matches(regexp);
        }
        if (Objects.equals(type, "url")) {
            return Validator.isUrl((String)value);
        }
        long maxLength = validationJSONObject.getLong("maxLength", Long.MAX_VALUE);
        long minLength = validationJSONObject.getLong("minLength", Long.MIN_VALUE);
        return (long)value.length() <= maxLength && (long)value.length() >= minLength;
    }

    private String _getMessage(String message) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
        StringBundler sb = new StringBundler(3);
        sb.append(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"fragment-configuration-is-invalid"));
        sb.append(System.lineSeparator());
        sb.append(message);
        return sb.toString();
    }
}

