/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.model.impl;

import com.liferay.fragment.model.FragmentComposition;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.impl.FragmentCollectionBaseImpl;
import com.liferay.fragment.service.FragmentCompositionLocalServiceUtil;
import com.liferay.fragment.service.FragmentEntryLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import java.util.List;

public class FragmentCollectionImpl
extends FragmentCollectionBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(FragmentCollectionImpl.class);
    private long _resourcesFolderId;

    public List<FileEntry> getResources() throws PortalException {
        long groupId = this.getGroupId();
        if (groupId == 0L) {
            Company company = CompanyLocalServiceUtil.getCompany((long)this.getCompanyId());
            groupId = company.getGroupId();
        }
        return PortletFileRepositoryUtil.getPortletFileEntries((long)groupId, (long)this.getResourcesFolderId());
    }

    public long getResourcesFolderId() throws PortalException {
        return this.getResourcesFolderId(true);
    }

    public long getResourcesFolderId(boolean createIfAbsent) throws PortalException {
        Repository repository;
        if (this._resourcesFolderId != 0L) {
            return this._resourcesFolderId;
        }
        long groupId = this.getGroupId();
        if (groupId == 0L) {
            User user = UserLocalServiceUtil.getUser((long)this.getUserId());
            groupId = user.getGroupId();
        }
        if ((repository = PortletFileRepositoryUtil.fetchPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet")) == null) {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (ServiceContext)serviceContext);
        }
        Folder folder = null;
        try {
            folder = PortletFileRepositoryUtil.getPortletFolder((long)repository.getRepositoryId(), (long)repository.getDlFolderId(), (String)String.valueOf(this.getFragmentCollectionId()));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            if (createIfAbsent) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddGroupPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                folder = PortletFileRepositoryUtil.addPortletFolder((long)this.getUserId(), (long)repository.getRepositoryId(), (long)repository.getDlFolderId(), (String)String.valueOf(this.getFragmentCollectionId()), (ServiceContext)serviceContext);
            }
            return 0L;
        }
        this._resourcesFolderId = folder.getFolderId();
        return this._resourcesFolderId;
    }

    public boolean hasResources() throws PortalException {
        int fileEntriesCount = PortletFileRepositoryUtil.getPortletFileEntriesCount((long)this.getGroupId(), (long)this.getResourcesFolderId());
        return fileEntriesCount > 0;
    }

    public void populateZipWriter(ZipWriter zipWriter) throws Exception {
        this.populateZipWriter(zipWriter, "");
    }

    public void populateZipWriter(ZipWriter zipWriter, String path) throws Exception {
        path = path + "/" + this.getFragmentCollectionKey();
        JSONObject jsonObject = JSONUtil.put((String)"description", (Object)this.getDescription()).put("name", this.getName());
        zipWriter.addEntry(path + "/" + "collection.json", jsonObject.toString());
        List fragmentCompositions = FragmentCompositionLocalServiceUtil.getFragmentCompositions((long)this.getFragmentCollectionId());
        for (FragmentComposition fragmentComposition : fragmentCompositions) {
            fragmentComposition.populateZipWriter(zipWriter, path + "/fragment-compositions");
        }
        List fragmentEntries = FragmentEntryLocalServiceUtil.getFragmentEntries((long)this.getFragmentCollectionId(), (int)-1, (int)-1);
        for (FragmentEntry fragmentEntry : fragmentEntries) {
            if (fragmentEntry.getType() == 2) continue;
            fragmentEntry.populateZipWriter(zipWriter, path + "/fragments");
        }
        if (!this.hasResources()) {
            return;
        }
        for (FileEntry fileEntry : this.getResources()) {
            StringBundler sb = new StringBundler(4);
            sb.append(path);
            sb.append("/");
            sb.append("resources/");
            sb.append(fileEntry.getFileName());
            zipWriter.addEntry(sb.toString(), fileEntry.getContentStream());
        }
    }
}

