/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.model.impl;

import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.fragment.model.impl.FragmentCompositionBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.zip.ZipWriter;

public class FragmentCompositionImpl
extends FragmentCompositionBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(FragmentCompositionImpl.class);
    private String _icon = "edit-layout";
    private String _imagePreviewURL;

    public JSONObject getDataJSONObject() throws Exception {
        return JSONFactoryUtil.createJSONObject((String)this.getData());
    }

    public String getIcon() {
        return this._icon;
    }

    public String getImagePreviewURL(ThemeDisplay themeDisplay) {
        if (Validator.isNotNull((String)this._imagePreviewURL)) {
            return this._imagePreviewURL;
        }
        try {
            FileEntry fileEntry = this._getPreviewFileEntry();
            if (fileEntry == null) {
                return "";
            }
            return DLUtil.getImagePreviewURL((FileEntry)fileEntry, (ThemeDisplay)themeDisplay);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get preview entry image URL", (Throwable)exception);
            return "";
        }
    }

    public void populateZipWriter(ZipWriter zipWriter, String path) throws Exception {
        path = path + "/" + this.getFragmentCompositionKey();
        JSONObject jsonObject = JSONUtil.put((String)"description", (Object)this.getDescription()).put("fragmentCompositionDefinitionPath", "fragment-composition-definition.json").put("name", this.getName());
        FileEntry previewFileEntry = this._getPreviewFileEntry();
        if (previewFileEntry != null) {
            jsonObject.put("thumbnailPath", "thumbnail." + previewFileEntry.getExtension());
        }
        zipWriter.addEntry(path + "/" + "fragment-composition.json", jsonObject.toString());
        zipWriter.addEntry(path + "/fragment-composition-definition.json", this.getData());
        if (previewFileEntry != null) {
            zipWriter.addEntry(path + "/thumbnail." + previewFileEntry.getExtension(), previewFileEntry.getContentStream());
        }
    }

    public void setIcon(String icon) {
        this._icon = icon;
    }

    public void setImagePreviewURL(String imagePreviewURL) {
        this._imagePreviewURL = imagePreviewURL;
    }

    private FileEntry _getPreviewFileEntry() {
        if (this.getPreviewFileEntryId() <= 0L) {
            return null;
        }
        try {
            return PortletFileRepositoryUtil.getPortletFileEntry((long)this.getPreviewFileEntryId());
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to get file entry preview ", (Throwable)portalException);
            }
            return null;
        }
    }
}

