/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.model.impl;

import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.fragment.constants.FragmentConstants;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.impl.FragmentEntryBaseImpl;
import com.liferay.fragment.service.FragmentEntryLinkLocalServiceUtil;
import com.liferay.fragment.service.FragmentEntryLocalServiceUtil;
import com.liferay.fragment.util.FragmentEntryRenderUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.zip.ZipWriter;

public class FragmentEntryImpl
extends FragmentEntryBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryImpl.class);
    private String _icon;
    private String _imagePreviewURL;

    public FragmentEntry fetchDraftFragmentEntry() {
        if (this.isDraft()) {
            return null;
        }
        return FragmentEntryLocalServiceUtil.fetchDraft((long)this.getFragmentEntryId());
    }

    public String getContent() {
        return FragmentEntryRenderUtil.renderFragmentEntry((FragmentEntry)this);
    }

    public int getGlobalUsageCount() {
        return FragmentEntryLinkLocalServiceUtil.getFragmentEntryLinksCountByFragmentEntryId((long)this.getFragmentEntryId());
    }

    public String getIcon() {
        if (this._icon == null) {
            this._icon = this.getType() == 2 ? "react" : "code";
        }
        return this._icon;
    }

    public String getImagePreviewURL(ThemeDisplay themeDisplay) {
        if (Validator.isNotNull((String)this._imagePreviewURL)) {
            return this._imagePreviewURL;
        }
        try {
            FileEntry fileEntry = this._getPreviewFileEntry();
            if (fileEntry == null) {
                return "";
            }
            return DLUtil.getImagePreviewURL((FileEntry)fileEntry, (ThemeDisplay)themeDisplay);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get preview entry image URL", (Throwable)exception);
            return "";
        }
    }

    @Override
    @JSON
    public int getStatus() {
        if (this.isHead()) {
            return 0;
        }
        return 2;
    }

    public String getTypeLabel() {
        return FragmentConstants.getTypeLabel((int)this.getType());
    }

    public int getUsageCount() {
        return FragmentEntryLinkLocalServiceUtil.getFragmentEntryLinksCount((long)this.getGroupId(), (long)this.getFragmentEntryId());
    }

    @Override
    public boolean isApproved() {
        return this.isHead();
    }

    @Override
    public boolean isDraft() {
        return !this.isHead();
    }

    public void populateZipWriter(ZipWriter zipWriter, String path) throws Exception {
        String typeLabel;
        path = path + "/" + this.getFragmentEntryKey();
        JSONObject jsonObject = JSONUtil.put((String)"configurationPath", (Object)"index.json").put("cssPath", "index.css").put("htmlPath", "index.html").put("jsPath", "index.js").put("name", this.getName());
        FileEntry previewFileEntry = this._getPreviewFileEntry();
        if (previewFileEntry != null) {
            jsonObject.put("thumbnailPath", "thumbnail." + previewFileEntry.getExtension());
        }
        if (Validator.isNotNull((String)(typeLabel = this.getTypeLabel()))) {
            jsonObject.put("type", typeLabel);
        }
        zipWriter.addEntry(path + "/" + "fragment.json", jsonObject.toString());
        zipWriter.addEntry(path + "/index.css", this.getCss());
        zipWriter.addEntry(path + "/index.js", this.getJs());
        zipWriter.addEntry(path + "/index.json", this.getConfiguration());
        zipWriter.addEntry(path + "/index.html", this.getHtml());
        if (previewFileEntry != null) {
            zipWriter.addEntry(path + "/thumbnail." + previewFileEntry.getExtension(), previewFileEntry.getContentStream());
        }
    }

    public void setIcon(String icon) {
        this._icon = icon;
    }

    public void setImagePreviewURL(String imagePreviewURL) {
        this._imagePreviewURL = imagePreviewURL;
    }

    private FileEntry _getPreviewFileEntry() {
        if (this.getPreviewFileEntryId() <= 0L) {
            return null;
        }
        try {
            return PortletFileRepositoryUtil.getPortletFileEntry((long)this.getPreviewFileEntryId());
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to get file entry preview ", (Throwable)portalException);
            }
            return null;
        }
    }
}

