/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryVersion;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.fragment.service.FragmentEntryLocalServiceUtil;
import com.liferay.fragment.service.persistence.FragmentCollectionPersistence;
import com.liferay.fragment.service.persistence.FragmentEntryFinder;
import com.liferay.fragment.service.persistence.FragmentEntryLinkFinder;
import com.liferay.fragment.service.persistence.FragmentEntryLinkPersistence;
import com.liferay.fragment.service.persistence.FragmentEntryPersistence;
import com.liferay.fragment.service.persistence.FragmentEntryVersionPersistence;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.version.VersionModel;
import com.liferay.portal.kernel.model.version.VersionedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.service.version.VersionService;
import com.liferay.portal.kernel.service.version.VersionServiceListener;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class FragmentEntryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
FragmentEntryLocalService,
IdentifiableOSGiService,
VersionService<FragmentEntry, FragmentEntryVersion> {
    private final Set<VersionServiceListener<FragmentEntry, FragmentEntryVersion>> _versionServiceListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    protected FragmentEntryLocalService fragmentEntryLocalService;
    @Reference
    protected FragmentEntryPersistence fragmentEntryPersistence;
    @Reference
    protected FragmentEntryFinder fragmentEntryFinder;
    @Reference
    protected CounterLocalService counterLocalService;
    @Reference
    protected FragmentCollectionPersistence fragmentCollectionPersistence;
    @Reference
    protected ResourceLocalService resourceLocalService;
    @Reference
    protected UserLocalService userLocalService;
    @Reference
    protected FragmentEntryVersionPersistence fragmentEntryVersionPersistence;
    @Reference
    protected FragmentEntryLinkPersistence fragmentEntryLinkPersistence;
    @Reference
    protected FragmentEntryLinkFinder fragmentEntryLinkFinder;

    @Indexable(type=IndexableType.REINDEX)
    public FragmentEntry addFragmentEntry(FragmentEntry fragmentEntry) {
        fragmentEntry.setNew(true);
        return (FragmentEntry)this.fragmentEntryPersistence.update((BaseModel)fragmentEntry);
    }

    @Transactional(enabled=false)
    public FragmentEntry create() {
        long primaryKey = this.counterLocalService.increment(FragmentEntry.class.getName());
        FragmentEntry draftFragmentEntry = this.fragmentEntryPersistence.create(primaryKey);
        draftFragmentEntry.setHeadId(primaryKey);
        return draftFragmentEntry;
    }

    @Indexable(type=IndexableType.DELETE)
    public FragmentEntry deleteFragmentEntry(long fragmentEntryId) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryPersistence.fetchByPrimaryKey(fragmentEntryId);
        if (fragmentEntry != null) {
            this.delete(fragmentEntry);
        }
        return fragmentEntry;
    }

    @Indexable(type=IndexableType.DELETE)
    public FragmentEntry deleteFragmentEntry(FragmentEntry fragmentEntry) throws PortalException {
        this.delete(fragmentEntry);
        return fragmentEntry;
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.fragmentEntryPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(FragmentEntry.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.fragmentEntryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.fragmentEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.fragmentEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.fragmentEntryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.fragmentEntryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public FragmentEntry fetchFragmentEntry(long fragmentEntryId) {
        return this.fragmentEntryPersistence.fetchByPrimaryKey(fragmentEntryId);
    }

    public FragmentEntry getFragmentEntry(long fragmentEntryId) throws PortalException {
        return this.fragmentEntryPersistence.findByPrimaryKey(fragmentEntryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.fragmentEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(FragmentEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("fragmentEntryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.fragmentEntryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(FragmentEntry.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("fragmentEntryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.fragmentEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(FragmentEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("fragmentEntryId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Disjunction disjunction;
                Criterion modifiedDateCriterion = portletDataContext.getDateRangeCriteria("modifiedDate");
                if (modifiedDateCriterion != null) {
                    Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                    conjunction.add(modifiedDateCriterion);
                    disjunction = RestrictionsFactoryUtil.disjunction();
                    disjunction.add(RestrictionsFactoryUtil.gtProperty((String)"modifiedDate", (String)"lastPublishDate"));
                    Property lastPublishDateProperty = PropertyFactoryUtil.forName((String)"lastPublishDate");
                    disjunction.add(lastPublishDateProperty.isNull());
                    conjunction.add((Criterion)disjunction);
                    modifiedDateCriterion = conjunction;
                }
                Criterion statusDateCriterion = portletDataContext.getDateRangeCriteria("statusDate");
                if (modifiedDateCriterion != null && statusDateCriterion != null) {
                    disjunction = RestrictionsFactoryUtil.disjunction();
                    disjunction.add(modifiedDateCriterion);
                    disjunction.add(statusDateCriterion);
                    dynamicQuery.add((Criterion)disjunction);
                }
                Property workflowStatusProperty = PropertyFactoryUtil.forName((String)"status");
                if (portletDataContext.isInitialPublication()) {
                    dynamicQuery.add(workflowStatusProperty.ne((Object)8));
                } else {
                    StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)FragmentEntry.class.getName());
                    dynamicQuery.add(workflowStatusProperty.in(stagedModelDataHandler.getExportableStatuses()));
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<FragmentEntry>(){

            public void performAction(FragmentEntry fragmentEntry) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)fragmentEntry);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)FragmentEntry.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.fragmentEntryPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.fragmentEntryLocalService.deleteFragmentEntry((FragmentEntry)persistedModel);
    }

    public BasePersistence<FragmentEntry> getBasePersistence() {
        return this.fragmentEntryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.fragmentEntryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<FragmentEntry> getFragmentEntries(int start, int end) {
        return this.fragmentEntryPersistence.findAll(start, end);
    }

    public int getFragmentEntriesCount() {
        return this.fragmentEntryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public FragmentEntry updateFragmentEntry(FragmentEntry draftFragmentEntry) throws PortalException {
        return this.updateDraft(draftFragmentEntry);
    }

    @Deactivate
    protected void deactivate() {
        this._setLocalServiceUtilService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{FragmentEntryLocalService.class, IdentifiableOSGiService.class, CTService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.fragmentEntryLocalService = (FragmentEntryLocalService)aopProxy;
        this._setLocalServiceUtilService(this.fragmentEntryLocalService);
    }

    @Indexable(type=IndexableType.REINDEX)
    public FragmentEntry checkout(FragmentEntry publishedFragmentEntry, int version) throws PortalException {
        if (!publishedFragmentEntry.isHead()) {
            throw new IllegalArgumentException("Unable to checkout with unpublished changes " + publishedFragmentEntry.getHeadId());
        }
        FragmentEntry draftFragmentEntry = this.fragmentEntryPersistence.fetchByHeadId(publishedFragmentEntry.getPrimaryKey());
        if (draftFragmentEntry != null) {
            throw new IllegalArgumentException("Unable to checkout with unpublished changes " + publishedFragmentEntry.getPrimaryKey());
        }
        FragmentEntryVersion fragmentEntryVersion = this.getVersion(publishedFragmentEntry, version);
        draftFragmentEntry = this._createDraft(publishedFragmentEntry);
        fragmentEntryVersion.populateVersionedModel((VersionedModel)draftFragmentEntry);
        draftFragmentEntry = (FragmentEntry)this.fragmentEntryPersistence.update((BaseModel)draftFragmentEntry);
        for (VersionServiceListener<FragmentEntry, FragmentEntryVersion> versionServiceListener : this._versionServiceListeners) {
            versionServiceListener.afterCheckout((VersionedModel)draftFragmentEntry, version);
        }
        return draftFragmentEntry;
    }

    @Indexable(type=IndexableType.DELETE)
    public FragmentEntry delete(FragmentEntry publishedFragmentEntry) throws PortalException {
        if (!publishedFragmentEntry.isHead()) {
            throw new IllegalArgumentException("FragmentEntry is a draft " + publishedFragmentEntry.getPrimaryKey());
        }
        FragmentEntry draftFragmentEntry = this.fragmentEntryPersistence.fetchByHeadId(publishedFragmentEntry.getPrimaryKey());
        if (draftFragmentEntry != null) {
            this.deleteDraft(draftFragmentEntry);
        }
        for (FragmentEntryVersion fragmentEntryVersion : this.getVersions(publishedFragmentEntry)) {
            this.fragmentEntryVersionPersistence.remove((BaseModel)fragmentEntryVersion);
        }
        this.fragmentEntryPersistence.remove((BaseModel)publishedFragmentEntry);
        for (VersionServiceListener versionServiceListener : this._versionServiceListeners) {
            versionServiceListener.afterDelete((VersionedModel)publishedFragmentEntry);
        }
        return publishedFragmentEntry;
    }

    @Indexable(type=IndexableType.DELETE)
    public FragmentEntry deleteDraft(FragmentEntry draftFragmentEntry) throws PortalException {
        if (draftFragmentEntry.isHead()) {
            throw new IllegalArgumentException("FragmentEntry is not a draft " + draftFragmentEntry.getPrimaryKey());
        }
        this.fragmentEntryPersistence.remove((BaseModel)draftFragmentEntry);
        for (VersionServiceListener<FragmentEntry, FragmentEntryVersion> versionServiceListener : this._versionServiceListeners) {
            versionServiceListener.afterDeleteDraft((VersionedModel)draftFragmentEntry);
        }
        return draftFragmentEntry;
    }

    public FragmentEntryVersion deleteVersion(FragmentEntryVersion fragmentEntryVersion) throws PortalException {
        FragmentEntryVersion latestFragmentEntryVersion = this.fragmentEntryVersionPersistence.findByFragmentEntryId_First(fragmentEntryVersion.getVersionedModelId(), null);
        if (latestFragmentEntryVersion.getVersion() == fragmentEntryVersion.getVersion()) {
            throw new IllegalArgumentException("Unable to delete latest version " + fragmentEntryVersion.getVersion());
        }
        fragmentEntryVersion = (FragmentEntryVersion)this.fragmentEntryVersionPersistence.remove((BaseModel)fragmentEntryVersion);
        for (VersionServiceListener<FragmentEntry, FragmentEntryVersion> versionServiceListener : this._versionServiceListeners) {
            versionServiceListener.afterDeleteVersion((VersionModel)fragmentEntryVersion);
        }
        return fragmentEntryVersion;
    }

    public FragmentEntry fetchDraft(FragmentEntry fragmentEntry) {
        if (fragmentEntry.isHead()) {
            return this.fragmentEntryPersistence.fetchByHeadId(fragmentEntry.getPrimaryKey());
        }
        return fragmentEntry;
    }

    public FragmentEntry fetchDraft(long primaryKey) {
        return this.fragmentEntryPersistence.fetchByHeadId(primaryKey);
    }

    public FragmentEntryVersion fetchLatestVersion(FragmentEntry fragmentEntry) {
        long primaryKey = fragmentEntry.getHeadId();
        if (fragmentEntry.isHead()) {
            primaryKey = fragmentEntry.getPrimaryKey();
        }
        return this.fragmentEntryVersionPersistence.fetchByFragmentEntryId_First(primaryKey, null);
    }

    public FragmentEntry fetchPublished(FragmentEntry fragmentEntry) {
        if (fragmentEntry.isHead()) {
            return fragmentEntry;
        }
        if (fragmentEntry.getHeadId() == fragmentEntry.getPrimaryKey()) {
            return null;
        }
        return this.fragmentEntryPersistence.fetchByPrimaryKey(fragmentEntry.getHeadId());
    }

    public FragmentEntry fetchPublished(long primaryKey) {
        FragmentEntry fragmentEntry = this.fragmentEntryPersistence.fetchByPrimaryKey(primaryKey);
        if (fragmentEntry == null || fragmentEntry.getHeadId() == fragmentEntry.getPrimaryKey()) {
            return null;
        }
        return fragmentEntry;
    }

    public FragmentEntry getDraft(FragmentEntry fragmentEntry) throws PortalException {
        if (!fragmentEntry.isHead()) {
            return fragmentEntry;
        }
        FragmentEntry draftFragmentEntry = this.fragmentEntryPersistence.fetchByHeadId(fragmentEntry.getPrimaryKey());
        if (draftFragmentEntry == null) {
            draftFragmentEntry = this.fragmentEntryLocalService.updateDraft(this._createDraft(fragmentEntry));
        }
        return draftFragmentEntry;
    }

    public FragmentEntry getDraft(long primaryKey) throws PortalException {
        FragmentEntry draftFragmentEntry = this.fragmentEntryPersistence.fetchByHeadId(primaryKey);
        if (draftFragmentEntry == null) {
            FragmentEntry fragmentEntry = this.fragmentEntryPersistence.findByPrimaryKey(primaryKey);
            draftFragmentEntry = this.fragmentEntryLocalService.updateDraft(this._createDraft(fragmentEntry));
        }
        return draftFragmentEntry;
    }

    public FragmentEntryVersion getVersion(FragmentEntry fragmentEntry, int version) throws PortalException {
        long primaryKey = fragmentEntry.getHeadId();
        if (fragmentEntry.isHead()) {
            primaryKey = fragmentEntry.getPrimaryKey();
        }
        return this.fragmentEntryVersionPersistence.findByFragmentEntryId_Version(primaryKey, version);
    }

    public List<FragmentEntryVersion> getVersions(FragmentEntry fragmentEntry) {
        long primaryKey = fragmentEntry.getPrimaryKey();
        if (!fragmentEntry.isHead()) {
            if (fragmentEntry.getHeadId() == fragmentEntry.getPrimaryKey()) {
                return Collections.emptyList();
            }
            primaryKey = fragmentEntry.getHeadId();
        }
        return this.fragmentEntryVersionPersistence.findByFragmentEntryId(primaryKey);
    }

    @Indexable(type=IndexableType.REINDEX)
    public FragmentEntry publishDraft(FragmentEntry draftFragmentEntry) throws PortalException {
        if (draftFragmentEntry.isHead()) {
            throw new IllegalArgumentException("Can only publish drafts " + draftFragmentEntry.getPrimaryKey());
        }
        FragmentEntry headFragmentEntry = null;
        int version = 1;
        if (draftFragmentEntry.getHeadId() == draftFragmentEntry.getPrimaryKey()) {
            headFragmentEntry = this.create();
            draftFragmentEntry.setHeadId(headFragmentEntry.getPrimaryKey());
        } else {
            headFragmentEntry = this.fragmentEntryPersistence.findByPrimaryKey(draftFragmentEntry.getHeadId());
            FragmentEntryVersion latestFragmentEntryVersion = this.fragmentEntryVersionPersistence.findByFragmentEntryId_First(draftFragmentEntry.getHeadId(), null);
            version = latestFragmentEntryVersion.getVersion() + 1;
        }
        FragmentEntryVersion fragmentEntryVersion = this.fragmentEntryVersionPersistence.create(this.counterLocalService.increment(FragmentEntryVersion.class.getName()));
        fragmentEntryVersion.setVersion(version);
        fragmentEntryVersion.setVersionedModelId(headFragmentEntry.getPrimaryKey());
        draftFragmentEntry.populateVersionModel((VersionModel)fragmentEntryVersion);
        this.fragmentEntryVersionPersistence.update((BaseModel)fragmentEntryVersion);
        fragmentEntryVersion.populateVersionedModel((VersionedModel)headFragmentEntry);
        headFragmentEntry.setHeadId(-headFragmentEntry.getPrimaryKey());
        headFragmentEntry = (FragmentEntry)this.fragmentEntryPersistence.update((BaseModel)headFragmentEntry);
        for (VersionServiceListener<FragmentEntry, FragmentEntryVersion> versionServiceListener : this._versionServiceListeners) {
            versionServiceListener.afterPublishDraft((VersionedModel)draftFragmentEntry, version);
        }
        this.deleteDraft(draftFragmentEntry);
        return headFragmentEntry;
    }

    public void registerListener(VersionServiceListener<FragmentEntry, FragmentEntryVersion> versionServiceListener) {
        this._versionServiceListeners.add(versionServiceListener);
    }

    public void unregisterListener(VersionServiceListener<FragmentEntry, FragmentEntryVersion> versionServiceListener) {
        this._versionServiceListeners.remove(versionServiceListener);
    }

    @Indexable(type=IndexableType.REINDEX)
    public FragmentEntry updateDraft(FragmentEntry draftFragmentEntry) throws PortalException {
        if (draftFragmentEntry.isHead()) {
            throw new IllegalArgumentException("Can only update draft entries " + draftFragmentEntry.getPrimaryKey());
        }
        FragmentEntry previousFragmentEntry = this.fragmentEntryPersistence.fetchByPrimaryKey(draftFragmentEntry.getPrimaryKey());
        draftFragmentEntry = (FragmentEntry)this.fragmentEntryPersistence.update((BaseModel)draftFragmentEntry);
        if (previousFragmentEntry == null) {
            for (VersionServiceListener<FragmentEntry, FragmentEntryVersion> versionServiceListener : this._versionServiceListeners) {
                versionServiceListener.afterCreateDraft((VersionedModel)draftFragmentEntry);
            }
        } else {
            for (VersionServiceListener<FragmentEntry, FragmentEntryVersion> versionServiceListener : this._versionServiceListeners) {
                versionServiceListener.afterUpdateDraft((VersionedModel)draftFragmentEntry);
            }
        }
        return draftFragmentEntry;
    }

    private FragmentEntry _createDraft(FragmentEntry publishedFragmentEntry) throws PortalException {
        FragmentEntry draftFragmentEntry = this.create();
        draftFragmentEntry.setCtCollectionId(publishedFragmentEntry.getCtCollectionId());
        draftFragmentEntry.setUuid(publishedFragmentEntry.getUuid());
        draftFragmentEntry.setHeadId(publishedFragmentEntry.getPrimaryKey());
        draftFragmentEntry.setGroupId(publishedFragmentEntry.getGroupId());
        draftFragmentEntry.setCompanyId(publishedFragmentEntry.getCompanyId());
        draftFragmentEntry.setUserId(publishedFragmentEntry.getUserId());
        draftFragmentEntry.setUserName(publishedFragmentEntry.getUserName());
        draftFragmentEntry.setCreateDate(publishedFragmentEntry.getCreateDate());
        draftFragmentEntry.setModifiedDate(publishedFragmentEntry.getModifiedDate());
        draftFragmentEntry.setFragmentCollectionId(publishedFragmentEntry.getFragmentCollectionId());
        draftFragmentEntry.setFragmentEntryKey(publishedFragmentEntry.getFragmentEntryKey());
        draftFragmentEntry.setName(publishedFragmentEntry.getName());
        draftFragmentEntry.setCss(publishedFragmentEntry.getCss());
        draftFragmentEntry.setHtml(publishedFragmentEntry.getHtml());
        draftFragmentEntry.setJs(publishedFragmentEntry.getJs());
        draftFragmentEntry.setCacheable(publishedFragmentEntry.getCacheable());
        draftFragmentEntry.setConfiguration(publishedFragmentEntry.getConfiguration());
        draftFragmentEntry.setPreviewFileEntryId(publishedFragmentEntry.getPreviewFileEntryId());
        draftFragmentEntry.setReadOnly(publishedFragmentEntry.getReadOnly());
        draftFragmentEntry.setType(publishedFragmentEntry.getType());
        draftFragmentEntry.setLastPublishDate(publishedFragmentEntry.getLastPublishDate());
        draftFragmentEntry.setStatus(publishedFragmentEntry.getStatus());
        draftFragmentEntry.setStatusByUserId(publishedFragmentEntry.getStatusByUserId());
        draftFragmentEntry.setStatusByUserName(publishedFragmentEntry.getStatusByUserName());
        draftFragmentEntry.setStatusDate(publishedFragmentEntry.getStatusDate());
        draftFragmentEntry.resetOriginalValues();
        return draftFragmentEntry;
    }

    public String getOSGiServiceIdentifier() {
        return FragmentEntryLocalService.class.getName();
    }

    public CTPersistence<FragmentEntry> getCTPersistence() {
        return this.fragmentEntryPersistence;
    }

    public Class<FragmentEntry> getModelClass() {
        return FragmentEntry.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<FragmentEntry>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.fragmentEntryPersistence);
    }

    protected String getModelClassName() {
        return FragmentEntry.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.fragmentEntryPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _setLocalServiceUtilService(FragmentEntryLocalService fragmentEntryLocalService) {
        try {
            Field field = FragmentEntryLocalServiceUtil.class.getDeclaredField("_service");
            field.setAccessible(true);
            field.set(null, fragmentEntryLocalService);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

