/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.service.impl;

import com.liferay.fragment.exception.DuplicateFragmentCollectionKeyException;
import com.liferay.fragment.exception.FragmentCollectionNameException;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentComposition;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.service.FragmentCompositionLocalService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.fragment.service.base.FragmentCollectionLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.fragment.model.FragmentCollection"}, service={AopService.class})
public class FragmentCollectionLocalServiceImpl
extends FragmentCollectionLocalServiceBaseImpl {
    @Reference
    private FragmentCompositionLocalService _fragmentCompositionLocalService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;

    public FragmentCollection addFragmentCollection(long userId, long groupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return this.addFragmentCollection(userId, groupId, "", name, description, serviceContext);
    }

    public FragmentCollection addFragmentCollection(long userId, long groupId, String fragmentCollectionKey, String name, String description, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long companyId = user.getCompanyId();
        if (serviceContext != null) {
            companyId = serviceContext.getCompanyId();
        } else {
            serviceContext = new ServiceContext();
        }
        this.validate(name);
        if (Validator.isNull((String)fragmentCollectionKey)) {
            fragmentCollectionKey = this.generateFragmentCollectionKey(groupId, name);
        }
        fragmentCollectionKey = this._getFragmentCollectionKey(fragmentCollectionKey);
        this.validateFragmentCollectionKey(groupId, fragmentCollectionKey);
        long fragmentCollectionId = this.counterLocalService.increment();
        FragmentCollection fragmentCollection = this.fragmentCollectionPersistence.create(fragmentCollectionId);
        fragmentCollection.setUuid(serviceContext.getUuid());
        fragmentCollection.setGroupId(groupId);
        fragmentCollection.setCompanyId(companyId);
        fragmentCollection.setUserId(user.getUserId());
        fragmentCollection.setUserName(user.getFullName());
        fragmentCollection.setCreateDate(serviceContext.getCreateDate(new Date()));
        fragmentCollection.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        fragmentCollection.setFragmentCollectionKey(fragmentCollectionKey);
        fragmentCollection.setName(name);
        fragmentCollection.setDescription(description);
        return (FragmentCollection)this.fragmentCollectionPersistence.update((BaseModel)fragmentCollection);
    }

    @Override
    @SystemEvent(type=1)
    public FragmentCollection deleteFragmentCollection(FragmentCollection fragmentCollection) throws PortalException {
        this.fragmentCollectionPersistence.remove((BaseModel)fragmentCollection);
        this.resourceLocalService.deleteResource(fragmentCollection.getCompanyId(), FragmentCollection.class.getName(), 4, fragmentCollection.getFragmentCollectionId());
        PortletFileRepositoryUtil.deletePortletFolder((long)fragmentCollection.getResourcesFolderId(false));
        List fragmentCompositions = this.fragmentCompositionPersistence.findByFragmentCollectionId(fragmentCollection.getFragmentCollectionId());
        for (FragmentComposition fragmentComposition : fragmentCompositions) {
            this._fragmentCompositionLocalService.deleteFragmentComposition(fragmentComposition);
        }
        List fragmentEntries = this.fragmentEntryPersistence.findByFragmentCollectionId(fragmentCollection.getFragmentCollectionId());
        for (FragmentEntry fragmentEntry : fragmentEntries) {
            this._fragmentEntryLocalService.deleteFragmentEntry(fragmentEntry);
        }
        return fragmentCollection;
    }

    @Override
    public FragmentCollection deleteFragmentCollection(long fragmentCollectionId) throws PortalException {
        return this.fragmentCollectionLocalService.deleteFragmentCollection(this.getFragmentCollection(fragmentCollectionId));
    }

    @Override
    public FragmentCollection fetchFragmentCollection(long fragmentCollectionId) {
        return this.fragmentCollectionPersistence.fetchByPrimaryKey(fragmentCollectionId);
    }

    public FragmentCollection fetchFragmentCollection(long groupId, String fragmentCollectionKey) {
        return this.fragmentCollectionPersistence.fetchByG_FCK(groupId, this._getFragmentCollectionKey(fragmentCollectionKey));
    }

    public String generateFragmentCollectionKey(long groupId, String name) {
        String fragmentCollectionKey = this._getFragmentCollectionKey(name);
        String curFragmentCollectionKey = fragmentCollectionKey = StringUtil.replace((String)fragmentCollectionKey, (char)' ', (char)'-');
        int count = 0;
        FragmentCollection fragmentCollection;
        while ((fragmentCollection = this.fragmentCollectionPersistence.fetchByG_FCK(groupId, curFragmentCollectionKey)) != null) {
            curFragmentCollectionKey = fragmentCollectionKey + '-' + count++;
        }
        return curFragmentCollectionKey;
    }

    public List<FragmentCollection> getFragmentCollections(long groupId, int start, int end) {
        return this.getFragmentCollections(groupId, start, end, null);
    }

    public List<FragmentCollection> getFragmentCollections(long groupId, int start, int end, OrderByComparator<FragmentCollection> orderByComparator) {
        return this.fragmentCollectionPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<FragmentCollection> getFragmentCollections(long groupId, String name, int start, int end, OrderByComparator<FragmentCollection> orderByComparator) {
        if (Validator.isNull((String)name)) {
            return this.fragmentCollectionPersistence.findByGroupId(groupId, start, end, orderByComparator);
        }
        return this.fragmentCollectionPersistence.findByG_LikeN(groupId, name, start, end, orderByComparator);
    }

    public String[] getTempFileNames(long userId, long groupId, String folderName) throws PortalException {
        return TempFileEntryUtil.getTempFileNames((long)groupId, (long)userId, (String)folderName);
    }

    public FragmentCollection updateFragmentCollection(long fragmentCollectionId, String name, String description) throws PortalException {
        FragmentCollection fragmentCollection = this.fragmentCollectionPersistence.findByPrimaryKey(fragmentCollectionId);
        this.validate(name);
        fragmentCollection.setModifiedDate(new Date());
        fragmentCollection.setName(name);
        fragmentCollection.setDescription(description);
        return (FragmentCollection)this.fragmentCollectionPersistence.update((BaseModel)fragmentCollection);
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new FragmentCollectionNameException("Name must not be null");
        }
        if (name.contains(".") || name.contains("/")) {
            throw new FragmentCollectionNameException("Name contains invalid characters");
        }
    }

    protected void validateFragmentCollectionKey(long groupId, String fragmentCollectionKey) throws PortalException {
        FragmentCollection fragmentCollection = this.fragmentCollectionPersistence.fetchByG_FCK(groupId, fragmentCollectionKey = this._getFragmentCollectionKey(fragmentCollectionKey));
        if (fragmentCollection != null) {
            throw new DuplicateFragmentCollectionKeyException();
        }
    }

    private String _getFragmentCollectionKey(String fragmentCollectionKey) {
        if (fragmentCollectionKey != null) {
            fragmentCollectionKey = fragmentCollectionKey.trim();
            return StringUtil.toLowerCase((String)fragmentCollectionKey);
        }
        return "";
    }
}

