/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.service.impl;

import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.fragment.service.base.FragmentCollectionServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=fragment", "json.web.service.context.path=FragmentCollection"}, service={AopService.class})
public class FragmentCollectionServiceImpl
extends FragmentCollectionServiceBaseImpl {
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference(target="(resource.name=com.liferay.fragment)")
    private PortletResourcePermission _portletResourcePermission;

    public FragmentCollection addFragmentCollection(long groupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentCollectionLocalService.addFragmentCollection(this.getUserId(), groupId, name, description, serviceContext);
    }

    public FragmentCollection addFragmentCollection(long groupId, String fragmentCollectionKey, String name, String description, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentCollectionLocalService.addFragmentCollection(this.getUserId(), groupId, fragmentCollectionKey, name, description, serviceContext);
    }

    public FragmentCollection deleteFragmentCollection(long fragmentCollectionId) throws PortalException {
        FragmentCollection fragmentCollection = this.fragmentCollectionLocalService.getFragmentCollection(fragmentCollectionId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentCollection.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentCollectionLocalService.deleteFragmentCollection(fragmentCollection);
    }

    public void deleteFragmentCollections(long[] fragmentCollectionIds) throws PortalException {
        for (long fragmentCollectionId : fragmentCollectionIds) {
            FragmentCollection fragmentCollection = this.fragmentCollectionLocalService.getFragmentCollection(fragmentCollectionId);
            this._portletResourcePermission.check(this.getPermissionChecker(), fragmentCollection.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
            this.fragmentCollectionLocalService.deleteFragmentCollection(fragmentCollection);
        }
    }

    public FragmentCollection fetchFragmentCollection(long fragmentCollectionId) throws PortalException {
        return this.fragmentCollectionLocalService.fetchFragmentCollection(fragmentCollectionId);
    }

    public List<FragmentCollection> getFragmentCollections(long groupId) {
        return this.getFragmentCollections(groupId, false);
    }

    public List<FragmentCollection> getFragmentCollections(long groupId, boolean includeSystem) {
        return this.fragmentCollectionPersistence.findByGroupId(this._getGroupIds(groupId, includeSystem));
    }

    public List<FragmentCollection> getFragmentCollections(long groupId, boolean includeSystem, int start, int end, OrderByComparator<FragmentCollection> orderByComparator) {
        return this.fragmentCollectionPersistence.findByGroupId(this._getGroupIds(groupId, includeSystem), start, end, orderByComparator);
    }

    public List<FragmentCollection> getFragmentCollections(long groupId, int start, int end) {
        return this.fragmentCollectionPersistence.findByGroupId(groupId, start, end);
    }

    public List<FragmentCollection> getFragmentCollections(long groupId, int start, int end, OrderByComparator<FragmentCollection> orderByComparator) {
        return this.getFragmentCollections(groupId, false, start, end, orderByComparator);
    }

    public List<FragmentCollection> getFragmentCollections(long groupId, String name, boolean includeSystem, int start, int end, OrderByComparator<FragmentCollection> orderByComparator) {
        return this.fragmentCollectionPersistence.findByG_LikeN(this._getGroupIds(groupId, includeSystem), this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], start, end, orderByComparator);
    }

    public List<FragmentCollection> getFragmentCollections(long groupId, String name, int start, int end, OrderByComparator<FragmentCollection> orderByComparator) {
        return this.getFragmentCollections(groupId, name, false, start, end, orderByComparator);
    }

    public List<FragmentCollection> getFragmentCollections(long[] groupIds) {
        ArrayList<FragmentCollection> fragmentCollections = new ArrayList<FragmentCollection>();
        for (long groupId : groupIds) {
            fragmentCollections.addAll(this.getFragmentCollections(groupId));
        }
        return fragmentCollections;
    }

    public List<FragmentCollection> getFragmentCollections(long[] groupIds, int start, int end, OrderByComparator<FragmentCollection> orderByComparator) {
        return this.fragmentCollectionPersistence.findByGroupId(groupIds, start, end, orderByComparator);
    }

    public List<FragmentCollection> getFragmentCollections(long[] groupIds, String name, int start, int end, OrderByComparator<FragmentCollection> orderByComparator) {
        return this.fragmentCollectionPersistence.findByG_LikeN(groupIds, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], start, end, orderByComparator);
    }

    public int getFragmentCollectionsCount(long groupId) {
        return this.getFragmentCollectionsCount(groupId, false);
    }

    public int getFragmentCollectionsCount(long groupId, boolean includeSystem) {
        return this.fragmentCollectionPersistence.countByGroupId(this._getGroupIds(groupId, includeSystem));
    }

    public int getFragmentCollectionsCount(long groupId, String name) {
        return this.getFragmentCollectionsCount(groupId, name, false);
    }

    public int getFragmentCollectionsCount(long groupId, String name, boolean includeSystem) {
        return this.fragmentCollectionPersistence.countByG_LikeN(this._getGroupIds(groupId, includeSystem), this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0]);
    }

    public int getFragmentCollectionsCount(long[] groupIds) {
        return this.fragmentCollectionPersistence.countByGroupId(groupIds);
    }

    public int getFragmentCollectionsCount(long[] groupIds, String name) {
        return this.fragmentCollectionPersistence.countByG_LikeN(groupIds, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0]);
    }

    public String[] getTempFileNames(long groupId, String folderName) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_FRAGMENT_ENTRIES");
        return this._fragmentEntryLocalService.getTempFileNames(this.getUserId(), groupId, folderName);
    }

    public FragmentCollection updateFragmentCollection(long fragmentCollectionId, String name, String description) throws PortalException {
        FragmentCollection fragmentCollection = this.fragmentCollectionLocalService.getFragmentCollection(fragmentCollectionId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentCollection.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentCollectionLocalService.updateFragmentCollection(fragmentCollectionId, name, description);
    }

    private long[] _getGroupIds(long groupId, boolean includeSystem) {
        long[] groupIds = new long[]{groupId};
        if (includeSystem) {
            groupIds = ArrayUtil.append((long[])groupIds, (long)0L);
        }
        return groupIds;
    }
}

