/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.service.impl;

import com.liferay.fragment.exception.DuplicateFragmentCompositionKeyException;
import com.liferay.fragment.exception.FragmentCompositionNameException;
import com.liferay.fragment.model.FragmentComposition;
import com.liferay.fragment.service.base.FragmentCompositionLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.fragment.model.FragmentComposition"}, service={AopService.class})
public class FragmentCompositionLocalServiceImpl
extends FragmentCompositionLocalServiceBaseImpl {
    @Reference
    private CustomSQL _customSQL;

    public FragmentComposition addFragmentComposition(long userId, long groupId, long fragmentCollectionId, String fragmentCompositionKey, String name, String description, String data, long previewFileEntryId, int status, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        if (Validator.isNull((String)fragmentCompositionKey)) {
            fragmentCompositionKey = this.generateFragmentCompositionKey(groupId, name);
        }
        fragmentCompositionKey = this._getFragmentCompositionKey(fragmentCompositionKey);
        this.validate(name);
        this.validateFragmentCompositionKey(groupId, fragmentCompositionKey);
        long fragmentCompositionId = this.counterLocalService.increment();
        FragmentComposition fragmentComposition = this.fragmentCompositionPersistence.create(fragmentCompositionId);
        fragmentComposition.setUuid(serviceContext.getUuid());
        fragmentComposition.setGroupId(groupId);
        fragmentComposition.setCompanyId(user.getCompanyId());
        fragmentComposition.setUserId(user.getUserId());
        fragmentComposition.setUserName(user.getFullName());
        fragmentComposition.setCreateDate(serviceContext.getCreateDate(new Date()));
        fragmentComposition.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        fragmentComposition.setFragmentCollectionId(fragmentCollectionId);
        fragmentComposition.setFragmentCompositionKey(fragmentCompositionKey);
        fragmentComposition.setName(name);
        fragmentComposition.setDescription(description);
        fragmentComposition.setData(data);
        fragmentComposition.setPreviewFileEntryId(previewFileEntryId);
        fragmentComposition.setStatus(status);
        fragmentComposition.setStatusByUserId(userId);
        fragmentComposition.setStatusByUserName(user.getFullName());
        fragmentComposition.setStatusDate(new Date());
        return (FragmentComposition)this.fragmentCompositionPersistence.update((BaseModel)fragmentComposition);
    }

    @Override
    @SystemEvent(type=1)
    public FragmentComposition deleteFragmentComposition(FragmentComposition fragmentComposition) throws PortalException {
        this.fragmentCompositionPersistence.remove((BaseModel)fragmentComposition);
        this.resourceLocalService.deleteResource(fragmentComposition.getCompanyId(), FragmentComposition.class.getName(), 4, fragmentComposition.getFragmentCompositionId());
        if (fragmentComposition.getPreviewFileEntryId() > 0L) {
            PortletFileRepositoryUtil.deletePortletFileEntry((long)fragmentComposition.getPreviewFileEntryId());
        }
        return fragmentComposition;
    }

    @Override
    public FragmentComposition deleteFragmentComposition(long fragmentCompositionId) throws PortalException {
        return this.fragmentCompositionLocalService.deleteFragmentComposition(this.getFragmentComposition(fragmentCompositionId));
    }

    @Override
    public FragmentComposition fetchFragmentComposition(long fragmentCompositionId) {
        return this.fragmentCompositionPersistence.fetchByPrimaryKey(fragmentCompositionId);
    }

    public FragmentComposition fetchFragmentComposition(long groupId, String fragmentCompositionKey) {
        return this.fragmentCompositionPersistence.fetchByG_FCK(groupId, this._getFragmentCompositionKey(fragmentCompositionKey));
    }

    public String generateFragmentCompositionKey(long groupId, String name) {
        String fragmentCompositionKey = this._getFragmentCompositionKey(name);
        String curFragmentCompositionKey = fragmentCompositionKey = StringUtil.replace((String)fragmentCompositionKey, (char)' ', (char)'-');
        int count = 0;
        FragmentComposition fragmentComposition;
        while ((fragmentComposition = this.fragmentCompositionPersistence.fetchByG_FCK(groupId, curFragmentCompositionKey)) != null) {
            curFragmentCompositionKey = fragmentCompositionKey + '-' + count++;
        }
        return curFragmentCompositionKey;
    }

    public List<FragmentComposition> getFragmentCompositions(long fragmentCollectionId) {
        return this.fragmentCompositionPersistence.findByFragmentCollectionId(fragmentCollectionId);
    }

    public List<FragmentComposition> getFragmentCompositions(long fragmentCollectionId, int start, int end) {
        return this.fragmentCompositionPersistence.findByFragmentCollectionId(fragmentCollectionId, start, end);
    }

    public List<FragmentComposition> getFragmentCompositions(long groupId, long fragmentCollectionId, int status) {
        return this.fragmentCompositionPersistence.findByG_FCI_S(groupId, fragmentCollectionId, status);
    }

    public List<FragmentComposition> getFragmentCompositions(long groupId, long fragmentCollectionId, int start, int end, OrderByComparator<FragmentComposition> orderByComparator) {
        return this.fragmentCompositionPersistence.findByG_FCI(groupId, fragmentCollectionId, start, end, orderByComparator);
    }

    public List<FragmentComposition> getFragmentCompositions(long groupId, long fragmentCollectionId, String name, int start, int end, OrderByComparator<FragmentComposition> orderByComparator) {
        if (Validator.isNull((String)name)) {
            return this.fragmentCompositionPersistence.findByG_FCI(groupId, fragmentCollectionId, start, end, orderByComparator);
        }
        return this.fragmentCompositionPersistence.findByG_FCI_LikeN(groupId, fragmentCollectionId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], start, end, orderByComparator);
    }

    public int getFragmentCompositionsCount(long fragmentCollectionId) {
        return this.fragmentCompositionPersistence.countByFragmentCollectionId(fragmentCollectionId);
    }

    public String[] getTempFileNames(long userId, long groupId, String folderName) throws PortalException {
        return TempFileEntryUtil.getTempFileNames((long)groupId, (long)userId, (String)folderName);
    }

    public FragmentComposition moveFragmentComposition(long fragmentCompositionId, long fragmentCollectionId) throws PortalException {
        FragmentComposition fragmentComposition = this.fragmentCompositionPersistence.findByPrimaryKey(fragmentCompositionId);
        if (fragmentComposition.getFragmentCollectionId() == fragmentCollectionId) {
            return fragmentComposition;
        }
        fragmentComposition.setFragmentCollectionId(fragmentCollectionId);
        return (FragmentComposition)this.fragmentCompositionPersistence.update((BaseModel)fragmentComposition);
    }

    public FragmentComposition updateFragmentComposition(long fragmentCompositionId, long previewFileEntryId) throws PortalException {
        FragmentComposition fragmentComposition = this.fragmentCompositionPersistence.findByPrimaryKey(fragmentCompositionId);
        fragmentComposition.setModifiedDate(new Date());
        fragmentComposition.setPreviewFileEntryId(previewFileEntryId);
        return (FragmentComposition)this.fragmentCompositionPersistence.update((BaseModel)fragmentComposition);
    }

    public FragmentComposition updateFragmentComposition(long userId, long fragmentCompositionId, long fragmentCollectionId, String name, String description, String data, long previewFileEntryId, int status) throws PortalException {
        FragmentComposition fragmentComposition = this.fragmentCompositionPersistence.findByPrimaryKey(fragmentCompositionId);
        this.validate(name);
        User user = this.userLocalService.getUser(userId);
        fragmentComposition.setModifiedDate(new Date());
        fragmentComposition.setFragmentCollectionId(fragmentCollectionId);
        fragmentComposition.setName(name);
        fragmentComposition.setDescription(description);
        fragmentComposition.setData(data);
        fragmentComposition.setPreviewFileEntryId(previewFileEntryId);
        fragmentComposition.setStatus(status);
        fragmentComposition.setStatusByUserId(userId);
        fragmentComposition.setStatusByUserName(user.getFullName());
        fragmentComposition.setStatusDate(new Date());
        return (FragmentComposition)this.fragmentCompositionPersistence.update((BaseModel)fragmentComposition);
    }

    @Deprecated
    public FragmentComposition updateFragmentComposition(long userId, long fragmentCompositionId, String name, String description, String data, long previewFileEntryId, int status) throws PortalException {
        FragmentComposition fragmentComposition = this.fragmentCompositionPersistence.findByPrimaryKey(fragmentCompositionId);
        return this.updateFragmentComposition(userId, fragmentCompositionId, fragmentComposition.getFragmentCollectionId(), name, description, data, previewFileEntryId, status);
    }

    public FragmentComposition updateFragmentComposition(long fragmentCompositionId, String name) throws PortalException {
        FragmentComposition fragmentComposition = this.fragmentCompositionPersistence.findByPrimaryKey(fragmentCompositionId);
        this.validate(name);
        fragmentComposition.setName(name);
        return (FragmentComposition)this.fragmentCompositionPersistence.update((BaseModel)fragmentComposition);
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new FragmentCompositionNameException("Name must not be null");
        }
        if (name.contains(".") || name.contains("/")) {
            throw new FragmentCompositionNameException("Name contains invalid characters");
        }
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)FragmentComposition.class.getName(), (String)"name");
        if (name.length() > nameMaxLength) {
            throw new FragmentCompositionNameException("Maximum length of name exceeded");
        }
    }

    protected void validateFragmentCompositionKey(long groupId, String fragmentCompositionKey) throws PortalException {
        FragmentComposition fragmentComposition = this.fragmentCompositionPersistence.fetchByG_FCK(groupId, fragmentCompositionKey = this._getFragmentCompositionKey(fragmentCompositionKey));
        if (fragmentComposition != null) {
            throw new DuplicateFragmentCompositionKeyException();
        }
    }

    private String _getFragmentCompositionKey(String fragmentCompositionKey) {
        if (fragmentCompositionKey != null) {
            fragmentCompositionKey = fragmentCompositionKey.trim();
            return StringUtil.toLowerCase((String)fragmentCompositionKey);
        }
        return "";
    }
}

