/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.service.impl;

import com.liferay.fragment.model.FragmentComposition;
import com.liferay.fragment.service.base.FragmentCompositionServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=fragment", "json.web.service.context.path=FragmentComposition"}, service={AopService.class})
public class FragmentCompositionServiceImpl
extends FragmentCompositionServiceBaseImpl {
    @Reference
    private CustomSQL _customSQL;
    @Reference(target="(resource.name=com.liferay.fragment)")
    private PortletResourcePermission _portletResourcePermission;

    public FragmentComposition addFragmentComposition(long groupId, long fragmentCollectionId, String fragmentCompositionKey, String name, String description, String data, long previewFileEntryId, int status, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentCompositionLocalService.addFragmentComposition(this.getUserId(), groupId, fragmentCollectionId, fragmentCompositionKey, name, description, data, previewFileEntryId, status, serviceContext);
    }

    public FragmentComposition deleteFragmentComposition(long fragmentCompositionId) throws PortalException {
        FragmentComposition fragmentComposition = this.fragmentCompositionPersistence.findByPrimaryKey(fragmentCompositionId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentComposition.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentCompositionLocalService.deleteFragmentComposition(fragmentCompositionId);
    }

    public FragmentComposition fetchFragmentComposition(long fragmentCompositionId) {
        return this.fragmentCompositionPersistence.fetchByPrimaryKey(fragmentCompositionId);
    }

    public FragmentComposition fetchFragmentComposition(long groupId, String fragmentCompositionKey) {
        return this.fragmentCompositionLocalService.fetchFragmentComposition(groupId, fragmentCompositionKey);
    }

    public List<FragmentComposition> getFragmentCompositions(long fragmentCollectionId) {
        return this.fragmentCompositionPersistence.findByFragmentCollectionId(fragmentCollectionId);
    }

    public List<FragmentComposition> getFragmentCompositions(long fragmentCollectionId, int start, int end) {
        return this.fragmentCompositionPersistence.findByFragmentCollectionId(fragmentCollectionId, start, end);
    }

    public List<FragmentComposition> getFragmentCompositions(long groupId, long fragmentCollectionId, int status) {
        return this.fragmentCompositionPersistence.findByG_FCI_S(groupId, fragmentCollectionId, status);
    }

    public List<FragmentComposition> getFragmentCompositions(long groupId, long fragmentCollectionId, int start, int end, OrderByComparator<FragmentComposition> orderByComparator) {
        return this.fragmentCompositionPersistence.findByG_FCI(groupId, fragmentCollectionId, start, end, orderByComparator);
    }

    public List<FragmentComposition> getFragmentCompositions(long groupId, long fragmentCollectionId, String name, int start, int end, OrderByComparator<FragmentComposition> orderByComparator) {
        if (Validator.isNull((String)name)) {
            return this.fragmentCompositionPersistence.findByG_FCI(groupId, fragmentCollectionId, start, end, orderByComparator);
        }
        return this.fragmentCompositionPersistence.findByG_FCI_LikeN(groupId, fragmentCollectionId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], start, end, orderByComparator);
    }

    public int getFragmentCompositionsCount(long fragmentCollectionId) {
        return this.fragmentCompositionPersistence.countByFragmentCollectionId(fragmentCollectionId);
    }

    public FragmentComposition moveFragmentComposition(long fragmentCompositionId, long fragmentCollectionId) throws PortalException {
        FragmentComposition fragmentComposition = this.fragmentCompositionPersistence.findByPrimaryKey(fragmentCompositionId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentComposition.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentCompositionLocalService.moveFragmentComposition(fragmentCompositionId, fragmentCollectionId);
    }

    public FragmentComposition updateFragmentComposition(long fragmentCompositionId, long previewFileEntryId) throws PortalException {
        FragmentComposition fragmentComposition = this.fragmentCompositionPersistence.findByPrimaryKey(fragmentCompositionId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentComposition.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentCompositionLocalService.updateFragmentComposition(fragmentCompositionId, previewFileEntryId);
    }

    public FragmentComposition updateFragmentComposition(long fragmentCompositionId, long fragmentCollectionId, String name, String description, String data, long previewFileEntryId, int status) throws PortalException {
        FragmentComposition fragmentComposition = this.fragmentCompositionPersistence.findByPrimaryKey(fragmentCompositionId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentComposition.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentCompositionLocalService.updateFragmentComposition(this.getUserId(), fragmentCompositionId, fragmentCollectionId, name, description, data, previewFileEntryId, status);
    }

    public FragmentComposition updateFragmentComposition(long fragmentCompositionId, String name) throws PortalException {
        FragmentComposition fragmentComposition = this.fragmentCompositionPersistence.findByPrimaryKey(fragmentCompositionId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentComposition.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentCompositionLocalService.updateFragmentComposition(fragmentCompositionId, name);
    }

    public FragmentComposition updateFragmentComposition(long fragmentCompositionId, String name, String description, String data, long previewFileEntryId, int status) throws PortalException {
        FragmentComposition fragmentComposition = this.fragmentCompositionPersistence.findByPrimaryKey(fragmentCompositionId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentComposition.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentCompositionLocalService.updateFragmentComposition(this.getUserId(), fragmentCompositionId, name, description, data, previewFileEntryId, status);
    }
}

