/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.service.impl;

import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.service.base.FragmentEntryServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=fragment", "json.web.service.context.path=FragmentEntry"}, service={AopService.class})
public class FragmentEntryServiceImpl
extends FragmentEntryServiceBaseImpl {
    @Reference
    private CustomSQL _customSQL;
    @Reference(target="(resource.name=com.liferay.fragment)")
    private PortletResourcePermission _portletResourcePermission;

    public FragmentEntry addFragmentEntry(long groupId, long fragmentCollectionId, String fragmentEntryKey, String name, long previewFileEntryId, int type, int status, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.addFragmentEntry(this.getUserId(), groupId, fragmentCollectionId, fragmentEntryKey, name, previewFileEntryId, type, status, serviceContext);
    }

    public FragmentEntry addFragmentEntry(long groupId, long fragmentCollectionId, String fragmentEntryKey, String name, String css, String html, String js, boolean cacheable, String configuration, long previewFileEntryId, int type, int status, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.addFragmentEntry(this.getUserId(), groupId, fragmentCollectionId, fragmentEntryKey, name, css, html, js, cacheable, configuration, previewFileEntryId, type, status, serviceContext);
    }

    public FragmentEntry addFragmentEntry(long groupId, long fragmentCollectionId, String fragmentEntryKey, String name, String css, String html, String js, String configuration, long previewFileEntryId, int type, int status, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.addFragmentEntry(this.getUserId(), groupId, fragmentCollectionId, fragmentEntryKey, name, css, html, js, configuration, previewFileEntryId, type, status, serviceContext);
    }

    public FragmentEntry copyFragmentEntry(long groupId, long fragmentEntryId, long fragmentCollectionId, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.copyFragmentEntry(this.getUserId(), groupId, fragmentEntryId, fragmentCollectionId, serviceContext);
    }

    public void deleteFragmentEntries(long[] fragmentEntriesIds) throws PortalException {
        for (long fragmentEntryId : fragmentEntriesIds) {
            FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
            this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
            this.fragmentEntryLocalService.deleteFragmentEntry(fragmentEntry);
        }
    }

    public FragmentEntry deleteFragmentEntry(long fragmentEntryId) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.deleteFragmentEntry(fragmentEntryId);
    }

    public FragmentEntry fetchDraft(long primaryKey) {
        return this.fragmentEntryLocalService.fetchDraft(primaryKey);
    }

    public FragmentEntry fetchFragmentEntry(long fragmentEntryId) throws PortalException {
        return this.fragmentEntryLocalService.fetchFragmentEntry(fragmentEntryId);
    }

    public FragmentEntry getDraft(long primaryKey) throws PortalException {
        return this.fragmentEntryLocalService.getDraft(primaryKey);
    }

    public List<Object> getFragmentCompositionsAndFragmentEntries(long groupId, long fragmentCollectionId, int status, int start, int end, OrderByComparator<?> orderByComparator) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, orderByComparator);
        return this.fragmentEntryFinder.findFC_FE_ByG_FCI(groupId, fragmentCollectionId, queryDefinition);
    }

    public List<Object> getFragmentCompositionsAndFragmentEntries(long groupId, long fragmentCollectionId, String name, int status, int start, int end, OrderByComparator<?> orderByComparator) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, orderByComparator);
        return this.fragmentEntryFinder.findFC_FE_ByG_FCI_N(groupId, fragmentCollectionId, name, queryDefinition);
    }

    public int getFragmentCompositionsAndFragmentEntriesCount(long groupId, long fragmentCollectionId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.fragmentEntryFinder.countFC_FE_ByG_FCI(groupId, fragmentCollectionId, queryDefinition);
    }

    public int getFragmentCompositionsAndFragmentEntriesCount(long groupId, long fragmentCollectionId, String name, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.fragmentEntryFinder.countFC_FE_ByG_FCI_N(groupId, fragmentCollectionId, name, queryDefinition);
    }

    public List<FragmentEntry> getFragmentEntries(long fragmentCollectionId) {
        return this.fragmentEntryLocalService.getFragmentEntries(fragmentCollectionId);
    }

    public List<FragmentEntry> getFragmentEntries(long groupId, long fragmentCollectionId, int start, int end) {
        return this.fragmentEntryPersistence.findByG_FCI(groupId, fragmentCollectionId, start, end);
    }

    public List<FragmentEntry> getFragmentEntries(long groupId, long fragmentCollectionId, int start, int end, OrderByComparator<FragmentEntry> orderByComparator) {
        return this.fragmentEntryPersistence.findByG_FCI(groupId, fragmentCollectionId, start, end, orderByComparator);
    }

    public List<FragmentEntry> getFragmentEntriesByName(long groupId, long fragmentCollectionId, String name, int start, int end, OrderByComparator<FragmentEntry> orderByComparator) {
        return this.fragmentEntryPersistence.findByG_FCI_LikeN(groupId, fragmentCollectionId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], start, end, orderByComparator);
    }

    public List<FragmentEntry> getFragmentEntriesByNameAndStatus(long groupId, long fragmentCollectionId, String name, int status, int start, int end, OrderByComparator<FragmentEntry> orderByComparator) {
        if (status == -1) {
            return this.fragmentEntryPersistence.findByG_FCI_LikeN(groupId, fragmentCollectionId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], start, end, orderByComparator);
        }
        return this.fragmentEntryPersistence.findByG_FCI_LikeN_S(groupId, fragmentCollectionId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], status, start, end, orderByComparator);
    }

    public List<FragmentEntry> getFragmentEntriesByStatus(long groupId, long fragmentCollectionId, int status) {
        if (status == -1) {
            return this.fragmentEntryPersistence.findByG_FCI(groupId, fragmentCollectionId);
        }
        return this.fragmentEntryLocalService.getFragmentEntries(groupId, fragmentCollectionId, status);
    }

    public List<FragmentEntry> getFragmentEntriesByStatus(long groupId, long fragmentCollectionId, int status, int start, int end, OrderByComparator<FragmentEntry> orderByComparator) {
        if (status == -1) {
            return this.fragmentEntryPersistence.findByG_FCI(groupId, fragmentCollectionId, start, end, orderByComparator);
        }
        return this.fragmentEntryPersistence.findByG_FCI_S(groupId, fragmentCollectionId, status, start, end, orderByComparator);
    }

    public List<FragmentEntry> getFragmentEntriesByType(long groupId, long fragmentCollectionId, int type, int start, int end, OrderByComparator<FragmentEntry> orderByComparator) {
        return this.fragmentEntryPersistence.findByG_FCI_T(groupId, fragmentCollectionId, type, start, end, orderByComparator);
    }

    public List<FragmentEntry> getFragmentEntriesByTypeAndStatus(long groupId, long fragmentCollectionId, int type, int status) {
        return this.fragmentEntryPersistence.findByG_FCI_T_S(groupId, fragmentCollectionId, type, status);
    }

    public List<FragmentEntry> getFragmentEntriesByTypeAndStatus(long groupId, long fragmentCollectionId, int type, int status, int start, int end, OrderByComparator<FragmentEntry> orderByComparator) {
        if (status == -1) {
            return this.fragmentEntryPersistence.findByG_FCI_T(groupId, fragmentCollectionId, type, start, end, orderByComparator);
        }
        return this.fragmentEntryPersistence.findByG_FCI_T_S(groupId, fragmentCollectionId, type, status, start, end, orderByComparator);
    }

    public int getFragmentEntriesCount(long groupId, long fragmentCollectionId) {
        return this.fragmentEntryPersistence.countByG_FCI(groupId, fragmentCollectionId);
    }

    public int getFragmentEntriesCountByName(long groupId, long fragmentCollectionId, String name) {
        return this.fragmentEntryPersistence.countByG_FCI_LikeN(groupId, fragmentCollectionId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0]);
    }

    public int getFragmentEntriesCountByNameAndStatus(long groupId, long fragmentCollectionId, String name, int status) {
        if (status == -1) {
            return this.fragmentEntryPersistence.countByG_FCI_LikeN(groupId, fragmentCollectionId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0]);
        }
        return this.fragmentEntryPersistence.countByG_FCI_LikeN_S(groupId, fragmentCollectionId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], status);
    }

    public int getFragmentEntriesCountByStatus(long groupId, long fragmentCollectionId, int status) {
        if (status == -1) {
            return this.fragmentEntryPersistence.countByG_FCI(groupId, fragmentCollectionId);
        }
        return this.fragmentEntryPersistence.countByG_FCI_S(groupId, fragmentCollectionId, status);
    }

    public int getFragmentEntriesCountByType(long groupId, long fragmentCollectionId, int type) {
        return this.fragmentEntryPersistence.countByG_FCI_T(groupId, fragmentCollectionId, type);
    }

    public int getFragmentEntriesCountByTypeAndStatus(long groupId, long fragmentCollectionId, int type, int status) {
        if (status == -1) {
            return this.fragmentEntryPersistence.countByG_FCI_T(groupId, fragmentCollectionId, type);
        }
        return this.fragmentEntryPersistence.countByG_FCI_T_S(groupId, fragmentCollectionId, type, status);
    }

    public String[] getTempFileNames(long groupId, String folderName) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.getTempFileNames(this.getUserId(), groupId, folderName);
    }

    public FragmentEntry moveFragmentEntry(long fragmentEntryId, long fragmentCollectionId) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.moveFragmentEntry(fragmentEntryId, fragmentCollectionId);
    }

    public FragmentEntry publishDraft(FragmentEntry draftFragmentEntry) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), draftFragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.publishDraft(draftFragmentEntry);
    }

    public FragmentEntry updateDraft(FragmentEntry draftFragmentEntry) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), draftFragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.updateDraft(draftFragmentEntry);
    }

    public FragmentEntry updateFragmentEntry(FragmentEntry fragmentEntry) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.updateFragmentEntry(fragmentEntry);
    }

    public FragmentEntry updateFragmentEntry(long fragmentEntryId, long previewFileEntryId) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.updateFragmentEntry(fragmentEntryId, previewFileEntryId);
    }

    public FragmentEntry updateFragmentEntry(long fragmentEntryId, long fragmentCollectionId, String name, String css, String html, String js, boolean cacheable, String configuration, long previewFileEntryId, int status) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.updateFragmentEntry(this.getUserId(), fragmentEntryId, fragmentCollectionId, name, css, html, js, cacheable, configuration, previewFileEntryId, status);
    }

    public FragmentEntry updateFragmentEntry(long fragmentEntryId, String name) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.updateFragmentEntry(fragmentEntryId, name);
    }

    public FragmentEntry updateFragmentEntry(long fragmentEntryId, String name, String css, String html, String js, boolean cacheable, String configuration, int status) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.updateFragmentEntry(this.getUserId(), fragmentEntryId, name, css, html, js, cacheable, configuration, fragmentEntry.getPreviewFileEntryId(), status);
    }

    public FragmentEntry updateFragmentEntry(long fragmentEntryId, String name, String css, String html, String js, boolean cacheable, String configuration, long previewFileEntryId, int status) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.updateFragmentEntry(this.getUserId(), fragmentEntryId, name, css, html, js, cacheable, configuration, previewFileEntryId, status);
    }

    public FragmentEntry updateFragmentEntry(long fragmentEntryId, String name, String css, String html, String js, String configuration, int status) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.updateFragmentEntry(this.getUserId(), fragmentEntryId, name, css, html, js, configuration, status);
    }

    public FragmentEntry updateFragmentEntry(long fragmentEntryId, String name, String css, String html, String js, String configuration, long previewFileEntryId, int status) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.updateFragmentEntry(this.getUserId(), fragmentEntryId, name, css, html, js, configuration, previewFileEntryId, status);
    }
}

