/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.fragment.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryModel;
import com.liferay.fragment.model.FragmentEntryVersion;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the FragmentEntry service. Represents a row in the &quot;FragmentEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>FragmentEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link FragmentEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see FragmentEntryImpl
 * @generated
 */
@JSON(strict = true)
public class FragmentEntryModelImpl
	extends BaseModelImpl<FragmentEntry> implements FragmentEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a fragment entry model instance should use the <code>FragmentEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "FragmentEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"headId", Types.BIGINT},
		{"head", Types.BOOLEAN}, {"fragmentEntryId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"fragmentCollectionId", Types.BIGINT},
		{"fragmentEntryKey", Types.VARCHAR}, {"name", Types.VARCHAR},
		{"css", Types.CLOB}, {"html", Types.CLOB}, {"js", Types.CLOB},
		{"cacheable", Types.BOOLEAN}, {"configuration", Types.CLOB},
		{"icon", Types.VARCHAR}, {"previewFileEntryId", Types.BIGINT},
		{"readOnly", Types.BOOLEAN}, {"type_", Types.INTEGER},
		{"typeOptions", Types.CLOB}, {"lastPublishDate", Types.TIMESTAMP},
		{"status", Types.INTEGER}, {"statusByUserId", Types.BIGINT},
		{"statusByUserName", Types.VARCHAR}, {"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("headId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("head", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("fragmentEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("fragmentCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("fragmentEntryKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("css", Types.CLOB);
		TABLE_COLUMNS_MAP.put("html", Types.CLOB);
		TABLE_COLUMNS_MAP.put("js", Types.CLOB);
		TABLE_COLUMNS_MAP.put("cacheable", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("configuration", Types.CLOB);
		TABLE_COLUMNS_MAP.put("icon", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("previewFileEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("readOnly", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("type_", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("typeOptions", Types.CLOB);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table FragmentEntry (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,headId LONG,head BOOLEAN,fragmentEntryId LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,fragmentCollectionId LONG,fragmentEntryKey VARCHAR(75) null,name VARCHAR(75) null,css TEXT null,html TEXT null,js TEXT null,cacheable BOOLEAN,configuration TEXT null,icon VARCHAR(75) null,previewFileEntryId LONG,readOnly BOOLEAN,type_ INTEGER,typeOptions TEXT null,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null,primary key (fragmentEntryId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table FragmentEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY fragmentEntry.name ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY FragmentEntry.name ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FRAGMENTCOLLECTIONID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FRAGMENTENTRYKEY_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long HEAD_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long HEADID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TYPE_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public FragmentEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _fragmentEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setFragmentEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _fragmentEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return FragmentEntry.class;
	}

	@Override
	public String getModelClassName() {
		return FragmentEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<FragmentEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<FragmentEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<FragmentEntry, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((FragmentEntry)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<FragmentEntry, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<FragmentEntry, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(FragmentEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<FragmentEntry, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<FragmentEntry, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<FragmentEntry, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<FragmentEntry, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<FragmentEntry, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<FragmentEntry, Object>>();
		Map<String, BiConsumer<FragmentEntry, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<FragmentEntry, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", FragmentEntry::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<FragmentEntry, Long>)FragmentEntry::setMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", FragmentEntry::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<FragmentEntry, Long>)FragmentEntry::setCtCollectionId);
		attributeGetterFunctions.put("uuid", FragmentEntry::getUuid);
		attributeSetterBiConsumers.put(
			"uuid", (BiConsumer<FragmentEntry, String>)FragmentEntry::setUuid);
		attributeGetterFunctions.put("headId", FragmentEntry::getHeadId);
		attributeSetterBiConsumers.put(
			"headId",
			(BiConsumer<FragmentEntry, Long>)FragmentEntry::setHeadId);
		attributeGetterFunctions.put(
			"fragmentEntryId", FragmentEntry::getFragmentEntryId);
		attributeSetterBiConsumers.put(
			"fragmentEntryId",
			(BiConsumer<FragmentEntry, Long>)FragmentEntry::setFragmentEntryId);
		attributeGetterFunctions.put("groupId", FragmentEntry::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<FragmentEntry, Long>)FragmentEntry::setGroupId);
		attributeGetterFunctions.put("companyId", FragmentEntry::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<FragmentEntry, Long>)FragmentEntry::setCompanyId);
		attributeGetterFunctions.put("userId", FragmentEntry::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<FragmentEntry, Long>)FragmentEntry::setUserId);
		attributeGetterFunctions.put("userName", FragmentEntry::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<FragmentEntry, String>)FragmentEntry::setUserName);
		attributeGetterFunctions.put(
			"createDate", FragmentEntry::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<FragmentEntry, Date>)FragmentEntry::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", FragmentEntry::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<FragmentEntry, Date>)FragmentEntry::setModifiedDate);
		attributeGetterFunctions.put(
			"fragmentCollectionId", FragmentEntry::getFragmentCollectionId);
		attributeSetterBiConsumers.put(
			"fragmentCollectionId",
			(BiConsumer<FragmentEntry, Long>)
				FragmentEntry::setFragmentCollectionId);
		attributeGetterFunctions.put(
			"fragmentEntryKey", FragmentEntry::getFragmentEntryKey);
		attributeSetterBiConsumers.put(
			"fragmentEntryKey",
			(BiConsumer<FragmentEntry, String>)
				FragmentEntry::setFragmentEntryKey);
		attributeGetterFunctions.put("name", FragmentEntry::getName);
		attributeSetterBiConsumers.put(
			"name", (BiConsumer<FragmentEntry, String>)FragmentEntry::setName);
		attributeGetterFunctions.put("css", FragmentEntry::getCss);
		attributeSetterBiConsumers.put(
			"css", (BiConsumer<FragmentEntry, String>)FragmentEntry::setCss);
		attributeGetterFunctions.put("html", FragmentEntry::getHtml);
		attributeSetterBiConsumers.put(
			"html", (BiConsumer<FragmentEntry, String>)FragmentEntry::setHtml);
		attributeGetterFunctions.put("js", FragmentEntry::getJs);
		attributeSetterBiConsumers.put(
			"js", (BiConsumer<FragmentEntry, String>)FragmentEntry::setJs);
		attributeGetterFunctions.put("cacheable", FragmentEntry::getCacheable);
		attributeSetterBiConsumers.put(
			"cacheable",
			(BiConsumer<FragmentEntry, Boolean>)FragmentEntry::setCacheable);
		attributeGetterFunctions.put(
			"configuration", FragmentEntry::getConfiguration);
		attributeSetterBiConsumers.put(
			"configuration",
			(BiConsumer<FragmentEntry, String>)FragmentEntry::setConfiguration);
		attributeGetterFunctions.put("icon", FragmentEntry::getIcon);
		attributeSetterBiConsumers.put(
			"icon", (BiConsumer<FragmentEntry, String>)FragmentEntry::setIcon);
		attributeGetterFunctions.put(
			"previewFileEntryId", FragmentEntry::getPreviewFileEntryId);
		attributeSetterBiConsumers.put(
			"previewFileEntryId",
			(BiConsumer<FragmentEntry, Long>)
				FragmentEntry::setPreviewFileEntryId);
		attributeGetterFunctions.put("readOnly", FragmentEntry::getReadOnly);
		attributeSetterBiConsumers.put(
			"readOnly",
			(BiConsumer<FragmentEntry, Boolean>)FragmentEntry::setReadOnly);
		attributeGetterFunctions.put("type", FragmentEntry::getType);
		attributeSetterBiConsumers.put(
			"type", (BiConsumer<FragmentEntry, Integer>)FragmentEntry::setType);
		attributeGetterFunctions.put(
			"typeOptions", FragmentEntry::getTypeOptions);
		attributeSetterBiConsumers.put(
			"typeOptions",
			(BiConsumer<FragmentEntry, String>)FragmentEntry::setTypeOptions);
		attributeGetterFunctions.put(
			"lastPublishDate", FragmentEntry::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<FragmentEntry, Date>)FragmentEntry::setLastPublishDate);
		attributeGetterFunctions.put("status", FragmentEntry::getStatus);
		attributeSetterBiConsumers.put(
			"status",
			(BiConsumer<FragmentEntry, Integer>)FragmentEntry::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", FragmentEntry::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<FragmentEntry, Long>)FragmentEntry::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", FragmentEntry::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<FragmentEntry, String>)
				FragmentEntry::setStatusByUserName);
		attributeGetterFunctions.put(
			"statusDate", FragmentEntry::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate",
			(BiConsumer<FragmentEntry, Date>)FragmentEntry::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public void populateVersionModel(
		FragmentEntryVersion fragmentEntryVersion) {

		fragmentEntryVersion.setCtCollectionId(getCtCollectionId());
		fragmentEntryVersion.setUuid(getUuid());
		fragmentEntryVersion.setGroupId(getGroupId());
		fragmentEntryVersion.setCompanyId(getCompanyId());
		fragmentEntryVersion.setUserId(getUserId());
		fragmentEntryVersion.setUserName(getUserName());
		fragmentEntryVersion.setCreateDate(getCreateDate());
		fragmentEntryVersion.setModifiedDate(getModifiedDate());
		fragmentEntryVersion.setFragmentCollectionId(getFragmentCollectionId());
		fragmentEntryVersion.setFragmentEntryKey(getFragmentEntryKey());
		fragmentEntryVersion.setName(getName());
		fragmentEntryVersion.setCss(getCss());
		fragmentEntryVersion.setHtml(getHtml());
		fragmentEntryVersion.setJs(getJs());
		fragmentEntryVersion.setCacheable(getCacheable());
		fragmentEntryVersion.setConfiguration(getConfiguration());
		fragmentEntryVersion.setIcon(getIcon());
		fragmentEntryVersion.setPreviewFileEntryId(getPreviewFileEntryId());
		fragmentEntryVersion.setReadOnly(getReadOnly());
		fragmentEntryVersion.setType(getType());
		fragmentEntryVersion.setTypeOptions(getTypeOptions());
		fragmentEntryVersion.setLastPublishDate(getLastPublishDate());
		fragmentEntryVersion.setStatus(getStatus());
		fragmentEntryVersion.setStatusByUserId(getStatusByUserId());
		fragmentEntryVersion.setStatusByUserName(getStatusByUserName());
		fragmentEntryVersion.setStatusDate(getStatusDate());
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getHeadId() {
		return _headId;
	}

	@Override
	public void setHeadId(long headId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		if (headId >= 0) {
			setHead(false);
		}
		else {
			setHead(true);
		}

		_headId = headId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalHeadId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("headId"));
	}

	@JSON(include = false)
	public boolean getHead() {
		return _head;
	}

	@Override
	public boolean isHead() {
		return _head;
	}

	public void setHead(boolean head) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_head = head;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalHead() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("head"));
	}

	@JSON
	@Override
	public long getFragmentEntryId() {
		return _fragmentEntryId;
	}

	@Override
	public void setFragmentEntryId(long fragmentEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fragmentEntryId = fragmentEntryId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getFragmentCollectionId() {
		return _fragmentCollectionId;
	}

	@Override
	public void setFragmentCollectionId(long fragmentCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fragmentCollectionId = fragmentCollectionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalFragmentCollectionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("fragmentCollectionId"));
	}

	@JSON
	@Override
	public String getFragmentEntryKey() {
		if (_fragmentEntryKey == null) {
			return "";
		}
		else {
			return _fragmentEntryKey;
		}
	}

	@Override
	public void setFragmentEntryKey(String fragmentEntryKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fragmentEntryKey = fragmentEntryKey;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalFragmentEntryKey() {
		return getColumnOriginalValue("fragmentEntryKey");
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@JSON
	@Override
	public String getCss() {
		if (_css == null) {
			return "";
		}
		else {
			return _css;
		}
	}

	@Override
	public void setCss(String css) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_css = css;
	}

	@JSON
	@Override
	public String getHtml() {
		if (_html == null) {
			return "";
		}
		else {
			return _html;
		}
	}

	@Override
	public void setHtml(String html) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_html = html;
	}

	@JSON
	@Override
	public String getJs() {
		if (_js == null) {
			return "";
		}
		else {
			return _js;
		}
	}

	@Override
	public void setJs(String js) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_js = js;
	}

	@JSON
	@Override
	public boolean getCacheable() {
		return _cacheable;
	}

	@JSON
	@Override
	public boolean isCacheable() {
		return _cacheable;
	}

	@Override
	public void setCacheable(boolean cacheable) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_cacheable = cacheable;
	}

	@JSON
	@Override
	public String getConfiguration() {
		if (_configuration == null) {
			return "";
		}
		else {
			return _configuration;
		}
	}

	@Override
	public void setConfiguration(String configuration) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_configuration = configuration;
	}

	@JSON
	@Override
	public String getIcon() {
		if (_icon == null) {
			return "";
		}
		else {
			return _icon;
		}
	}

	@Override
	public void setIcon(String icon) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_icon = icon;
	}

	@JSON
	@Override
	public long getPreviewFileEntryId() {
		return _previewFileEntryId;
	}

	@Override
	public void setPreviewFileEntryId(long previewFileEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_previewFileEntryId = previewFileEntryId;
	}

	@JSON
	@Override
	public boolean getReadOnly() {
		return _readOnly;
	}

	@JSON
	@Override
	public boolean isReadOnly() {
		return _readOnly;
	}

	@Override
	public void setReadOnly(boolean readOnly) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_readOnly = readOnly;
	}

	@JSON
	@Override
	public int getType() {
		return _type;
	}

	@Override
	public void setType(int type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalType() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("type_"));
	}

	@JSON
	@Override
	public String getTypeOptions() {
		if (_typeOptions == null) {
			return "";
		}
		else {
			return _typeOptions;
		}
	}

	@Override
	public void setTypeOptions(String typeOptions) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_typeOptions = typeOptions;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(FragmentEntry.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), FragmentEntry.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public FragmentEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, FragmentEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		FragmentEntryImpl fragmentEntryImpl = new FragmentEntryImpl();

		fragmentEntryImpl.setMvccVersion(getMvccVersion());
		fragmentEntryImpl.setCtCollectionId(getCtCollectionId());
		fragmentEntryImpl.setUuid(getUuid());
		fragmentEntryImpl.setHeadId(getHeadId());
		fragmentEntryImpl.setFragmentEntryId(getFragmentEntryId());
		fragmentEntryImpl.setGroupId(getGroupId());
		fragmentEntryImpl.setCompanyId(getCompanyId());
		fragmentEntryImpl.setUserId(getUserId());
		fragmentEntryImpl.setUserName(getUserName());
		fragmentEntryImpl.setCreateDate(getCreateDate());
		fragmentEntryImpl.setModifiedDate(getModifiedDate());
		fragmentEntryImpl.setFragmentCollectionId(getFragmentCollectionId());
		fragmentEntryImpl.setFragmentEntryKey(getFragmentEntryKey());
		fragmentEntryImpl.setName(getName());
		fragmentEntryImpl.setCss(getCss());
		fragmentEntryImpl.setHtml(getHtml());
		fragmentEntryImpl.setJs(getJs());
		fragmentEntryImpl.setCacheable(isCacheable());
		fragmentEntryImpl.setConfiguration(getConfiguration());
		fragmentEntryImpl.setIcon(getIcon());
		fragmentEntryImpl.setPreviewFileEntryId(getPreviewFileEntryId());
		fragmentEntryImpl.setReadOnly(isReadOnly());
		fragmentEntryImpl.setType(getType());
		fragmentEntryImpl.setTypeOptions(getTypeOptions());
		fragmentEntryImpl.setLastPublishDate(getLastPublishDate());
		fragmentEntryImpl.setStatus(getStatus());
		fragmentEntryImpl.setStatusByUserId(getStatusByUserId());
		fragmentEntryImpl.setStatusByUserName(getStatusByUserName());
		fragmentEntryImpl.setStatusDate(getStatusDate());

		fragmentEntryImpl.resetOriginalValues();

		return fragmentEntryImpl;
	}

	@Override
	public FragmentEntry cloneWithOriginalValues() {
		FragmentEntryImpl fragmentEntryImpl = new FragmentEntryImpl();

		fragmentEntryImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		fragmentEntryImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		fragmentEntryImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		fragmentEntryImpl.setHeadId(
			this.<Long>getColumnOriginalValue("headId"));
		fragmentEntryImpl.setFragmentEntryId(
			this.<Long>getColumnOriginalValue("fragmentEntryId"));
		fragmentEntryImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		fragmentEntryImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		fragmentEntryImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		fragmentEntryImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		fragmentEntryImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		fragmentEntryImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		fragmentEntryImpl.setFragmentCollectionId(
			this.<Long>getColumnOriginalValue("fragmentCollectionId"));
		fragmentEntryImpl.setFragmentEntryKey(
			this.<String>getColumnOriginalValue("fragmentEntryKey"));
		fragmentEntryImpl.setName(this.<String>getColumnOriginalValue("name"));
		fragmentEntryImpl.setCss(this.<String>getColumnOriginalValue("css"));
		fragmentEntryImpl.setHtml(this.<String>getColumnOriginalValue("html"));
		fragmentEntryImpl.setJs(this.<String>getColumnOriginalValue("js"));
		fragmentEntryImpl.setCacheable(
			this.<Boolean>getColumnOriginalValue("cacheable"));
		fragmentEntryImpl.setConfiguration(
			this.<String>getColumnOriginalValue("configuration"));
		fragmentEntryImpl.setIcon(this.<String>getColumnOriginalValue("icon"));
		fragmentEntryImpl.setPreviewFileEntryId(
			this.<Long>getColumnOriginalValue("previewFileEntryId"));
		fragmentEntryImpl.setReadOnly(
			this.<Boolean>getColumnOriginalValue("readOnly"));
		fragmentEntryImpl.setType(
			this.<Integer>getColumnOriginalValue("type_"));
		fragmentEntryImpl.setTypeOptions(
			this.<String>getColumnOriginalValue("typeOptions"));
		fragmentEntryImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));
		fragmentEntryImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));
		fragmentEntryImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		fragmentEntryImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		fragmentEntryImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return fragmentEntryImpl;
	}

	@Override
	public int compareTo(FragmentEntry fragmentEntry) {
		int value = 0;

		value = getName().compareTo(fragmentEntry.getName());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof FragmentEntry)) {
			return false;
		}

		FragmentEntry fragmentEntry = (FragmentEntry)object;

		long primaryKey = fragmentEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<FragmentEntry> toCacheModel() {
		FragmentEntryCacheModel fragmentEntryCacheModel =
			new FragmentEntryCacheModel();

		fragmentEntryCacheModel.mvccVersion = getMvccVersion();

		fragmentEntryCacheModel.ctCollectionId = getCtCollectionId();

		fragmentEntryCacheModel.uuid = getUuid();

		String uuid = fragmentEntryCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			fragmentEntryCacheModel.uuid = null;
		}

		fragmentEntryCacheModel.headId = getHeadId();

		fragmentEntryCacheModel.head = isHead();

		fragmentEntryCacheModel.fragmentEntryId = getFragmentEntryId();

		fragmentEntryCacheModel.groupId = getGroupId();

		fragmentEntryCacheModel.companyId = getCompanyId();

		fragmentEntryCacheModel.userId = getUserId();

		fragmentEntryCacheModel.userName = getUserName();

		String userName = fragmentEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			fragmentEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			fragmentEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			fragmentEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			fragmentEntryCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			fragmentEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		fragmentEntryCacheModel.fragmentCollectionId =
			getFragmentCollectionId();

		fragmentEntryCacheModel.fragmentEntryKey = getFragmentEntryKey();

		String fragmentEntryKey = fragmentEntryCacheModel.fragmentEntryKey;

		if ((fragmentEntryKey != null) && (fragmentEntryKey.length() == 0)) {
			fragmentEntryCacheModel.fragmentEntryKey = null;
		}

		fragmentEntryCacheModel.name = getName();

		String name = fragmentEntryCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			fragmentEntryCacheModel.name = null;
		}

		fragmentEntryCacheModel.css = getCss();

		String css = fragmentEntryCacheModel.css;

		if ((css != null) && (css.length() == 0)) {
			fragmentEntryCacheModel.css = null;
		}

		fragmentEntryCacheModel.html = getHtml();

		String html = fragmentEntryCacheModel.html;

		if ((html != null) && (html.length() == 0)) {
			fragmentEntryCacheModel.html = null;
		}

		fragmentEntryCacheModel.js = getJs();

		String js = fragmentEntryCacheModel.js;

		if ((js != null) && (js.length() == 0)) {
			fragmentEntryCacheModel.js = null;
		}

		fragmentEntryCacheModel.cacheable = isCacheable();

		fragmentEntryCacheModel.configuration = getConfiguration();

		String configuration = fragmentEntryCacheModel.configuration;

		if ((configuration != null) && (configuration.length() == 0)) {
			fragmentEntryCacheModel.configuration = null;
		}

		fragmentEntryCacheModel.icon = getIcon();

		String icon = fragmentEntryCacheModel.icon;

		if ((icon != null) && (icon.length() == 0)) {
			fragmentEntryCacheModel.icon = null;
		}

		fragmentEntryCacheModel.previewFileEntryId = getPreviewFileEntryId();

		fragmentEntryCacheModel.readOnly = isReadOnly();

		fragmentEntryCacheModel.type = getType();

		fragmentEntryCacheModel.typeOptions = getTypeOptions();

		String typeOptions = fragmentEntryCacheModel.typeOptions;

		if ((typeOptions != null) && (typeOptions.length() == 0)) {
			fragmentEntryCacheModel.typeOptions = null;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			fragmentEntryCacheModel.lastPublishDate = lastPublishDate.getTime();
		}
		else {
			fragmentEntryCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		fragmentEntryCacheModel.status = getStatus();

		fragmentEntryCacheModel.statusByUserId = getStatusByUserId();

		fragmentEntryCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = fragmentEntryCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			fragmentEntryCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			fragmentEntryCacheModel.statusDate = statusDate.getTime();
		}
		else {
			fragmentEntryCacheModel.statusDate = Long.MIN_VALUE;
		}

		return fragmentEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<FragmentEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<FragmentEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<FragmentEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((FragmentEntry)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<FragmentEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<FragmentEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<FragmentEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((FragmentEntry)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, FragmentEntry>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					FragmentEntry.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _headId;
	private boolean _head;
	private long _fragmentEntryId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _fragmentCollectionId;
	private String _fragmentEntryKey;
	private String _name;
	private String _css;
	private String _html;
	private String _js;
	private boolean _cacheable;
	private String _configuration;
	private String _icon;
	private long _previewFileEntryId;
	private boolean _readOnly;
	private int _type;
	private String _typeOptions;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		if (columnName.equals("head")) {
			return (T)(Object)getHead();
		}

		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<FragmentEntry, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((FragmentEntry)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("headId", _headId);
		_columnOriginalValues.put("head", _head);
		_columnOriginalValues.put("fragmentEntryId", _fragmentEntryId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"fragmentCollectionId", _fragmentCollectionId);
		_columnOriginalValues.put("fragmentEntryKey", _fragmentEntryKey);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("css", _css);
		_columnOriginalValues.put("html", _html);
		_columnOriginalValues.put("js", _js);
		_columnOriginalValues.put("cacheable", _cacheable);
		_columnOriginalValues.put("configuration", _configuration);
		_columnOriginalValues.put("icon", _icon);
		_columnOriginalValues.put("previewFileEntryId", _previewFileEntryId);
		_columnOriginalValues.put("readOnly", _readOnly);
		_columnOriginalValues.put("type_", _type);
		_columnOriginalValues.put("typeOptions", _typeOptions);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("headId", 8L);

		columnBitmasks.put("head", 16L);

		columnBitmasks.put("fragmentEntryId", 32L);

		columnBitmasks.put("groupId", 64L);

		columnBitmasks.put("companyId", 128L);

		columnBitmasks.put("userId", 256L);

		columnBitmasks.put("userName", 512L);

		columnBitmasks.put("createDate", 1024L);

		columnBitmasks.put("modifiedDate", 2048L);

		columnBitmasks.put("fragmentCollectionId", 4096L);

		columnBitmasks.put("fragmentEntryKey", 8192L);

		columnBitmasks.put("name", 16384L);

		columnBitmasks.put("css", 32768L);

		columnBitmasks.put("html", 65536L);

		columnBitmasks.put("js", 131072L);

		columnBitmasks.put("cacheable", 262144L);

		columnBitmasks.put("configuration", 524288L);

		columnBitmasks.put("icon", 1048576L);

		columnBitmasks.put("previewFileEntryId", 2097152L);

		columnBitmasks.put("readOnly", 4194304L);

		columnBitmasks.put("type_", 8388608L);

		columnBitmasks.put("typeOptions", 16777216L);

		columnBitmasks.put("lastPublishDate", 33554432L);

		columnBitmasks.put("status", 67108864L);

		columnBitmasks.put("statusByUserId", 134217728L);

		columnBitmasks.put("statusByUserName", 268435456L);

		columnBitmasks.put("statusDate", 536870912L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private FragmentEntry _escapedModel;

}