/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.deploy.auto;

import com.liferay.fragment.importer.FragmentsImporter;
import com.liferay.layout.page.template.importer.LayoutPageTemplatesImporter;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.staging.StagingGroupHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AutoDeployListener.class})
public class FragmentAutoDeployListener
implements AutoDeployListener {
    private static final Log _log = LogFactoryUtil.getLog(FragmentAutoDeployListener.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private FragmentsImporter _fragmentsImporter;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutPageTemplatesImporter _layoutPageTemplatesImporter;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private StagingGroupHelper _stagingGroupHelper;
    @Reference
    private UserLocalService _userLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deploy(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        PermissionChecker currentPermissionChecker = PermissionThreadLocal.getPermissionChecker();
        String currentName = PrincipalThreadLocal.getName();
        ServiceContext currentServiceContext = ServiceContextThreadLocal.getServiceContext();
        try {
            this._deploy(autoDeploymentContext.getFile());
        }
        catch (AutoDeployException autoDeployException) {
            _log.error((Throwable)autoDeployException);
            throw autoDeployException;
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        finally {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)currentPermissionChecker);
            PrincipalThreadLocal.setName((String)currentName);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)currentServiceContext);
        }
        return 1;
    }

    public boolean isDeployable(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        block4: {
            File file = autoDeploymentContext.getFile();
            String fileName = file.getName();
            if (!StringUtil.endsWith((String)fileName, (String)".zip")) {
                return false;
            }
            try {
                JSONObject deployJSONObject = this._getDeployJSONObject(file);
                if (deployJSONObject != null) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)exception);
            }
        }
        return false;
    }

    private void _deploy(File file) throws Exception {
        JSONObject deployJSONObject = this._getDeployJSONObject(file);
        if (deployJSONObject == null) {
            throw new AutoDeployException();
        }
        Company company = null;
        Group group = null;
        String companyWebId = deployJSONObject.getString("companyWebId");
        if (Validator.isNotNull((String)companyWebId) && !Objects.equals(companyWebId, "*")) {
            company = this._companyLocalService.getCompanyByWebId(companyWebId);
        }
        if (company != null && deployJSONObject.has("groupKey")) {
            group = this._getDeploymentGroup(company.getCompanyId(), deployJSONObject.getString("groupKey"));
        } else if (company != null) {
            group = this._groupLocalService.getCompanyGroup(company.getCompanyId());
        } else {
            List companies = this._companyLocalService.getCompanies(0, 1);
            if (ListUtil.isEmpty((List)companies)) {
                throw new AutoDeployException();
            }
            company = (Company)companies.get(0);
        }
        User user = this._getUser(company, group);
        if (user == null) {
            throw new AutoDeployException();
        }
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)user));
        PrincipalThreadLocal.setName((long)user.getUserId());
        ServiceContext serviceContext = new ServiceContext();
        if (company != null) {
            serviceContext.setCompanyId(company.getCompanyId());
        } else {
            serviceContext.setCompanyId(0L);
        }
        serviceContext.setUserId(user.getUserId());
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        long groupId = 0L;
        if (group != null) {
            groupId = group.getGroupId();
        }
        this._fragmentsImporter.importFragmentEntries(user.getUserId(), groupId, 0L, file, true);
        if (company != null && group != null && company.getGroupId() != group.getGroupId()) {
            this._layoutPageTemplatesImporter.importFile(user.getUserId(), groupId, 0L, file, true);
        }
    }

    private JSONObject _getDeployJSONObject(File file) throws IOException, JSONException {
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry zipEntry = this._getDeployZipEntry(zipFile);
            if (zipEntry == null) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject jSONObject = JSONFactoryUtil.createJSONObject((String)StringUtil.read((InputStream)zipFile.getInputStream(zipEntry)));
            return jSONObject;
        }
    }

    private Group _getDeploymentGroup(long companyId, String groupKey) throws Exception {
        Group group = this._groupLocalService.getGroup(companyId, groupKey);
        if (group == null) {
            return null;
        }
        if (this._stagingGroupHelper.isLocalLiveGroup(group) || this._stagingGroupHelper.isRemoteLiveGroup(group)) {
            return group.getStagingGroup();
        }
        return group;
    }

    private ZipEntry _getDeployZipEntry(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!Objects.equals(this._getFileName(zipEntry.getName()), "liferay-deploy-fragments.json")) continue;
            return zipEntry;
        }
        return null;
    }

    private String _getFileName(String path) {
        int pos = path.lastIndexOf(47);
        if (pos > 0) {
            return path.substring(pos + 1);
        }
        return path;
    }

    private User _getUser(Company company, Group group) throws Exception {
        long companyId = 0L;
        long userId = 0L;
        if (group != null) {
            companyId = group.getCompanyId();
            userId = group.getCreatorUserId();
        } else if (company != null) {
            companyId = company.getCompanyId();
        }
        User user = this._userLocalService.fetchUserById(userId);
        if (user == null || user.isDefaultUser()) {
            Role role = this._roleLocalService.getRole(companyId, "Administrator");
            long[] userIds = this._userLocalService.getRoleUserIds(role.getRoleId());
            return this._userLocalService.getUser(userIds[0]);
        }
        return user;
    }
}

