/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.exportimport.content.processor;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.fragment.internal.exportimport.content.processor.BaseEditableValuesConfigurationExportImportContentProcessor;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.StagingGroupHelperUtil;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"content.processor.type=FragmentEntryLinkEditableValues"}, service={ExportImportContentProcessor.class})
public class EditableValuesItemSelectorExportImportContentProcessor
extends BaseEditableValuesConfigurationExportImportContentProcessor {
    private static final Log _log = LogFactoryUtil.getLog(EditableValuesItemSelectorExportImportContentProcessor.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    @Reference
    private Portal _portal;

    @Override
    protected String getConfigurationType() {
        return "itemSelector";
    }

    @Override
    protected FragmentEntryConfigurationParser getFragmentEntryConfigurationParser() {
        return this._fragmentEntryConfigurationParser;
    }

    @Override
    protected void replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, JSONObject configurationValueJSONObject, boolean exportReferencedContent) throws Exception {
        AssetEntry assetEntry;
        long classNameId = configurationValueJSONObject.getLong("classNameId");
        long classPK = configurationValueJSONObject.getLong("classPK");
        if (classNameId == 0L || classPK == 0L) {
            return;
        }
        this._exportDDMTemplateReference(portletDataContext, stagedModel, configurationValueJSONObject);
        String className = this._portal.getClassName(classNameId);
        if (Objects.equals(className, FileEntry.class.getName())) {
            className = DLFileEntry.class.getName();
        }
        if ((assetEntry = this._assetEntryLocalService.fetchEntry(className, classPK)) == null) {
            return;
        }
        AssetRenderer assetRenderer = assetEntry.getAssetRenderer();
        if (assetRenderer == null) {
            return;
        }
        AssetRendererFactory assetRendererFactory = assetRenderer.getAssetRendererFactory();
        StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
        if (ExportImportThreadLocal.isStagingInProcess() && !stagingGroupHelper.isStagedPortlet(portletDataContext.getScopeGroupId(), assetRendererFactory.getPortletId())) {
            return;
        }
        configurationValueJSONObject.put("className", this._portal.getClassName(classNameId));
        if (exportReferencedContent) {
            try {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)((StagedModel)assetRenderer.getAssetObject()), (String)"dependency");
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    String errorMessage = StringBundler.concat((Object[])new Object[]{"Staged model with class name ", stagedModel.getModelClassName(), " and primary key ", stagedModel.getPrimaryKeyObj(), " references asset entry with class primary key ", classPK, " and class name ", this._portal.getClassName(classNameId), " that could not be exported due to ", exception});
                    if (Validator.isNotNull((String)exception.getMessage())) {
                        errorMessage = StringBundler.concat((String[])new String[]{errorMessage, ": ", exception.getMessage()});
                    }
                    _log.debug((Object)errorMessage, (Throwable)exception);
                }
            }
        } else {
            Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
            portletDataContext.addReferenceElement((ClassedModel)stagedModel, entityElement, (ClassedModel)assetRenderer.getAssetObject(), "dependency", true);
        }
    }

    @Override
    protected void replaceImportContentReferences(PortletDataContext portletDataContext, JSONObject configurationValueJSONObject) {
        String assetRendererFactoryByClassName;
        String className = configurationValueJSONObject.getString("className");
        if (Validator.isNull((String)className)) {
            return;
        }
        if (configurationValueJSONObject.has("template")) {
            JSONObject templateJSONObject = configurationValueJSONObject.getJSONObject("template");
            String ddmTemplateKey = templateJSONObject.getString("templateKey");
            if (Validator.isNull((String)ddmTemplateKey)) {
                return;
            }
            Map ddmTemplateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
            String importedDDMTemplateKey = MapUtil.getString((Map)ddmTemplateKeys, (String)ddmTemplateKey, (String)ddmTemplateKey);
            templateJSONObject.put("templateKey", importedDDMTemplateKey);
        }
        if (Objects.equals(assetRendererFactoryByClassName = className, FileEntry.class.getName())) {
            assetRendererFactoryByClassName = DLFileEntry.class.getName();
        }
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetRendererFactoryByClassName);
        StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
        if (ExportImportThreadLocal.isStagingInProcess() && !stagingGroupHelper.isStagedPortlet(portletDataContext.getScopeGroupId(), assetRendererFactory.getPortletId())) {
            return;
        }
        long classPK = configurationValueJSONObject.getLong("classPK");
        if (classPK == 0L) {
            return;
        }
        configurationValueJSONObject.put("classNameId", this._portal.getClassNameId(className));
        Map primaryKeys = portletDataContext.getNewPrimaryKeysMap(className);
        classPK = MapUtil.getLong((Map)primaryKeys, (long)classPK, (long)classPK);
        configurationValueJSONObject.put("classPK", classPK);
    }

    private void _exportDDMTemplateReference(PortletDataContext portletDataContext, StagedModel stagedModel, JSONObject configurationValueJSONObject) throws Exception {
        if (!configurationValueJSONObject.has("template")) {
            return;
        }
        JSONObject templateJSONObject = configurationValueJSONObject.getJSONObject("template");
        String ddmTemplateKey = templateJSONObject.getString("templateKey");
        if (Validator.isNull((String)ddmTemplateKey)) {
            return;
        }
        DDMTemplate ddmTemplate = this._ddmTemplateLocalService.fetchTemplate(portletDataContext.getScopeGroupId(), this._portal.getClassNameId(DDMStructure.class), ddmTemplateKey);
        if (ddmTemplate != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)ddmTemplate, (String)"dependency");
        }
    }
}

