/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.exportimport.content.processor;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.StagingGroupHelperUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"content.processor.type=FragmentEntryLinkEditableValues"}, service={ExportImportContentProcessor.class})
public class EditableValuesMappingExportImportContentProcessor
implements ExportImportContentProcessor<JSONObject> {
    private static final String _DDM_TEMPLATE = "ddmTemplate_";
    private static final Log _log = LogFactoryUtil.getLog(EditableValuesMappingExportImportContentProcessor.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private Portal _portal;

    public JSONObject replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, JSONObject editableValuesJSONObject, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        JSONObject editableProcessorJSONObject = editableValuesJSONObject.getJSONObject("com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor");
        this._replaceAllEditableExportContentReferences(editableProcessorJSONObject, exportReferencedContent, portletDataContext, stagedModel);
        return editableValuesJSONObject;
    }

    public JSONObject replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, JSONObject editableValuesJSONObject) throws Exception {
        JSONObject editableProcessorJSONObject = editableValuesJSONObject.getJSONObject("com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor");
        this._replaceAllEditableImportContentReferences(editableProcessorJSONObject, portletDataContext);
        return editableValuesJSONObject;
    }

    public void validateContentReferences(long groupId, JSONObject jsonObject) {
    }

    private void _exportDDMTemplateReference(PortletDataContext portletDataContext, StagedModel stagedModel, JSONObject editableJSONObject) throws Exception {
        String mappedField = editableJSONObject.getString("mappedField", editableJSONObject.getString("fieldId"));
        if (!mappedField.startsWith(_DDM_TEMPLATE)) {
            return;
        }
        String ddmTemplateKey = mappedField.substring(_DDM_TEMPLATE.length());
        DDMTemplate ddmTemplate = this._ddmTemplateLocalService.fetchTemplate(portletDataContext.getScopeGroupId(), this._portal.getClassNameId(DDMStructure.class), ddmTemplateKey);
        if (ddmTemplate != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)ddmTemplate, (String)"dependency");
        }
    }

    private void _replaceAllEditableExportContentReferences(JSONObject editableValuesJSONObject, boolean exportReferencedContent, PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        if (editableValuesJSONObject == null || editableValuesJSONObject.length() <= 0) {
            return;
        }
        this._replaceMappedFieldExportContentReferences(portletDataContext, stagedModel, editableValuesJSONObject, exportReferencedContent);
        Iterator editableKeysIterator = editableValuesJSONObject.keys();
        while (editableKeysIterator.hasNext()) {
            String editableKey = (String)editableKeysIterator.next();
            JSONObject editableJSONObject = editableValuesJSONObject.getJSONObject(editableKey);
            this._replaceAllEditableExportContentReferences(editableJSONObject, exportReferencedContent, portletDataContext, stagedModel);
        }
    }

    private void _replaceAllEditableImportContentReferences(JSONObject editableValuesJSONObject, PortletDataContext portletDataContext) {
        if (editableValuesJSONObject == null || editableValuesJSONObject.length() <= 0) {
            return;
        }
        this._replaceMappedFieldImportContentReferences(portletDataContext, editableValuesJSONObject);
        Iterator editableKeysIterator = editableValuesJSONObject.keys();
        while (editableKeysIterator.hasNext()) {
            String editableKey = (String)editableKeysIterator.next();
            JSONObject editableJSONObject = editableValuesJSONObject.getJSONObject(editableKey);
            this._replaceAllEditableImportContentReferences(editableJSONObject, portletDataContext);
        }
    }

    private void _replaceMappedFieldExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, JSONObject editableJSONObject, boolean exportReferencedContent) throws Exception {
        AssetEntry assetEntry;
        long classNameId = editableJSONObject.getLong("classNameId");
        long classPK = editableJSONObject.getLong("classPK");
        if (classNameId == 0L || classPK == 0L) {
            return;
        }
        this._exportDDMTemplateReference(portletDataContext, stagedModel, editableJSONObject);
        String className = this._portal.getClassName(classNameId);
        if (Objects.equals(className, FileEntry.class.getName())) {
            className = DLFileEntry.class.getName();
        }
        if ((assetEntry = this._assetEntryLocalService.fetchEntry(className, classPK)) == null) {
            return;
        }
        AssetRenderer assetRenderer = assetEntry.getAssetRenderer();
        if (assetRenderer == null) {
            return;
        }
        AssetRendererFactory assetRendererFactory = assetRenderer.getAssetRendererFactory();
        StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
        if (ExportImportThreadLocal.isStagingInProcess() && !stagingGroupHelper.isStagedPortlet(portletDataContext.getScopeGroupId(), assetRendererFactory.getPortletId())) {
            return;
        }
        editableJSONObject.put("className", this._portal.getClassName(classNameId));
        if (exportReferencedContent) {
            try {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)((StagedModel)assetRenderer.getAssetObject()), (String)"dependency");
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    String errorMessage = StringBundler.concat((Object[])new Object[]{"Staged model with class name ", stagedModel.getModelClassName(), " and primary key ", stagedModel.getPrimaryKeyObj(), " references asset entry with class primary key ", classPK, " and class name ", this._portal.getClassName(classNameId), " that could not be exported due to ", exception});
                    if (Validator.isNotNull((String)exception.getMessage())) {
                        errorMessage = StringBundler.concat((String[])new String[]{errorMessage, ": ", exception.getMessage()});
                    }
                    _log.debug((Object)errorMessage, (Throwable)exception);
                }
            }
        } else {
            Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
            portletDataContext.addReferenceElement((ClassedModel)stagedModel, entityElement, (ClassedModel)assetRenderer.getAssetObject(), "dependency", true);
        }
    }

    private void _replaceMappedFieldImportContentReferences(PortletDataContext portletDataContext, JSONObject editableJSONObject) {
        String assetRendererFactoryByClassName;
        String className = editableJSONObject.getString("className");
        if (Validator.isNull((String)className)) {
            return;
        }
        String mappedField = editableJSONObject.getString("mappedField", editableJSONObject.getString("fieldId"));
        if (mappedField.startsWith(_DDM_TEMPLATE)) {
            String ddmTemplateKey = mappedField.substring(_DDM_TEMPLATE.length());
            Map ddmTemplateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
            String importedDDMTemplateKey = MapUtil.getString((Map)ddmTemplateKeys, (String)ddmTemplateKey, (String)ddmTemplateKey);
            if (editableJSONObject.has("mappedField")) {
                editableJSONObject.put("mappedField", _DDM_TEMPLATE + importedDDMTemplateKey);
            } else {
                editableJSONObject.put("fieldId", _DDM_TEMPLATE + importedDDMTemplateKey);
            }
        }
        if (Objects.equals(assetRendererFactoryByClassName = className, FileEntry.class.getName())) {
            assetRendererFactoryByClassName = DLFileEntry.class.getName();
        }
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetRendererFactoryByClassName);
        StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
        if (ExportImportThreadLocal.isStagingInProcess() && !stagingGroupHelper.isStagedPortlet(portletDataContext.getScopeGroupId(), assetRendererFactory.getPortletId())) {
            return;
        }
        long classPK = editableJSONObject.getLong("classPK");
        if (classPK == 0L) {
            return;
        }
        editableJSONObject.put("classNameId", this._portal.getClassNameId(className));
        Map primaryKeys = portletDataContext.getNewPrimaryKeysMap(className);
        classPK = MapUtil.getLong((Map)primaryKeys, (long)classPK, (long)classPK);
        editableJSONObject.put("classPK", classPK);
    }
}

