/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.upgrade.v2_6_0;

import com.liferay.fragment.model.FragmentEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Statement;

public class FragmentEntryUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this._upgradeSchema();
        this._upgradeFragmentEntryCounter();
        this._upgradeFragmentEntryHeadIdAndHeadStatusApproved();
        this._upgradeFragmentEntryHeadIdAndHeadStatusDraft();
    }

    private void _upgradeFragmentEntryCounter() throws Exception {
        this.runSQL(StringBundler.concat((String[])new String[]{"insert into Counter (name, currentId) select '", FragmentEntry.class.getName(), "', max(fragmentEntryId) from FragmentEntry"}));
    }

    private void _upgradeFragmentEntryHeadIdAndHeadStatusApproved() throws Exception {
        try (Statement s = this.connection.createStatement();){
            s.execute(SQLTransformer.transform((String)StringBundler.concat((Object[])new Object[]{"update FragmentEntry set headId = -1 * ", "fragmentEntryId, head = [$TRUE$] where status = ", 0})));
        }
    }

    private void _upgradeFragmentEntryHeadIdAndHeadStatusDraft() throws Exception {
        try (Statement s = this.connection.createStatement();){
            s.execute(SQLTransformer.transform((String)StringBundler.concat((Object[])new Object[]{"update FragmentEntry set headId = fragmentEntryId, ", "head = [$FALSE$] where status != ", 0})));
        }
    }

    private void _upgradeSchema() throws Exception {
        this.alterTableAddColumn("FragmentEntry", "headId", "LONG");
        this.alterTableAddColumn("FragmentEntry", "head", "BOOLEAN");
    }
}

