/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.fragment.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.fragment.model.FragmentComposition;
import com.liferay.fragment.model.FragmentCompositionModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the FragmentComposition service. Represents a row in the &quot;FragmentComposition&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>FragmentCompositionModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link FragmentCompositionImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see FragmentCompositionImpl
 * @generated
 */
@JSON(strict = true)
public class FragmentCompositionModelImpl
	extends BaseModelImpl<FragmentComposition>
	implements FragmentCompositionModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a fragment composition model instance should use the <code>FragmentComposition</code> interface instead.
	 */
	public static final String TABLE_NAME = "FragmentComposition";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"fragmentCompositionId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"fragmentCollectionId", Types.BIGINT},
		{"fragmentCompositionKey", Types.VARCHAR}, {"name", Types.VARCHAR},
		{"description", Types.VARCHAR}, {"data_", Types.CLOB},
		{"previewFileEntryId", Types.BIGINT},
		{"lastPublishDate", Types.TIMESTAMP}, {"status", Types.INTEGER},
		{"statusByUserId", Types.BIGINT}, {"statusByUserName", Types.VARCHAR},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("fragmentCompositionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("fragmentCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("fragmentCompositionKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("data_", Types.CLOB);
		TABLE_COLUMNS_MAP.put("previewFileEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table FragmentComposition (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,fragmentCompositionId LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,fragmentCollectionId LONG,fragmentCompositionKey VARCHAR(75) null,name VARCHAR(75) null,description STRING null,data_ TEXT null,previewFileEntryId LONG,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null,primary key (fragmentCompositionId, ctCollectionId))";

	public static final String TABLE_SQL_DROP =
		"drop table FragmentComposition";

	public static final String ORDER_BY_JPQL =
		" ORDER BY fragmentComposition.name ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY FragmentComposition.name ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FRAGMENTCOLLECTIONID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FRAGMENTCOMPOSITIONKEY_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public FragmentCompositionModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _fragmentCompositionId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setFragmentCompositionId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _fragmentCompositionId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return FragmentComposition.class;
	}

	@Override
	public String getModelClassName() {
		return FragmentComposition.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<FragmentComposition, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<FragmentComposition, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<FragmentComposition, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((FragmentComposition)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<FragmentComposition, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<FragmentComposition, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(FragmentComposition)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<FragmentComposition, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<FragmentComposition, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<FragmentComposition, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<FragmentComposition, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<FragmentComposition, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<FragmentComposition, Object>>();
		Map<String, BiConsumer<FragmentComposition, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<FragmentComposition, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", FragmentComposition::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<FragmentComposition, Long>)
				FragmentComposition::setMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", FragmentComposition::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<FragmentComposition, Long>)
				FragmentComposition::setCtCollectionId);
		attributeGetterFunctions.put("uuid", FragmentComposition::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<FragmentComposition, String>)
				FragmentComposition::setUuid);
		attributeGetterFunctions.put(
			"fragmentCompositionId",
			FragmentComposition::getFragmentCompositionId);
		attributeSetterBiConsumers.put(
			"fragmentCompositionId",
			(BiConsumer<FragmentComposition, Long>)
				FragmentComposition::setFragmentCompositionId);
		attributeGetterFunctions.put(
			"groupId", FragmentComposition::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<FragmentComposition, Long>)
				FragmentComposition::setGroupId);
		attributeGetterFunctions.put(
			"companyId", FragmentComposition::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<FragmentComposition, Long>)
				FragmentComposition::setCompanyId);
		attributeGetterFunctions.put("userId", FragmentComposition::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<FragmentComposition, Long>)
				FragmentComposition::setUserId);
		attributeGetterFunctions.put(
			"userName", FragmentComposition::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<FragmentComposition, String>)
				FragmentComposition::setUserName);
		attributeGetterFunctions.put(
			"createDate", FragmentComposition::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<FragmentComposition, Date>)
				FragmentComposition::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", FragmentComposition::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<FragmentComposition, Date>)
				FragmentComposition::setModifiedDate);
		attributeGetterFunctions.put(
			"fragmentCollectionId",
			FragmentComposition::getFragmentCollectionId);
		attributeSetterBiConsumers.put(
			"fragmentCollectionId",
			(BiConsumer<FragmentComposition, Long>)
				FragmentComposition::setFragmentCollectionId);
		attributeGetterFunctions.put(
			"fragmentCompositionKey",
			FragmentComposition::getFragmentCompositionKey);
		attributeSetterBiConsumers.put(
			"fragmentCompositionKey",
			(BiConsumer<FragmentComposition, String>)
				FragmentComposition::setFragmentCompositionKey);
		attributeGetterFunctions.put("name", FragmentComposition::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<FragmentComposition, String>)
				FragmentComposition::setName);
		attributeGetterFunctions.put(
			"description", FragmentComposition::getDescription);
		attributeSetterBiConsumers.put(
			"description",
			(BiConsumer<FragmentComposition, String>)
				FragmentComposition::setDescription);
		attributeGetterFunctions.put("data", FragmentComposition::getData);
		attributeSetterBiConsumers.put(
			"data",
			(BiConsumer<FragmentComposition, String>)
				FragmentComposition::setData);
		attributeGetterFunctions.put(
			"previewFileEntryId", FragmentComposition::getPreviewFileEntryId);
		attributeSetterBiConsumers.put(
			"previewFileEntryId",
			(BiConsumer<FragmentComposition, Long>)
				FragmentComposition::setPreviewFileEntryId);
		attributeGetterFunctions.put(
			"lastPublishDate", FragmentComposition::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<FragmentComposition, Date>)
				FragmentComposition::setLastPublishDate);
		attributeGetterFunctions.put("status", FragmentComposition::getStatus);
		attributeSetterBiConsumers.put(
			"status",
			(BiConsumer<FragmentComposition, Integer>)
				FragmentComposition::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", FragmentComposition::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<FragmentComposition, Long>)
				FragmentComposition::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", FragmentComposition::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<FragmentComposition, String>)
				FragmentComposition::setStatusByUserName);
		attributeGetterFunctions.put(
			"statusDate", FragmentComposition::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate",
			(BiConsumer<FragmentComposition, Date>)
				FragmentComposition::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getFragmentCompositionId() {
		return _fragmentCompositionId;
	}

	@Override
	public void setFragmentCompositionId(long fragmentCompositionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fragmentCompositionId = fragmentCompositionId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getFragmentCollectionId() {
		return _fragmentCollectionId;
	}

	@Override
	public void setFragmentCollectionId(long fragmentCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fragmentCollectionId = fragmentCollectionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalFragmentCollectionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("fragmentCollectionId"));
	}

	@JSON
	@Override
	public String getFragmentCompositionKey() {
		if (_fragmentCompositionKey == null) {
			return "";
		}
		else {
			return _fragmentCompositionKey;
		}
	}

	@Override
	public void setFragmentCompositionKey(String fragmentCompositionKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fragmentCompositionKey = fragmentCompositionKey;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalFragmentCompositionKey() {
		return getColumnOriginalValue("fragmentCompositionKey");
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@JSON
	@Override
	public String getData() {
		if (_data == null) {
			return "";
		}
		else {
			return _data;
		}
	}

	@Override
	public void setData(String data) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_data = data;
	}

	@JSON
	@Override
	public long getPreviewFileEntryId() {
		return _previewFileEntryId;
	}

	@Override
	public void setPreviewFileEntryId(long previewFileEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_previewFileEntryId = previewFileEntryId;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(FragmentComposition.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), FragmentComposition.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public FragmentComposition toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, FragmentComposition>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		FragmentCompositionImpl fragmentCompositionImpl =
			new FragmentCompositionImpl();

		fragmentCompositionImpl.setMvccVersion(getMvccVersion());
		fragmentCompositionImpl.setCtCollectionId(getCtCollectionId());
		fragmentCompositionImpl.setUuid(getUuid());
		fragmentCompositionImpl.setFragmentCompositionId(
			getFragmentCompositionId());
		fragmentCompositionImpl.setGroupId(getGroupId());
		fragmentCompositionImpl.setCompanyId(getCompanyId());
		fragmentCompositionImpl.setUserId(getUserId());
		fragmentCompositionImpl.setUserName(getUserName());
		fragmentCompositionImpl.setCreateDate(getCreateDate());
		fragmentCompositionImpl.setModifiedDate(getModifiedDate());
		fragmentCompositionImpl.setFragmentCollectionId(
			getFragmentCollectionId());
		fragmentCompositionImpl.setFragmentCompositionKey(
			getFragmentCompositionKey());
		fragmentCompositionImpl.setName(getName());
		fragmentCompositionImpl.setDescription(getDescription());
		fragmentCompositionImpl.setData(getData());
		fragmentCompositionImpl.setPreviewFileEntryId(getPreviewFileEntryId());
		fragmentCompositionImpl.setLastPublishDate(getLastPublishDate());
		fragmentCompositionImpl.setStatus(getStatus());
		fragmentCompositionImpl.setStatusByUserId(getStatusByUserId());
		fragmentCompositionImpl.setStatusByUserName(getStatusByUserName());
		fragmentCompositionImpl.setStatusDate(getStatusDate());

		fragmentCompositionImpl.resetOriginalValues();

		return fragmentCompositionImpl;
	}

	@Override
	public FragmentComposition cloneWithOriginalValues() {
		FragmentCompositionImpl fragmentCompositionImpl =
			new FragmentCompositionImpl();

		fragmentCompositionImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		fragmentCompositionImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		fragmentCompositionImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		fragmentCompositionImpl.setFragmentCompositionId(
			this.<Long>getColumnOriginalValue("fragmentCompositionId"));
		fragmentCompositionImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		fragmentCompositionImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		fragmentCompositionImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		fragmentCompositionImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		fragmentCompositionImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		fragmentCompositionImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		fragmentCompositionImpl.setFragmentCollectionId(
			this.<Long>getColumnOriginalValue("fragmentCollectionId"));
		fragmentCompositionImpl.setFragmentCompositionKey(
			this.<String>getColumnOriginalValue("fragmentCompositionKey"));
		fragmentCompositionImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		fragmentCompositionImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		fragmentCompositionImpl.setData(
			this.<String>getColumnOriginalValue("data_"));
		fragmentCompositionImpl.setPreviewFileEntryId(
			this.<Long>getColumnOriginalValue("previewFileEntryId"));
		fragmentCompositionImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));
		fragmentCompositionImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));
		fragmentCompositionImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		fragmentCompositionImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		fragmentCompositionImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return fragmentCompositionImpl;
	}

	@Override
	public int compareTo(FragmentComposition fragmentComposition) {
		int value = 0;

		value = getName().compareTo(fragmentComposition.getName());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof FragmentComposition)) {
			return false;
		}

		FragmentComposition fragmentComposition = (FragmentComposition)object;

		long primaryKey = fragmentComposition.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<FragmentComposition> toCacheModel() {
		FragmentCompositionCacheModel fragmentCompositionCacheModel =
			new FragmentCompositionCacheModel();

		fragmentCompositionCacheModel.mvccVersion = getMvccVersion();

		fragmentCompositionCacheModel.ctCollectionId = getCtCollectionId();

		fragmentCompositionCacheModel.uuid = getUuid();

		String uuid = fragmentCompositionCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			fragmentCompositionCacheModel.uuid = null;
		}

		fragmentCompositionCacheModel.fragmentCompositionId =
			getFragmentCompositionId();

		fragmentCompositionCacheModel.groupId = getGroupId();

		fragmentCompositionCacheModel.companyId = getCompanyId();

		fragmentCompositionCacheModel.userId = getUserId();

		fragmentCompositionCacheModel.userName = getUserName();

		String userName = fragmentCompositionCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			fragmentCompositionCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			fragmentCompositionCacheModel.createDate = createDate.getTime();
		}
		else {
			fragmentCompositionCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			fragmentCompositionCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			fragmentCompositionCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		fragmentCompositionCacheModel.fragmentCollectionId =
			getFragmentCollectionId();

		fragmentCompositionCacheModel.fragmentCompositionKey =
			getFragmentCompositionKey();

		String fragmentCompositionKey =
			fragmentCompositionCacheModel.fragmentCompositionKey;

		if ((fragmentCompositionKey != null) &&
			(fragmentCompositionKey.length() == 0)) {

			fragmentCompositionCacheModel.fragmentCompositionKey = null;
		}

		fragmentCompositionCacheModel.name = getName();

		String name = fragmentCompositionCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			fragmentCompositionCacheModel.name = null;
		}

		fragmentCompositionCacheModel.description = getDescription();

		String description = fragmentCompositionCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			fragmentCompositionCacheModel.description = null;
		}

		fragmentCompositionCacheModel.data = getData();

		String data = fragmentCompositionCacheModel.data;

		if ((data != null) && (data.length() == 0)) {
			fragmentCompositionCacheModel.data = null;
		}

		fragmentCompositionCacheModel.previewFileEntryId =
			getPreviewFileEntryId();

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			fragmentCompositionCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			fragmentCompositionCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		fragmentCompositionCacheModel.status = getStatus();

		fragmentCompositionCacheModel.statusByUserId = getStatusByUserId();

		fragmentCompositionCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName =
			fragmentCompositionCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			fragmentCompositionCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			fragmentCompositionCacheModel.statusDate = statusDate.getTime();
		}
		else {
			fragmentCompositionCacheModel.statusDate = Long.MIN_VALUE;
		}

		return fragmentCompositionCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<FragmentComposition, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<FragmentComposition, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<FragmentComposition, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(FragmentComposition)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<FragmentComposition, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<FragmentComposition, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<FragmentComposition, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((FragmentComposition)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, FragmentComposition>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					FragmentComposition.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _fragmentCompositionId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _fragmentCollectionId;
	private String _fragmentCompositionKey;
	private String _name;
	private String _description;
	private String _data;
	private long _previewFileEntryId;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<FragmentComposition, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((FragmentComposition)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"fragmentCompositionId", _fragmentCompositionId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"fragmentCollectionId", _fragmentCollectionId);
		_columnOriginalValues.put(
			"fragmentCompositionKey", _fragmentCompositionKey);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("data_", _data);
		_columnOriginalValues.put("previewFileEntryId", _previewFileEntryId);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("data_", "data");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("fragmentCompositionId", 8L);

		columnBitmasks.put("groupId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("fragmentCollectionId", 1024L);

		columnBitmasks.put("fragmentCompositionKey", 2048L);

		columnBitmasks.put("name", 4096L);

		columnBitmasks.put("description", 8192L);

		columnBitmasks.put("data_", 16384L);

		columnBitmasks.put("previewFileEntryId", 32768L);

		columnBitmasks.put("lastPublishDate", 65536L);

		columnBitmasks.put("status", 131072L);

		columnBitmasks.put("statusByUserId", 262144L);

		columnBitmasks.put("statusByUserName", 524288L);

		columnBitmasks.put("statusDate", 1048576L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private FragmentComposition _escapedModel;

}