/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.fragment.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.model.FragmentEntryLinkModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the FragmentEntryLink service. Represents a row in the &quot;FragmentEntryLink&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>FragmentEntryLinkModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link FragmentEntryLinkImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see FragmentEntryLinkImpl
 * @generated
 */
@JSON(strict = true)
public class FragmentEntryLinkModelImpl
	extends BaseModelImpl<FragmentEntryLink> implements FragmentEntryLinkModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a fragment entry link model instance should use the <code>FragmentEntryLink</code> interface instead.
	 */
	public static final String TABLE_NAME = "FragmentEntryLink";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"fragmentEntryLinkId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"originalFragmentEntryLinkId", Types.BIGINT},
		{"fragmentEntryId", Types.BIGINT},
		{"segmentsExperienceId", Types.BIGINT}, {"classNameId", Types.BIGINT},
		{"classPK", Types.BIGINT}, {"plid", Types.BIGINT}, {"css", Types.CLOB},
		{"html", Types.CLOB}, {"js", Types.CLOB}, {"configuration", Types.CLOB},
		{"editableValues", Types.CLOB}, {"namespace", Types.VARCHAR},
		{"position", Types.INTEGER}, {"rendererKey", Types.VARCHAR},
		{"type_", Types.INTEGER}, {"lastPropagationDate", Types.TIMESTAMP},
		{"lastPublishDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("fragmentEntryLinkId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("originalFragmentEntryLinkId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("fragmentEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("segmentsExperienceId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("plid", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("css", Types.CLOB);
		TABLE_COLUMNS_MAP.put("html", Types.CLOB);
		TABLE_COLUMNS_MAP.put("js", Types.CLOB);
		TABLE_COLUMNS_MAP.put("configuration", Types.CLOB);
		TABLE_COLUMNS_MAP.put("editableValues", Types.CLOB);
		TABLE_COLUMNS_MAP.put("namespace", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("position", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("rendererKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("type_", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("lastPropagationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table FragmentEntryLink (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,fragmentEntryLinkId LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,originalFragmentEntryLinkId LONG,fragmentEntryId LONG,segmentsExperienceId LONG,classNameId LONG,classPK LONG,plid LONG,css TEXT null,html TEXT null,js TEXT null,configuration TEXT null,editableValues TEXT null,namespace VARCHAR(75) null,position INTEGER,rendererKey VARCHAR(200) null,type_ INTEGER,lastPropagationDate DATE null,lastPublishDate DATE null,primary key (fragmentEntryLinkId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table FragmentEntryLink";

	public static final String ORDER_BY_JPQL =
		" ORDER BY fragmentEntryLink.classNameId ASC, fragmentEntryLink.classPK ASC, fragmentEntryLink.position ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY FragmentEntryLink.classNameId ASC, FragmentEntryLink.classPK ASC, FragmentEntryLink.position ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FRAGMENTENTRYID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ORIGINALFRAGMENTENTRYLINKID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PLID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long RENDERERKEY_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SEGMENTSEXPERIENCEID_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long POSITION_COLUMN_BITMASK = 1024L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public FragmentEntryLinkModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _fragmentEntryLinkId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setFragmentEntryLinkId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _fragmentEntryLinkId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return FragmentEntryLink.class;
	}

	@Override
	public String getModelClassName() {
		return FragmentEntryLink.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<FragmentEntryLink, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<FragmentEntryLink, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<FragmentEntryLink, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((FragmentEntryLink)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<FragmentEntryLink, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<FragmentEntryLink, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(FragmentEntryLink)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<FragmentEntryLink, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<FragmentEntryLink, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<FragmentEntryLink, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<FragmentEntryLink, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<FragmentEntryLink, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<FragmentEntryLink, Object>>();
		Map<String, BiConsumer<FragmentEntryLink, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<FragmentEntryLink, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", FragmentEntryLink::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<FragmentEntryLink, Long>)
				FragmentEntryLink::setMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", FragmentEntryLink::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<FragmentEntryLink, Long>)
				FragmentEntryLink::setCtCollectionId);
		attributeGetterFunctions.put("uuid", FragmentEntryLink::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<FragmentEntryLink, String>)FragmentEntryLink::setUuid);
		attributeGetterFunctions.put(
			"fragmentEntryLinkId", FragmentEntryLink::getFragmentEntryLinkId);
		attributeSetterBiConsumers.put(
			"fragmentEntryLinkId",
			(BiConsumer<FragmentEntryLink, Long>)
				FragmentEntryLink::setFragmentEntryLinkId);
		attributeGetterFunctions.put("groupId", FragmentEntryLink::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<FragmentEntryLink, Long>)FragmentEntryLink::setGroupId);
		attributeGetterFunctions.put(
			"companyId", FragmentEntryLink::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<FragmentEntryLink, Long>)
				FragmentEntryLink::setCompanyId);
		attributeGetterFunctions.put("userId", FragmentEntryLink::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<FragmentEntryLink, Long>)FragmentEntryLink::setUserId);
		attributeGetterFunctions.put(
			"userName", FragmentEntryLink::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<FragmentEntryLink, String>)
				FragmentEntryLink::setUserName);
		attributeGetterFunctions.put(
			"createDate", FragmentEntryLink::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<FragmentEntryLink, Date>)
				FragmentEntryLink::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", FragmentEntryLink::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<FragmentEntryLink, Date>)
				FragmentEntryLink::setModifiedDate);
		attributeGetterFunctions.put(
			"originalFragmentEntryLinkId",
			FragmentEntryLink::getOriginalFragmentEntryLinkId);
		attributeSetterBiConsumers.put(
			"originalFragmentEntryLinkId",
			(BiConsumer<FragmentEntryLink, Long>)
				FragmentEntryLink::setOriginalFragmentEntryLinkId);
		attributeGetterFunctions.put(
			"fragmentEntryId", FragmentEntryLink::getFragmentEntryId);
		attributeSetterBiConsumers.put(
			"fragmentEntryId",
			(BiConsumer<FragmentEntryLink, Long>)
				FragmentEntryLink::setFragmentEntryId);
		attributeGetterFunctions.put(
			"segmentsExperienceId", FragmentEntryLink::getSegmentsExperienceId);
		attributeSetterBiConsumers.put(
			"segmentsExperienceId",
			(BiConsumer<FragmentEntryLink, Long>)
				FragmentEntryLink::setSegmentsExperienceId);
		attributeGetterFunctions.put(
			"classNameId", FragmentEntryLink::getClassNameId);
		attributeSetterBiConsumers.put(
			"classNameId",
			(BiConsumer<FragmentEntryLink, Long>)
				FragmentEntryLink::setClassNameId);
		attributeGetterFunctions.put("classPK", FragmentEntryLink::getClassPK);
		attributeSetterBiConsumers.put(
			"classPK",
			(BiConsumer<FragmentEntryLink, Long>)FragmentEntryLink::setClassPK);
		attributeGetterFunctions.put("plid", FragmentEntryLink::getPlid);
		attributeSetterBiConsumers.put(
			"plid",
			(BiConsumer<FragmentEntryLink, Long>)FragmentEntryLink::setPlid);
		attributeGetterFunctions.put("css", FragmentEntryLink::getCss);
		attributeSetterBiConsumers.put(
			"css",
			(BiConsumer<FragmentEntryLink, String>)FragmentEntryLink::setCss);
		attributeGetterFunctions.put("html", FragmentEntryLink::getHtml);
		attributeSetterBiConsumers.put(
			"html",
			(BiConsumer<FragmentEntryLink, String>)FragmentEntryLink::setHtml);
		attributeGetterFunctions.put("js", FragmentEntryLink::getJs);
		attributeSetterBiConsumers.put(
			"js",
			(BiConsumer<FragmentEntryLink, String>)FragmentEntryLink::setJs);
		attributeGetterFunctions.put(
			"configuration", FragmentEntryLink::getConfiguration);
		attributeSetterBiConsumers.put(
			"configuration",
			(BiConsumer<FragmentEntryLink, String>)
				FragmentEntryLink::setConfiguration);
		attributeGetterFunctions.put(
			"editableValues", FragmentEntryLink::getEditableValues);
		attributeSetterBiConsumers.put(
			"editableValues",
			(BiConsumer<FragmentEntryLink, String>)
				FragmentEntryLink::setEditableValues);
		attributeGetterFunctions.put(
			"namespace", FragmentEntryLink::getNamespace);
		attributeSetterBiConsumers.put(
			"namespace",
			(BiConsumer<FragmentEntryLink, String>)
				FragmentEntryLink::setNamespace);
		attributeGetterFunctions.put(
			"position", FragmentEntryLink::getPosition);
		attributeSetterBiConsumers.put(
			"position",
			(BiConsumer<FragmentEntryLink, Integer>)
				FragmentEntryLink::setPosition);
		attributeGetterFunctions.put(
			"rendererKey", FragmentEntryLink::getRendererKey);
		attributeSetterBiConsumers.put(
			"rendererKey",
			(BiConsumer<FragmentEntryLink, String>)
				FragmentEntryLink::setRendererKey);
		attributeGetterFunctions.put("type", FragmentEntryLink::getType);
		attributeSetterBiConsumers.put(
			"type",
			(BiConsumer<FragmentEntryLink, Integer>)FragmentEntryLink::setType);
		attributeGetterFunctions.put(
			"lastPropagationDate", FragmentEntryLink::getLastPropagationDate);
		attributeSetterBiConsumers.put(
			"lastPropagationDate",
			(BiConsumer<FragmentEntryLink, Date>)
				FragmentEntryLink::setLastPropagationDate);
		attributeGetterFunctions.put(
			"lastPublishDate", FragmentEntryLink::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<FragmentEntryLink, Date>)
				FragmentEntryLink::setLastPublishDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getFragmentEntryLinkId() {
		return _fragmentEntryLinkId;
	}

	@Override
	public void setFragmentEntryLinkId(long fragmentEntryLinkId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fragmentEntryLinkId = fragmentEntryLinkId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getOriginalFragmentEntryLinkId() {
		return _originalFragmentEntryLinkId;
	}

	@Override
	public void setOriginalFragmentEntryLinkId(
		long originalFragmentEntryLinkId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_originalFragmentEntryLinkId = originalFragmentEntryLinkId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalOriginalFragmentEntryLinkId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("originalFragmentEntryLinkId"));
	}

	@JSON
	@Override
	public long getFragmentEntryId() {
		return _fragmentEntryId;
	}

	@Override
	public void setFragmentEntryId(long fragmentEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fragmentEntryId = fragmentEntryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalFragmentEntryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("fragmentEntryId"));
	}

	@JSON
	@Override
	public long getSegmentsExperienceId() {
		return _segmentsExperienceId;
	}

	@Override
	public void setSegmentsExperienceId(long segmentsExperienceId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_segmentsExperienceId = segmentsExperienceId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalSegmentsExperienceId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("segmentsExperienceId"));
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@JSON
	@Override
	public long getPlid() {
		return _plid;
	}

	@Override
	public void setPlid(long plid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_plid = plid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalPlid() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("plid"));
	}

	@JSON
	@Override
	public String getCss() {
		if (_css == null) {
			return "";
		}
		else {
			return _css;
		}
	}

	@Override
	public void setCss(String css) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_css = css;
	}

	@JSON
	@Override
	public String getHtml() {
		if (_html == null) {
			return "";
		}
		else {
			return _html;
		}
	}

	@Override
	public void setHtml(String html) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_html = html;
	}

	@JSON
	@Override
	public String getJs() {
		if (_js == null) {
			return "";
		}
		else {
			return _js;
		}
	}

	@Override
	public void setJs(String js) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_js = js;
	}

	@JSON
	@Override
	public String getConfiguration() {
		if (_configuration == null) {
			return "";
		}
		else {
			return _configuration;
		}
	}

	@Override
	public void setConfiguration(String configuration) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_configuration = configuration;
	}

	@JSON
	@Override
	public String getEditableValues() {
		if (_editableValues == null) {
			return "";
		}
		else {
			return _editableValues;
		}
	}

	@Override
	public void setEditableValues(String editableValues) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_editableValues = editableValues;
	}

	@JSON
	@Override
	public String getNamespace() {
		if (_namespace == null) {
			return "";
		}
		else {
			return _namespace;
		}
	}

	@Override
	public void setNamespace(String namespace) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_namespace = namespace;
	}

	@JSON
	@Override
	public int getPosition() {
		return _position;
	}

	@Override
	public void setPosition(int position) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_position = position;
	}

	@JSON
	@Override
	public String getRendererKey() {
		if (_rendererKey == null) {
			return "";
		}
		else {
			return _rendererKey;
		}
	}

	@Override
	public void setRendererKey(String rendererKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_rendererKey = rendererKey;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalRendererKey() {
		return getColumnOriginalValue("rendererKey");
	}

	@JSON
	@Override
	public int getType() {
		return _type;
	}

	@Override
	public void setType(int type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	@JSON
	@Override
	public Date getLastPropagationDate() {
		return _lastPropagationDate;
	}

	@Override
	public void setLastPropagationDate(Date lastPropagationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPropagationDate = lastPropagationDate;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(FragmentEntryLink.class.getName()),
			getClassNameId());
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), FragmentEntryLink.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public FragmentEntryLink toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, FragmentEntryLink>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		FragmentEntryLinkImpl fragmentEntryLinkImpl =
			new FragmentEntryLinkImpl();

		fragmentEntryLinkImpl.setMvccVersion(getMvccVersion());
		fragmentEntryLinkImpl.setCtCollectionId(getCtCollectionId());
		fragmentEntryLinkImpl.setUuid(getUuid());
		fragmentEntryLinkImpl.setFragmentEntryLinkId(getFragmentEntryLinkId());
		fragmentEntryLinkImpl.setGroupId(getGroupId());
		fragmentEntryLinkImpl.setCompanyId(getCompanyId());
		fragmentEntryLinkImpl.setUserId(getUserId());
		fragmentEntryLinkImpl.setUserName(getUserName());
		fragmentEntryLinkImpl.setCreateDate(getCreateDate());
		fragmentEntryLinkImpl.setModifiedDate(getModifiedDate());
		fragmentEntryLinkImpl.setOriginalFragmentEntryLinkId(
			getOriginalFragmentEntryLinkId());
		fragmentEntryLinkImpl.setFragmentEntryId(getFragmentEntryId());
		fragmentEntryLinkImpl.setSegmentsExperienceId(
			getSegmentsExperienceId());
		fragmentEntryLinkImpl.setClassNameId(getClassNameId());
		fragmentEntryLinkImpl.setClassPK(getClassPK());
		fragmentEntryLinkImpl.setPlid(getPlid());
		fragmentEntryLinkImpl.setCss(getCss());
		fragmentEntryLinkImpl.setHtml(getHtml());
		fragmentEntryLinkImpl.setJs(getJs());
		fragmentEntryLinkImpl.setConfiguration(getConfiguration());
		fragmentEntryLinkImpl.setEditableValues(getEditableValues());
		fragmentEntryLinkImpl.setNamespace(getNamespace());
		fragmentEntryLinkImpl.setPosition(getPosition());
		fragmentEntryLinkImpl.setRendererKey(getRendererKey());
		fragmentEntryLinkImpl.setType(getType());
		fragmentEntryLinkImpl.setLastPropagationDate(getLastPropagationDate());
		fragmentEntryLinkImpl.setLastPublishDate(getLastPublishDate());

		fragmentEntryLinkImpl.resetOriginalValues();

		return fragmentEntryLinkImpl;
	}

	@Override
	public FragmentEntryLink cloneWithOriginalValues() {
		FragmentEntryLinkImpl fragmentEntryLinkImpl =
			new FragmentEntryLinkImpl();

		fragmentEntryLinkImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		fragmentEntryLinkImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		fragmentEntryLinkImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		fragmentEntryLinkImpl.setFragmentEntryLinkId(
			this.<Long>getColumnOriginalValue("fragmentEntryLinkId"));
		fragmentEntryLinkImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		fragmentEntryLinkImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		fragmentEntryLinkImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		fragmentEntryLinkImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		fragmentEntryLinkImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		fragmentEntryLinkImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		fragmentEntryLinkImpl.setOriginalFragmentEntryLinkId(
			this.<Long>getColumnOriginalValue("originalFragmentEntryLinkId"));
		fragmentEntryLinkImpl.setFragmentEntryId(
			this.<Long>getColumnOriginalValue("fragmentEntryId"));
		fragmentEntryLinkImpl.setSegmentsExperienceId(
			this.<Long>getColumnOriginalValue("segmentsExperienceId"));
		fragmentEntryLinkImpl.setClassNameId(
			this.<Long>getColumnOriginalValue("classNameId"));
		fragmentEntryLinkImpl.setClassPK(
			this.<Long>getColumnOriginalValue("classPK"));
		fragmentEntryLinkImpl.setPlid(
			this.<Long>getColumnOriginalValue("plid"));
		fragmentEntryLinkImpl.setCss(
			this.<String>getColumnOriginalValue("css"));
		fragmentEntryLinkImpl.setHtml(
			this.<String>getColumnOriginalValue("html"));
		fragmentEntryLinkImpl.setJs(this.<String>getColumnOriginalValue("js"));
		fragmentEntryLinkImpl.setConfiguration(
			this.<String>getColumnOriginalValue("configuration"));
		fragmentEntryLinkImpl.setEditableValues(
			this.<String>getColumnOriginalValue("editableValues"));
		fragmentEntryLinkImpl.setNamespace(
			this.<String>getColumnOriginalValue("namespace"));
		fragmentEntryLinkImpl.setPosition(
			this.<Integer>getColumnOriginalValue("position"));
		fragmentEntryLinkImpl.setRendererKey(
			this.<String>getColumnOriginalValue("rendererKey"));
		fragmentEntryLinkImpl.setType(
			this.<Integer>getColumnOriginalValue("type_"));
		fragmentEntryLinkImpl.setLastPropagationDate(
			this.<Date>getColumnOriginalValue("lastPropagationDate"));
		fragmentEntryLinkImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));

		return fragmentEntryLinkImpl;
	}

	@Override
	public int compareTo(FragmentEntryLink fragmentEntryLink) {
		int value = 0;

		if (getClassNameId() < fragmentEntryLink.getClassNameId()) {
			value = -1;
		}
		else if (getClassNameId() > fragmentEntryLink.getClassNameId()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		if (getClassPK() < fragmentEntryLink.getClassPK()) {
			value = -1;
		}
		else if (getClassPK() > fragmentEntryLink.getClassPK()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		if (getPosition() < fragmentEntryLink.getPosition()) {
			value = -1;
		}
		else if (getPosition() > fragmentEntryLink.getPosition()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof FragmentEntryLink)) {
			return false;
		}

		FragmentEntryLink fragmentEntryLink = (FragmentEntryLink)object;

		long primaryKey = fragmentEntryLink.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<FragmentEntryLink> toCacheModel() {
		FragmentEntryLinkCacheModel fragmentEntryLinkCacheModel =
			new FragmentEntryLinkCacheModel();

		fragmentEntryLinkCacheModel.mvccVersion = getMvccVersion();

		fragmentEntryLinkCacheModel.ctCollectionId = getCtCollectionId();

		fragmentEntryLinkCacheModel.uuid = getUuid();

		String uuid = fragmentEntryLinkCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			fragmentEntryLinkCacheModel.uuid = null;
		}

		fragmentEntryLinkCacheModel.fragmentEntryLinkId =
			getFragmentEntryLinkId();

		fragmentEntryLinkCacheModel.groupId = getGroupId();

		fragmentEntryLinkCacheModel.companyId = getCompanyId();

		fragmentEntryLinkCacheModel.userId = getUserId();

		fragmentEntryLinkCacheModel.userName = getUserName();

		String userName = fragmentEntryLinkCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			fragmentEntryLinkCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			fragmentEntryLinkCacheModel.createDate = createDate.getTime();
		}
		else {
			fragmentEntryLinkCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			fragmentEntryLinkCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			fragmentEntryLinkCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		fragmentEntryLinkCacheModel.originalFragmentEntryLinkId =
			getOriginalFragmentEntryLinkId();

		fragmentEntryLinkCacheModel.fragmentEntryId = getFragmentEntryId();

		fragmentEntryLinkCacheModel.segmentsExperienceId =
			getSegmentsExperienceId();

		fragmentEntryLinkCacheModel.classNameId = getClassNameId();

		fragmentEntryLinkCacheModel.classPK = getClassPK();

		fragmentEntryLinkCacheModel.plid = getPlid();

		fragmentEntryLinkCacheModel.css = getCss();

		String css = fragmentEntryLinkCacheModel.css;

		if ((css != null) && (css.length() == 0)) {
			fragmentEntryLinkCacheModel.css = null;
		}

		fragmentEntryLinkCacheModel.html = getHtml();

		String html = fragmentEntryLinkCacheModel.html;

		if ((html != null) && (html.length() == 0)) {
			fragmentEntryLinkCacheModel.html = null;
		}

		fragmentEntryLinkCacheModel.js = getJs();

		String js = fragmentEntryLinkCacheModel.js;

		if ((js != null) && (js.length() == 0)) {
			fragmentEntryLinkCacheModel.js = null;
		}

		fragmentEntryLinkCacheModel.configuration = getConfiguration();

		String configuration = fragmentEntryLinkCacheModel.configuration;

		if ((configuration != null) && (configuration.length() == 0)) {
			fragmentEntryLinkCacheModel.configuration = null;
		}

		fragmentEntryLinkCacheModel.editableValues = getEditableValues();

		String editableValues = fragmentEntryLinkCacheModel.editableValues;

		if ((editableValues != null) && (editableValues.length() == 0)) {
			fragmentEntryLinkCacheModel.editableValues = null;
		}

		fragmentEntryLinkCacheModel.namespace = getNamespace();

		String namespace = fragmentEntryLinkCacheModel.namespace;

		if ((namespace != null) && (namespace.length() == 0)) {
			fragmentEntryLinkCacheModel.namespace = null;
		}

		fragmentEntryLinkCacheModel.position = getPosition();

		fragmentEntryLinkCacheModel.rendererKey = getRendererKey();

		String rendererKey = fragmentEntryLinkCacheModel.rendererKey;

		if ((rendererKey != null) && (rendererKey.length() == 0)) {
			fragmentEntryLinkCacheModel.rendererKey = null;
		}

		fragmentEntryLinkCacheModel.type = getType();

		Date lastPropagationDate = getLastPropagationDate();

		if (lastPropagationDate != null) {
			fragmentEntryLinkCacheModel.lastPropagationDate =
				lastPropagationDate.getTime();
		}
		else {
			fragmentEntryLinkCacheModel.lastPropagationDate = Long.MIN_VALUE;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			fragmentEntryLinkCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			fragmentEntryLinkCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		return fragmentEntryLinkCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<FragmentEntryLink, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<FragmentEntryLink, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<FragmentEntryLink, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(FragmentEntryLink)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<FragmentEntryLink, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<FragmentEntryLink, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<FragmentEntryLink, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((FragmentEntryLink)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, FragmentEntryLink>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					FragmentEntryLink.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _fragmentEntryLinkId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _originalFragmentEntryLinkId;
	private long _fragmentEntryId;
	private long _segmentsExperienceId;
	private long _classNameId;
	private long _classPK;
	private long _plid;
	private String _css;
	private String _html;
	private String _js;
	private String _configuration;
	private String _editableValues;
	private String _namespace;
	private int _position;
	private String _rendererKey;
	private int _type;
	private Date _lastPropagationDate;
	private Date _lastPublishDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<FragmentEntryLink, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((FragmentEntryLink)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("fragmentEntryLinkId", _fragmentEntryLinkId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"originalFragmentEntryLinkId", _originalFragmentEntryLinkId);
		_columnOriginalValues.put("fragmentEntryId", _fragmentEntryId);
		_columnOriginalValues.put(
			"segmentsExperienceId", _segmentsExperienceId);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put("plid", _plid);
		_columnOriginalValues.put("css", _css);
		_columnOriginalValues.put("html", _html);
		_columnOriginalValues.put("js", _js);
		_columnOriginalValues.put("configuration", _configuration);
		_columnOriginalValues.put("editableValues", _editableValues);
		_columnOriginalValues.put("namespace", _namespace);
		_columnOriginalValues.put("position", _position);
		_columnOriginalValues.put("rendererKey", _rendererKey);
		_columnOriginalValues.put("type_", _type);
		_columnOriginalValues.put("lastPropagationDate", _lastPropagationDate);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("fragmentEntryLinkId", 8L);

		columnBitmasks.put("groupId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("originalFragmentEntryLinkId", 1024L);

		columnBitmasks.put("fragmentEntryId", 2048L);

		columnBitmasks.put("segmentsExperienceId", 4096L);

		columnBitmasks.put("classNameId", 8192L);

		columnBitmasks.put("classPK", 16384L);

		columnBitmasks.put("plid", 32768L);

		columnBitmasks.put("css", 65536L);

		columnBitmasks.put("html", 131072L);

		columnBitmasks.put("js", 262144L);

		columnBitmasks.put("configuration", 524288L);

		columnBitmasks.put("editableValues", 1048576L);

		columnBitmasks.put("namespace", 2097152L);

		columnBitmasks.put("position", 4194304L);

		columnBitmasks.put("rendererKey", 8388608L);

		columnBitmasks.put("type_", 16777216L);

		columnBitmasks.put("lastPropagationDate", 33554432L);

		columnBitmasks.put("lastPublishDate", 67108864L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private FragmentEntryLink _escapedModel;

}