/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.fragment.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryVersion;
import com.liferay.fragment.model.FragmentEntryVersionModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the FragmentEntryVersion service. Represents a row in the &quot;FragmentEntryVersion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>FragmentEntryVersionModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link FragmentEntryVersionImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see FragmentEntryVersionImpl
 * @generated
 */
public class FragmentEntryVersionModelImpl
	extends BaseModelImpl<FragmentEntryVersion>
	implements FragmentEntryVersionModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a fragment entry version model instance should use the <code>FragmentEntryVersion</code> interface instead.
	 */
	public static final String TABLE_NAME = "FragmentEntryVersion";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"fragmentEntryVersionId", Types.BIGINT}, {"version", Types.INTEGER},
		{"uuid_", Types.VARCHAR}, {"fragmentEntryId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"fragmentCollectionId", Types.BIGINT},
		{"fragmentEntryKey", Types.VARCHAR}, {"name", Types.VARCHAR},
		{"css", Types.CLOB}, {"html", Types.CLOB}, {"js", Types.CLOB},
		{"cacheable", Types.BOOLEAN}, {"configuration", Types.CLOB},
		{"icon", Types.VARCHAR}, {"previewFileEntryId", Types.BIGINT},
		{"readOnly", Types.BOOLEAN}, {"type_", Types.INTEGER},
		{"typeOptions", Types.CLOB}, {"lastPublishDate", Types.TIMESTAMP},
		{"status", Types.INTEGER}, {"statusByUserId", Types.BIGINT},
		{"statusByUserName", Types.VARCHAR}, {"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("fragmentEntryVersionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("version", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("fragmentEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("fragmentCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("fragmentEntryKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("css", Types.CLOB);
		TABLE_COLUMNS_MAP.put("html", Types.CLOB);
		TABLE_COLUMNS_MAP.put("js", Types.CLOB);
		TABLE_COLUMNS_MAP.put("cacheable", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("configuration", Types.CLOB);
		TABLE_COLUMNS_MAP.put("icon", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("previewFileEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("readOnly", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("type_", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("typeOptions", Types.CLOB);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table FragmentEntryVersion (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,fragmentEntryVersionId LONG not null,version INTEGER,uuid_ VARCHAR(75) null,fragmentEntryId LONG,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,fragmentCollectionId LONG,fragmentEntryKey VARCHAR(75) null,name VARCHAR(75) null,css TEXT null,html TEXT null,js TEXT null,cacheable BOOLEAN,configuration TEXT null,icon VARCHAR(75) null,previewFileEntryId LONG,readOnly BOOLEAN,type_ INTEGER,typeOptions TEXT null,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null,primary key (fragmentEntryVersionId, ctCollectionId))";

	public static final String TABLE_SQL_DROP =
		"drop table FragmentEntryVersion";

	public static final String ORDER_BY_JPQL =
		" ORDER BY fragmentEntryVersion.version DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY FragmentEntryVersion.version DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FRAGMENTCOLLECTIONID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FRAGMENTENTRYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FRAGMENTENTRYKEY_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TYPE_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long VERSION_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public FragmentEntryVersionModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _fragmentEntryVersionId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setFragmentEntryVersionId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _fragmentEntryVersionId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return FragmentEntryVersion.class;
	}

	@Override
	public String getModelClassName() {
		return FragmentEntryVersion.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<FragmentEntryVersion, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<FragmentEntryVersion, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<FragmentEntryVersion, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((FragmentEntryVersion)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<FragmentEntryVersion, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<FragmentEntryVersion, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(FragmentEntryVersion)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<FragmentEntryVersion, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<FragmentEntryVersion, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<FragmentEntryVersion, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<FragmentEntryVersion, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<FragmentEntryVersion, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<FragmentEntryVersion, Object>>();
		Map<String, BiConsumer<FragmentEntryVersion, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<FragmentEntryVersion, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", FragmentEntryVersion::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<FragmentEntryVersion, Long>)
				FragmentEntryVersion::setMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", FragmentEntryVersion::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<FragmentEntryVersion, Long>)
				FragmentEntryVersion::setCtCollectionId);
		attributeGetterFunctions.put(
			"fragmentEntryVersionId",
			FragmentEntryVersion::getFragmentEntryVersionId);
		attributeSetterBiConsumers.put(
			"fragmentEntryVersionId",
			(BiConsumer<FragmentEntryVersion, Long>)
				FragmentEntryVersion::setFragmentEntryVersionId);
		attributeGetterFunctions.put(
			"version", FragmentEntryVersion::getVersion);
		attributeSetterBiConsumers.put(
			"version",
			(BiConsumer<FragmentEntryVersion, Integer>)
				FragmentEntryVersion::setVersion);
		attributeGetterFunctions.put("uuid", FragmentEntryVersion::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<FragmentEntryVersion, String>)
				FragmentEntryVersion::setUuid);
		attributeGetterFunctions.put(
			"fragmentEntryId", FragmentEntryVersion::getFragmentEntryId);
		attributeSetterBiConsumers.put(
			"fragmentEntryId",
			(BiConsumer<FragmentEntryVersion, Long>)
				FragmentEntryVersion::setFragmentEntryId);
		attributeGetterFunctions.put(
			"groupId", FragmentEntryVersion::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<FragmentEntryVersion, Long>)
				FragmentEntryVersion::setGroupId);
		attributeGetterFunctions.put(
			"companyId", FragmentEntryVersion::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<FragmentEntryVersion, Long>)
				FragmentEntryVersion::setCompanyId);
		attributeGetterFunctions.put("userId", FragmentEntryVersion::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<FragmentEntryVersion, Long>)
				FragmentEntryVersion::setUserId);
		attributeGetterFunctions.put(
			"userName", FragmentEntryVersion::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<FragmentEntryVersion, String>)
				FragmentEntryVersion::setUserName);
		attributeGetterFunctions.put(
			"createDate", FragmentEntryVersion::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<FragmentEntryVersion, Date>)
				FragmentEntryVersion::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", FragmentEntryVersion::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<FragmentEntryVersion, Date>)
				FragmentEntryVersion::setModifiedDate);
		attributeGetterFunctions.put(
			"fragmentCollectionId",
			FragmentEntryVersion::getFragmentCollectionId);
		attributeSetterBiConsumers.put(
			"fragmentCollectionId",
			(BiConsumer<FragmentEntryVersion, Long>)
				FragmentEntryVersion::setFragmentCollectionId);
		attributeGetterFunctions.put(
			"fragmentEntryKey", FragmentEntryVersion::getFragmentEntryKey);
		attributeSetterBiConsumers.put(
			"fragmentEntryKey",
			(BiConsumer<FragmentEntryVersion, String>)
				FragmentEntryVersion::setFragmentEntryKey);
		attributeGetterFunctions.put("name", FragmentEntryVersion::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<FragmentEntryVersion, String>)
				FragmentEntryVersion::setName);
		attributeGetterFunctions.put("css", FragmentEntryVersion::getCss);
		attributeSetterBiConsumers.put(
			"css",
			(BiConsumer<FragmentEntryVersion, String>)
				FragmentEntryVersion::setCss);
		attributeGetterFunctions.put("html", FragmentEntryVersion::getHtml);
		attributeSetterBiConsumers.put(
			"html",
			(BiConsumer<FragmentEntryVersion, String>)
				FragmentEntryVersion::setHtml);
		attributeGetterFunctions.put("js", FragmentEntryVersion::getJs);
		attributeSetterBiConsumers.put(
			"js",
			(BiConsumer<FragmentEntryVersion, String>)
				FragmentEntryVersion::setJs);
		attributeGetterFunctions.put(
			"cacheable", FragmentEntryVersion::getCacheable);
		attributeSetterBiConsumers.put(
			"cacheable",
			(BiConsumer<FragmentEntryVersion, Boolean>)
				FragmentEntryVersion::setCacheable);
		attributeGetterFunctions.put(
			"configuration", FragmentEntryVersion::getConfiguration);
		attributeSetterBiConsumers.put(
			"configuration",
			(BiConsumer<FragmentEntryVersion, String>)
				FragmentEntryVersion::setConfiguration);
		attributeGetterFunctions.put("icon", FragmentEntryVersion::getIcon);
		attributeSetterBiConsumers.put(
			"icon",
			(BiConsumer<FragmentEntryVersion, String>)
				FragmentEntryVersion::setIcon);
		attributeGetterFunctions.put(
			"previewFileEntryId", FragmentEntryVersion::getPreviewFileEntryId);
		attributeSetterBiConsumers.put(
			"previewFileEntryId",
			(BiConsumer<FragmentEntryVersion, Long>)
				FragmentEntryVersion::setPreviewFileEntryId);
		attributeGetterFunctions.put(
			"readOnly", FragmentEntryVersion::getReadOnly);
		attributeSetterBiConsumers.put(
			"readOnly",
			(BiConsumer<FragmentEntryVersion, Boolean>)
				FragmentEntryVersion::setReadOnly);
		attributeGetterFunctions.put("type", FragmentEntryVersion::getType);
		attributeSetterBiConsumers.put(
			"type",
			(BiConsumer<FragmentEntryVersion, Integer>)
				FragmentEntryVersion::setType);
		attributeGetterFunctions.put(
			"typeOptions", FragmentEntryVersion::getTypeOptions);
		attributeSetterBiConsumers.put(
			"typeOptions",
			(BiConsumer<FragmentEntryVersion, String>)
				FragmentEntryVersion::setTypeOptions);
		attributeGetterFunctions.put(
			"lastPublishDate", FragmentEntryVersion::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<FragmentEntryVersion, Date>)
				FragmentEntryVersion::setLastPublishDate);
		attributeGetterFunctions.put("status", FragmentEntryVersion::getStatus);
		attributeSetterBiConsumers.put(
			"status",
			(BiConsumer<FragmentEntryVersion, Integer>)
				FragmentEntryVersion::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", FragmentEntryVersion::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<FragmentEntryVersion, Long>)
				FragmentEntryVersion::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", FragmentEntryVersion::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<FragmentEntryVersion, String>)
				FragmentEntryVersion::setStatusByUserName);
		attributeGetterFunctions.put(
			"statusDate", FragmentEntryVersion::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate",
			(BiConsumer<FragmentEntryVersion, Date>)
				FragmentEntryVersion::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getVersionedModelId() {
		return getFragmentEntryId();
	}

	@Override
	public void populateVersionedModel(FragmentEntry fragmentEntry) {
		fragmentEntry.setCtCollectionId(getCtCollectionId());
		fragmentEntry.setUuid(getUuid());
		fragmentEntry.setGroupId(getGroupId());
		fragmentEntry.setCompanyId(getCompanyId());
		fragmentEntry.setUserId(getUserId());
		fragmentEntry.setUserName(getUserName());
		fragmentEntry.setCreateDate(getCreateDate());
		fragmentEntry.setModifiedDate(getModifiedDate());
		fragmentEntry.setFragmentCollectionId(getFragmentCollectionId());
		fragmentEntry.setFragmentEntryKey(getFragmentEntryKey());
		fragmentEntry.setName(getName());
		fragmentEntry.setCss(getCss());
		fragmentEntry.setHtml(getHtml());
		fragmentEntry.setJs(getJs());
		fragmentEntry.setCacheable(getCacheable());
		fragmentEntry.setConfiguration(getConfiguration());
		fragmentEntry.setIcon(getIcon());
		fragmentEntry.setPreviewFileEntryId(getPreviewFileEntryId());
		fragmentEntry.setReadOnly(getReadOnly());
		fragmentEntry.setType(getType());
		fragmentEntry.setTypeOptions(getTypeOptions());
		fragmentEntry.setLastPublishDate(getLastPublishDate());
		fragmentEntry.setStatus(getStatus());
		fragmentEntry.setStatusByUserId(getStatusByUserId());
		fragmentEntry.setStatusByUserName(getStatusByUserName());
		fragmentEntry.setStatusDate(getStatusDate());
	}

	@Override
	public void setVersionedModelId(long fragmentEntryId) {
		setFragmentEntryId(fragmentEntryId);
	}

	@Override
	public FragmentEntry toVersionedModel() {
		FragmentEntry fragmentEntry = new FragmentEntryImpl();

		fragmentEntry.setPrimaryKey(getVersionedModelId());
		fragmentEntry.setHeadId(-getVersionedModelId());

		populateVersionedModel(fragmentEntry);

		return fragmentEntry;
	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@Override
	public long getFragmentEntryVersionId() {
		return _fragmentEntryVersionId;
	}

	@Override
	public void setFragmentEntryVersionId(long fragmentEntryVersionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fragmentEntryVersionId = fragmentEntryVersionId;
	}

	@Override
	public int getVersion() {
		return _version;
	}

	@Override
	public void setVersion(int version) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_version = version;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalVersion() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("version"));
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getFragmentEntryId() {
		return _fragmentEntryId;
	}

	@Override
	public void setFragmentEntryId(long fragmentEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fragmentEntryId = fragmentEntryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalFragmentEntryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("fragmentEntryId"));
	}

	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getFragmentCollectionId() {
		return _fragmentCollectionId;
	}

	@Override
	public void setFragmentCollectionId(long fragmentCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fragmentCollectionId = fragmentCollectionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalFragmentCollectionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("fragmentCollectionId"));
	}

	@Override
	public String getFragmentEntryKey() {
		if (_fragmentEntryKey == null) {
			return "";
		}
		else {
			return _fragmentEntryKey;
		}
	}

	@Override
	public void setFragmentEntryKey(String fragmentEntryKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fragmentEntryKey = fragmentEntryKey;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalFragmentEntryKey() {
		return getColumnOriginalValue("fragmentEntryKey");
	}

	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@Override
	public String getCss() {
		if (_css == null) {
			return "";
		}
		else {
			return _css;
		}
	}

	@Override
	public void setCss(String css) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_css = css;
	}

	@Override
	public String getHtml() {
		if (_html == null) {
			return "";
		}
		else {
			return _html;
		}
	}

	@Override
	public void setHtml(String html) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_html = html;
	}

	@Override
	public String getJs() {
		if (_js == null) {
			return "";
		}
		else {
			return _js;
		}
	}

	@Override
	public void setJs(String js) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_js = js;
	}

	@Override
	public boolean getCacheable() {
		return _cacheable;
	}

	@Override
	public boolean isCacheable() {
		return _cacheable;
	}

	@Override
	public void setCacheable(boolean cacheable) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_cacheable = cacheable;
	}

	@Override
	public String getConfiguration() {
		if (_configuration == null) {
			return "";
		}
		else {
			return _configuration;
		}
	}

	@Override
	public void setConfiguration(String configuration) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_configuration = configuration;
	}

	@Override
	public String getIcon() {
		if (_icon == null) {
			return "";
		}
		else {
			return _icon;
		}
	}

	@Override
	public void setIcon(String icon) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_icon = icon;
	}

	@Override
	public long getPreviewFileEntryId() {
		return _previewFileEntryId;
	}

	@Override
	public void setPreviewFileEntryId(long previewFileEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_previewFileEntryId = previewFileEntryId;
	}

	@Override
	public boolean getReadOnly() {
		return _readOnly;
	}

	@Override
	public boolean isReadOnly() {
		return _readOnly;
	}

	@Override
	public void setReadOnly(boolean readOnly) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_readOnly = readOnly;
	}

	@Override
	public int getType() {
		return _type;
	}

	@Override
	public void setType(int type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalType() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("type_"));
	}

	@Override
	public String getTypeOptions() {
		if (_typeOptions == null) {
			return "";
		}
		else {
			return _typeOptions;
		}
	}

	@Override
	public void setTypeOptions(String typeOptions) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_typeOptions = typeOptions;
	}

	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), FragmentEntryVersion.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public FragmentEntryVersion toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, FragmentEntryVersion>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		FragmentEntryVersionImpl fragmentEntryVersionImpl =
			new FragmentEntryVersionImpl();

		fragmentEntryVersionImpl.setMvccVersion(getMvccVersion());
		fragmentEntryVersionImpl.setCtCollectionId(getCtCollectionId());
		fragmentEntryVersionImpl.setFragmentEntryVersionId(
			getFragmentEntryVersionId());
		fragmentEntryVersionImpl.setVersion(getVersion());
		fragmentEntryVersionImpl.setUuid(getUuid());
		fragmentEntryVersionImpl.setFragmentEntryId(getFragmentEntryId());
		fragmentEntryVersionImpl.setGroupId(getGroupId());
		fragmentEntryVersionImpl.setCompanyId(getCompanyId());
		fragmentEntryVersionImpl.setUserId(getUserId());
		fragmentEntryVersionImpl.setUserName(getUserName());
		fragmentEntryVersionImpl.setCreateDate(getCreateDate());
		fragmentEntryVersionImpl.setModifiedDate(getModifiedDate());
		fragmentEntryVersionImpl.setFragmentCollectionId(
			getFragmentCollectionId());
		fragmentEntryVersionImpl.setFragmentEntryKey(getFragmentEntryKey());
		fragmentEntryVersionImpl.setName(getName());
		fragmentEntryVersionImpl.setCss(getCss());
		fragmentEntryVersionImpl.setHtml(getHtml());
		fragmentEntryVersionImpl.setJs(getJs());
		fragmentEntryVersionImpl.setCacheable(isCacheable());
		fragmentEntryVersionImpl.setConfiguration(getConfiguration());
		fragmentEntryVersionImpl.setIcon(getIcon());
		fragmentEntryVersionImpl.setPreviewFileEntryId(getPreviewFileEntryId());
		fragmentEntryVersionImpl.setReadOnly(isReadOnly());
		fragmentEntryVersionImpl.setType(getType());
		fragmentEntryVersionImpl.setTypeOptions(getTypeOptions());
		fragmentEntryVersionImpl.setLastPublishDate(getLastPublishDate());
		fragmentEntryVersionImpl.setStatus(getStatus());
		fragmentEntryVersionImpl.setStatusByUserId(getStatusByUserId());
		fragmentEntryVersionImpl.setStatusByUserName(getStatusByUserName());
		fragmentEntryVersionImpl.setStatusDate(getStatusDate());

		fragmentEntryVersionImpl.resetOriginalValues();

		return fragmentEntryVersionImpl;
	}

	@Override
	public FragmentEntryVersion cloneWithOriginalValues() {
		FragmentEntryVersionImpl fragmentEntryVersionImpl =
			new FragmentEntryVersionImpl();

		fragmentEntryVersionImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		fragmentEntryVersionImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		fragmentEntryVersionImpl.setFragmentEntryVersionId(
			this.<Long>getColumnOriginalValue("fragmentEntryVersionId"));
		fragmentEntryVersionImpl.setVersion(
			this.<Integer>getColumnOriginalValue("version"));
		fragmentEntryVersionImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		fragmentEntryVersionImpl.setFragmentEntryId(
			this.<Long>getColumnOriginalValue("fragmentEntryId"));
		fragmentEntryVersionImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		fragmentEntryVersionImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		fragmentEntryVersionImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		fragmentEntryVersionImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		fragmentEntryVersionImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		fragmentEntryVersionImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		fragmentEntryVersionImpl.setFragmentCollectionId(
			this.<Long>getColumnOriginalValue("fragmentCollectionId"));
		fragmentEntryVersionImpl.setFragmentEntryKey(
			this.<String>getColumnOriginalValue("fragmentEntryKey"));
		fragmentEntryVersionImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		fragmentEntryVersionImpl.setCss(
			this.<String>getColumnOriginalValue("css"));
		fragmentEntryVersionImpl.setHtml(
			this.<String>getColumnOriginalValue("html"));
		fragmentEntryVersionImpl.setJs(
			this.<String>getColumnOriginalValue("js"));
		fragmentEntryVersionImpl.setCacheable(
			this.<Boolean>getColumnOriginalValue("cacheable"));
		fragmentEntryVersionImpl.setConfiguration(
			this.<String>getColumnOriginalValue("configuration"));
		fragmentEntryVersionImpl.setIcon(
			this.<String>getColumnOriginalValue("icon"));
		fragmentEntryVersionImpl.setPreviewFileEntryId(
			this.<Long>getColumnOriginalValue("previewFileEntryId"));
		fragmentEntryVersionImpl.setReadOnly(
			this.<Boolean>getColumnOriginalValue("readOnly"));
		fragmentEntryVersionImpl.setType(
			this.<Integer>getColumnOriginalValue("type_"));
		fragmentEntryVersionImpl.setTypeOptions(
			this.<String>getColumnOriginalValue("typeOptions"));
		fragmentEntryVersionImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));
		fragmentEntryVersionImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));
		fragmentEntryVersionImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		fragmentEntryVersionImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		fragmentEntryVersionImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return fragmentEntryVersionImpl;
	}

	@Override
	public int compareTo(FragmentEntryVersion fragmentEntryVersion) {
		int value = 0;

		if (getVersion() < fragmentEntryVersion.getVersion()) {
			value = -1;
		}
		else if (getVersion() > fragmentEntryVersion.getVersion()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof FragmentEntryVersion)) {
			return false;
		}

		FragmentEntryVersion fragmentEntryVersion =
			(FragmentEntryVersion)object;

		long primaryKey = fragmentEntryVersion.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<FragmentEntryVersion> toCacheModel() {
		FragmentEntryVersionCacheModel fragmentEntryVersionCacheModel =
			new FragmentEntryVersionCacheModel();

		fragmentEntryVersionCacheModel.mvccVersion = getMvccVersion();

		fragmentEntryVersionCacheModel.ctCollectionId = getCtCollectionId();

		fragmentEntryVersionCacheModel.fragmentEntryVersionId =
			getFragmentEntryVersionId();

		fragmentEntryVersionCacheModel.version = getVersion();

		fragmentEntryVersionCacheModel.uuid = getUuid();

		String uuid = fragmentEntryVersionCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			fragmentEntryVersionCacheModel.uuid = null;
		}

		fragmentEntryVersionCacheModel.fragmentEntryId = getFragmentEntryId();

		fragmentEntryVersionCacheModel.groupId = getGroupId();

		fragmentEntryVersionCacheModel.companyId = getCompanyId();

		fragmentEntryVersionCacheModel.userId = getUserId();

		fragmentEntryVersionCacheModel.userName = getUserName();

		String userName = fragmentEntryVersionCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			fragmentEntryVersionCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			fragmentEntryVersionCacheModel.createDate = createDate.getTime();
		}
		else {
			fragmentEntryVersionCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			fragmentEntryVersionCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			fragmentEntryVersionCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		fragmentEntryVersionCacheModel.fragmentCollectionId =
			getFragmentCollectionId();

		fragmentEntryVersionCacheModel.fragmentEntryKey = getFragmentEntryKey();

		String fragmentEntryKey =
			fragmentEntryVersionCacheModel.fragmentEntryKey;

		if ((fragmentEntryKey != null) && (fragmentEntryKey.length() == 0)) {
			fragmentEntryVersionCacheModel.fragmentEntryKey = null;
		}

		fragmentEntryVersionCacheModel.name = getName();

		String name = fragmentEntryVersionCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			fragmentEntryVersionCacheModel.name = null;
		}

		fragmentEntryVersionCacheModel.css = getCss();

		String css = fragmentEntryVersionCacheModel.css;

		if ((css != null) && (css.length() == 0)) {
			fragmentEntryVersionCacheModel.css = null;
		}

		fragmentEntryVersionCacheModel.html = getHtml();

		String html = fragmentEntryVersionCacheModel.html;

		if ((html != null) && (html.length() == 0)) {
			fragmentEntryVersionCacheModel.html = null;
		}

		fragmentEntryVersionCacheModel.js = getJs();

		String js = fragmentEntryVersionCacheModel.js;

		if ((js != null) && (js.length() == 0)) {
			fragmentEntryVersionCacheModel.js = null;
		}

		fragmentEntryVersionCacheModel.cacheable = isCacheable();

		fragmentEntryVersionCacheModel.configuration = getConfiguration();

		String configuration = fragmentEntryVersionCacheModel.configuration;

		if ((configuration != null) && (configuration.length() == 0)) {
			fragmentEntryVersionCacheModel.configuration = null;
		}

		fragmentEntryVersionCacheModel.icon = getIcon();

		String icon = fragmentEntryVersionCacheModel.icon;

		if ((icon != null) && (icon.length() == 0)) {
			fragmentEntryVersionCacheModel.icon = null;
		}

		fragmentEntryVersionCacheModel.previewFileEntryId =
			getPreviewFileEntryId();

		fragmentEntryVersionCacheModel.readOnly = isReadOnly();

		fragmentEntryVersionCacheModel.type = getType();

		fragmentEntryVersionCacheModel.typeOptions = getTypeOptions();

		String typeOptions = fragmentEntryVersionCacheModel.typeOptions;

		if ((typeOptions != null) && (typeOptions.length() == 0)) {
			fragmentEntryVersionCacheModel.typeOptions = null;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			fragmentEntryVersionCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			fragmentEntryVersionCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		fragmentEntryVersionCacheModel.status = getStatus();

		fragmentEntryVersionCacheModel.statusByUserId = getStatusByUserId();

		fragmentEntryVersionCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName =
			fragmentEntryVersionCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			fragmentEntryVersionCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			fragmentEntryVersionCacheModel.statusDate = statusDate.getTime();
		}
		else {
			fragmentEntryVersionCacheModel.statusDate = Long.MIN_VALUE;
		}

		return fragmentEntryVersionCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<FragmentEntryVersion, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<FragmentEntryVersion, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<FragmentEntryVersion, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(FragmentEntryVersion)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<FragmentEntryVersion, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<FragmentEntryVersion, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<FragmentEntryVersion, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply((FragmentEntryVersion)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, FragmentEntryVersion>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					FragmentEntryVersion.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private long _fragmentEntryVersionId;
	private int _version;
	private String _uuid;
	private long _fragmentEntryId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _fragmentCollectionId;
	private String _fragmentEntryKey;
	private String _name;
	private String _css;
	private String _html;
	private String _js;
	private boolean _cacheable;
	private String _configuration;
	private String _icon;
	private long _previewFileEntryId;
	private boolean _readOnly;
	private int _type;
	private String _typeOptions;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<FragmentEntryVersion, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((FragmentEntryVersion)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put(
			"fragmentEntryVersionId", _fragmentEntryVersionId);
		_columnOriginalValues.put("version", _version);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("fragmentEntryId", _fragmentEntryId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"fragmentCollectionId", _fragmentCollectionId);
		_columnOriginalValues.put("fragmentEntryKey", _fragmentEntryKey);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("css", _css);
		_columnOriginalValues.put("html", _html);
		_columnOriginalValues.put("js", _js);
		_columnOriginalValues.put("cacheable", _cacheable);
		_columnOriginalValues.put("configuration", _configuration);
		_columnOriginalValues.put("icon", _icon);
		_columnOriginalValues.put("previewFileEntryId", _previewFileEntryId);
		_columnOriginalValues.put("readOnly", _readOnly);
		_columnOriginalValues.put("type_", _type);
		_columnOriginalValues.put("typeOptions", _typeOptions);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("fragmentEntryVersionId", 4L);

		columnBitmasks.put("version", 8L);

		columnBitmasks.put("uuid_", 16L);

		columnBitmasks.put("fragmentEntryId", 32L);

		columnBitmasks.put("groupId", 64L);

		columnBitmasks.put("companyId", 128L);

		columnBitmasks.put("userId", 256L);

		columnBitmasks.put("userName", 512L);

		columnBitmasks.put("createDate", 1024L);

		columnBitmasks.put("modifiedDate", 2048L);

		columnBitmasks.put("fragmentCollectionId", 4096L);

		columnBitmasks.put("fragmentEntryKey", 8192L);

		columnBitmasks.put("name", 16384L);

		columnBitmasks.put("css", 32768L);

		columnBitmasks.put("html", 65536L);

		columnBitmasks.put("js", 131072L);

		columnBitmasks.put("cacheable", 262144L);

		columnBitmasks.put("configuration", 524288L);

		columnBitmasks.put("icon", 1048576L);

		columnBitmasks.put("previewFileEntryId", 2097152L);

		columnBitmasks.put("readOnly", 4194304L);

		columnBitmasks.put("type_", 8388608L);

		columnBitmasks.put("typeOptions", 16777216L);

		columnBitmasks.put("lastPublishDate", 33554432L);

		columnBitmasks.put("status", 67108864L);

		columnBitmasks.put("statusByUserId", 134217728L);

		columnBitmasks.put("statusByUserName", 268435456L);

		columnBitmasks.put("statusDate", 536870912L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private FragmentEntryVersion _escapedModel;

}