/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.exportimport.content.processor;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.fragment.internal.exportimport.content.processor.BaseEditableValuesConfigurationExportImportContentProcessor;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"content.processor.type=FragmentEntryLinkEditableValues"}, service={ExportImportContentProcessor.class})
public class EditableValuesCategoryTreeNodeSelectorExportImportContentProcessor
extends BaseEditableValuesConfigurationExportImportContentProcessor {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;

    @Override
    protected String getConfigurationType() {
        return "categoryTreeNodeSelector";
    }

    @Override
    protected FragmentEntryConfigurationParser getFragmentEntryConfigurationParser() {
        return this._fragmentEntryConfigurationParser;
    }

    @Override
    protected void replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel referrerStagedModel, JSONObject configurationValueJSONObject, boolean exportReferencedContent) throws Exception {
        long assetCategoryTreeNodeId = GetterUtil.getLong((String)configurationValueJSONObject.getString("categoryTreeNodeId"));
        if (assetCategoryTreeNodeId == 0L) {
            return;
        }
        AssetVocabulary stagedModel = null;
        String assetCategoryTreeNodeType = configurationValueJSONObject.getString("categoryTreeNodeType");
        if (assetCategoryTreeNodeType.equals("Vocabulary")) {
            stagedModel = this._assetVocabularyLocalService.fetchAssetVocabulary(assetCategoryTreeNodeId);
        } else if (assetCategoryTreeNodeType.equals("Category")) {
            stagedModel = this._assetCategoryLocalService.fetchAssetCategory(assetCategoryTreeNodeId);
        }
        if (stagedModel == null) {
            return;
        }
        if (exportReferencedContent) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)referrerStagedModel, (StagedModel)stagedModel, (String)"dependency");
        } else {
            Element entityElement = portletDataContext.getExportDataElement((ClassedModel)referrerStagedModel);
            portletDataContext.addReferenceElement((ClassedModel)referrerStagedModel, entityElement, (ClassedModel)stagedModel, "dependency", true);
        }
    }

    @Override
    protected void replaceImportContentReferences(PortletDataContext portletDataContext, JSONObject configurationValueJSONObject) {
        long assetCategoryTreeNodeId = GetterUtil.getLong((String)configurationValueJSONObject.getString("categoryTreeNodeId"));
        if (assetCategoryTreeNodeId == 0L) {
            return;
        }
        String assetCategoryTreeNodeType = configurationValueJSONObject.getString("categoryTreeNodeType");
        if (assetCategoryTreeNodeType.equals("Vocabulary")) {
            Map assetVocabularyNewPrimaryKeys = portletDataContext.getNewPrimaryKeysMap(AssetVocabulary.class.getName());
            configurationValueJSONObject.put("categoryTreeNodeId", (Object)assetVocabularyNewPrimaryKeys.getOrDefault(assetCategoryTreeNodeId, 0L));
        } else if (assetCategoryTreeNodeType.equals("Category")) {
            Map assetVocabularyNewPrimaryKeys = portletDataContext.getNewPrimaryKeysMap(AssetCategory.class.getName());
            configurationValueJSONObject.put("categoryTreeNodeId", (Object)assetVocabularyNewPrimaryKeys.getOrDefault(assetCategoryTreeNodeId, 0L));
        }
    }
}

