/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.exportimport.data.handler;

import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import java.io.InputStream;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class FragmentCollectionStagedModelDataHandler
extends BaseStagedModelDataHandler<FragmentCollection> {
    public static final String[] CLASS_NAMES = new String[]{FragmentCollection.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(FragmentCollectionStagedModelDataHandler.class);
    @Reference(target="(model.class.name=com.liferay.fragment.model.FragmentCollection)", unbind="-")
    private StagedModelRepository<FragmentCollection> _stagedModelRepository;

    public void deleteStagedModel(FragmentCollection fragmentCollection) throws PortalException {
        this._stagedModelRepository.deleteStagedModel((StagedModel)fragmentCollection);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        this._stagedModelRepository.deleteStagedModel(uuid, groupId, className, extraData);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(FragmentCollection fragmentCollection) {
        return fragmentCollection.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, FragmentCollection fragmentCollection) throws Exception {
        Element fragmentCollectionElement = portletDataContext.getExportDataElement((ClassedModel)fragmentCollection);
        portletDataContext.addClassedModel(fragmentCollectionElement, ExportImportPathUtil.getModelPath((StagedModel)fragmentCollection), (ClassedModel)fragmentCollection);
        for (FileEntry fileEntry : fragmentCollection.getResources()) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fragmentCollection, (StagedModel)fileEntry, (String)"weak");
        }
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, FragmentCollection fragmentCollection) throws Exception {
        FragmentCollection importedFragmentCollection = (FragmentCollection)fragmentCollection.clone();
        importedFragmentCollection.setGroupId(portletDataContext.getScopeGroupId());
        FragmentCollection existingFragmentCollection = (FragmentCollection)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(fragmentCollection.getUuid(), portletDataContext.getScopeGroupId());
        if (existingFragmentCollection == null || !portletDataContext.isDataStrategyMirror()) {
            importedFragmentCollection = (FragmentCollection)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedFragmentCollection);
        } else {
            importedFragmentCollection.setMvccVersion(existingFragmentCollection.getMvccVersion());
            importedFragmentCollection.setFragmentCollectionId(existingFragmentCollection.getFragmentCollectionId());
            importedFragmentCollection = (FragmentCollection)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)importedFragmentCollection);
        }
        if (existingFragmentCollection != null) {
            for (FileEntry fileEntry : existingFragmentCollection.getResources()) {
                PortletFileRepositoryUtil.deletePortletFileEntry((long)fileEntry.getFileEntryId());
            }
        }
        long userId = portletDataContext.getUserId(fragmentCollection.getUserUuid());
        List resourceElements = portletDataContext.getReferenceDataElements((StagedModel)fragmentCollection, DLFileEntry.class, "weak");
        for (Element resourceElement : resourceElements) {
            String path = resourceElement.attributeValue("path");
            FileEntry fileEntry = (FileEntry)portletDataContext.getZipEntryAsObject(path);
            String binPath = resourceElement.attributeValue("bin-path");
            InputStream inputStream = this._getResourceInputStream(binPath, portletDataContext, fileEntry);
            Throwable throwable = null;
            try {
                if (inputStream == null) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to import resource for file entry " + fileEntry.getFileEntryId()));
                    continue;
                }
                PortletFileRepositoryUtil.addPortletFileEntry((long)importedFragmentCollection.getGroupId(), (long)userId, (String)FragmentCollection.class.getName(), (long)importedFragmentCollection.getFragmentCollectionId(), (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (long)importedFragmentCollection.getResourcesFolderId(), (InputStream)inputStream, (String)fileEntry.getFileName(), (String)fileEntry.getMimeType(), (boolean)false);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        portletDataContext.importClassedModel((ClassedModel)fragmentCollection, (ClassedModel)importedFragmentCollection);
    }

    protected StagedModelRepository<FragmentCollection> getStagedModelRepository() {
        return this._stagedModelRepository;
    }

    private InputStream _getResourceInputStream(String binPath, PortletDataContext portletDataContext, FileEntry fileEntry) throws Exception {
        if (Validator.isNull((String)binPath) && portletDataContext.isPerformDirectBinaryImport()) {
            try {
                return FileEntryUtil.getContentStream((FileEntry)fileEntry);
            }
            catch (NoSuchFileException noSuchFileException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)noSuchFileException);
                }
                return null;
            }
        }
        return portletDataContext.getZipEntryAsInputStream(binPath);
    }
}

