/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.exportimport.data.handler;

import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.service.FragmentCollectionLocalService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import java.io.Serializable;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class FragmentEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<FragmentEntry> {
    public static final String[] CLASS_NAMES = new String[]{FragmentEntry.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryStagedModelDataHandler.class);
    @Reference(target="(content.processor.type=DLReferences)")
    private ExportImportContentProcessor<String> _dlReferencesExportImportContentProcessor;
    @Reference
    private FragmentCollectionLocalService _fragmentCollectionLocalService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference(target="(model.class.name=com.liferay.fragment.model.FragmentEntry)", unbind="-")
    private StagedModelRepository<FragmentEntry> _stagedModelRepository;

    public void deleteStagedModel(FragmentEntry fragmentEntry) throws PortalException {
        this._stagedModelRepository.deleteStagedModel((StagedModel)fragmentEntry);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        this._stagedModelRepository.deleteStagedModel(uuid, groupId, className, extraData);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(FragmentEntry fragmentEntry) {
        return fragmentEntry.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, FragmentEntry fragmentEntry) throws Exception {
        FragmentCollection fragmentCollection = this._fragmentCollectionLocalService.fetchFragmentCollection(fragmentEntry.getFragmentCollectionId());
        if (fragmentCollection == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to export fragment entry with key " + fragmentEntry.getFragmentEntryKey()));
            }
            return;
        }
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fragmentEntry, (StagedModel)fragmentCollection, (String)"parent");
        if (fragmentEntry.getPreviewFileEntryId() > 0L) {
            FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)fragmentEntry.getPreviewFileEntryId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fragmentEntry, (StagedModel)fileEntry, (String)"weak");
        }
        String html = (String)((Object)this._dlReferencesExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)fragmentEntry, (Serializable)((Object)fragmentEntry.getHtml()), true, false));
        fragmentEntry.setHtml(html);
        Element entryElement = portletDataContext.getExportDataElement((ClassedModel)fragmentEntry);
        portletDataContext.addClassedModel(entryElement, ExportImportPathUtil.getModelPath((StagedModel)fragmentEntry), (ClassedModel)fragmentEntry);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long fragmentEntryId) throws Exception {
        FragmentEntry existingFragmentEntry = (FragmentEntry)this.fetchMissingReference(uuid, groupId);
        if (existingFragmentEntry == null) {
            return;
        }
        Map fragmentEntryIds = portletDataContext.getNewPrimaryKeysMap(FragmentEntry.class);
        fragmentEntryIds.put(fragmentEntryId, existingFragmentEntry.getFragmentEntryId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, FragmentEntry fragmentEntry) throws Exception {
        Map fragmentCollectionIds = portletDataContext.getNewPrimaryKeysMap(FragmentCollection.class);
        long fragmentCollectionId = MapUtil.getLong((Map)fragmentCollectionIds, (long)fragmentEntry.getFragmentCollectionId(), (long)fragmentEntry.getFragmentCollectionId());
        FragmentEntry importedFragmentEntry = (FragmentEntry)fragmentEntry.clone();
        importedFragmentEntry.setGroupId(portletDataContext.getScopeGroupId());
        importedFragmentEntry.setFragmentCollectionId(fragmentCollectionId);
        importedFragmentEntry.setHtml((String)((Object)this._dlReferencesExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)fragmentEntry, (Serializable)((Object)fragmentEntry.getHtml()))));
        FragmentEntry existingFragmentEntry = (FragmentEntry)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(fragmentEntry.getUuid(), portletDataContext.getScopeGroupId());
        if (existingFragmentEntry == null || !portletDataContext.isDataStrategyMirror()) {
            importedFragmentEntry = (FragmentEntry)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedFragmentEntry);
        } else {
            importedFragmentEntry.setMvccVersion(existingFragmentEntry.getMvccVersion());
            importedFragmentEntry.setFragmentEntryId(existingFragmentEntry.getFragmentEntryId());
            importedFragmentEntry = (FragmentEntry)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)importedFragmentEntry);
        }
        if (fragmentEntry.getPreviewFileEntryId() == 0L && importedFragmentEntry.getPreviewFileEntryId() > 0L) {
            PortletFileRepositoryUtil.deletePortletFileEntry((long)importedFragmentEntry.getPreviewFileEntryId());
            importedFragmentEntry = this._fragmentEntryLocalService.updateFragmentEntry(importedFragmentEntry.getFragmentEntryId(), 0L);
        } else if (fragmentEntry.getPreviewFileEntryId() > 0L) {
            Map fileEntryIds = portletDataContext.getNewPrimaryKeysMap(FileEntry.class);
            long previewFileEntryId = MapUtil.getLong((Map)fileEntryIds, (long)fragmentEntry.getPreviewFileEntryId(), (long)0L);
            importedFragmentEntry = this._fragmentEntryLocalService.updateFragmentEntry(importedFragmentEntry.getFragmentEntryId(), previewFileEntryId);
        }
        portletDataContext.importClassedModel((ClassedModel)fragmentEntry, (ClassedModel)importedFragmentEntry);
    }

    protected StagedModelRepository<FragmentEntry> getStagedModelRepository() {
        return this._stagedModelRepository;
    }
}

