/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.service.impl;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.fragment.configuration.FragmentServiceConfiguration;
import com.liferay.fragment.exception.DuplicateFragmentEntryKeyException;
import com.liferay.fragment.exception.FragmentEntryNameException;
import com.liferay.fragment.exception.NoSuchEntryException;
import com.liferay.fragment.exception.RequiredFragmentEntryException;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.service.base.FragmentEntryLocalServiceBaseImpl;
import com.liferay.fragment.service.persistence.FragmentCollectionPersistence;
import com.liferay.fragment.service.persistence.FragmentEntryLinkPersistence;
import com.liferay.fragment.validator.FragmentEntryValidator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.fragment.model.FragmentEntry"}, service={AopService.class})
public class FragmentEntryLocalServiceImpl
extends FragmentEntryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryLocalServiceImpl.class);
    private static final Pattern _pattern = Pattern.compile("\\[resources:(.+?)\\]");
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private FragmentCollectionPersistence _fragmentCollectionPersistence;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FragmentEntryLinkPersistence _fragmentEntryLinkPersistence;
    @Reference
    private FragmentEntryProcessorRegistry _fragmentEntryProcessorRegistry;
    @Reference
    private FragmentEntryValidator _fragmentEntryValidator;
    @Reference
    private Language _language;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public FragmentEntry addFragmentEntry(long userId, long groupId, long fragmentCollectionId, String fragmentEntryKey, String name, String css, String html, String js, boolean cacheable, String configuration, String icon, long previewFileEntryId, int type, String typeOptions, int status, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long companyId = user.getCompanyId();
        if (serviceContext != null) {
            companyId = serviceContext.getCompanyId();
        } else {
            serviceContext = new ServiceContext();
        }
        if (Validator.isNull((String)fragmentEntryKey)) {
            fragmentEntryKey = this.generateFragmentEntryKey(groupId, name);
        }
        fragmentEntryKey = this._getFragmentEntryKey(fragmentEntryKey);
        this.validate(name);
        this.validateFragmentEntryKey(groupId, fragmentEntryKey);
        if (0 == status) {
            this._fragmentEntryValidator.validateConfiguration(configuration);
            this._fragmentEntryValidator.validateTypeOptions(type, typeOptions);
            this.validateContent(html, configuration);
        }
        FragmentEntry draftFragmentEntry = this.create();
        draftFragmentEntry.setUuid(serviceContext.getUuid());
        draftFragmentEntry.setGroupId(groupId);
        draftFragmentEntry.setCompanyId(companyId);
        draftFragmentEntry.setUserId(user.getUserId());
        draftFragmentEntry.setUserName(user.getFullName());
        draftFragmentEntry.setCreateDate(serviceContext.getCreateDate(new Date()));
        draftFragmentEntry.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        draftFragmentEntry.setFragmentCollectionId(fragmentCollectionId);
        draftFragmentEntry.setFragmentEntryKey(fragmentEntryKey);
        draftFragmentEntry.setName(name);
        draftFragmentEntry.setCss(css);
        draftFragmentEntry.setHtml(html);
        draftFragmentEntry.setJs(js);
        draftFragmentEntry.setCacheable(cacheable);
        draftFragmentEntry.setConfiguration(configuration);
        draftFragmentEntry.setIcon(icon);
        draftFragmentEntry.setPreviewFileEntryId(previewFileEntryId);
        draftFragmentEntry.setType(type);
        draftFragmentEntry.setTypeOptions(typeOptions);
        draftFragmentEntry.setStatus(2);
        draftFragmentEntry.setStatusByUserId(userId);
        draftFragmentEntry.setStatusByUserName(user.getFullName());
        draftFragmentEntry.setStatusDate(new Date());
        FragmentEntry updatedDraftFragmentEntry = this.updateDraft(draftFragmentEntry);
        if (0 == status) {
            return this.publishDraft(updatedDraftFragmentEntry);
        }
        return updatedDraftFragmentEntry;
    }

    public FragmentEntry copyFragmentEntry(long userId, long groupId, long fragmentEntryId, long fragmentCollectionId, ServiceContext serviceContext) throws PortalException {
        FragmentEntry fragmentEntry = this.getFragmentEntry(fragmentEntryId);
        FragmentEntry draftFragmentEntry = null;
        FragmentEntry publishedFragmentEntry = null;
        if (fragmentEntry.isDraft()) {
            draftFragmentEntry = fragmentEntry;
            if (draftFragmentEntry.getFragmentEntryId() != draftFragmentEntry.getHeadId()) {
                publishedFragmentEntry = this.fetchFragmentEntry(draftFragmentEntry.getHeadId());
            }
        } else {
            publishedFragmentEntry = fragmentEntry;
            draftFragmentEntry = publishedFragmentEntry.fetchDraftFragmentEntry();
        }
        String name = StringBundler.concat((String[])new String[]{fragmentEntry.getName(), " ", "(", this._language.get(LocaleUtil.getMostRelevantLocale(), "copy"), ")"});
        FragmentEntry copyPublishedFragmentEntry = null;
        long originalFragmentCollectionId = fragmentEntry.getFragmentCollectionId();
        if (publishedFragmentEntry != null) {
            copyPublishedFragmentEntry = this.addFragmentEntry(userId, groupId, fragmentCollectionId, null, name, publishedFragmentEntry.getCss(), publishedFragmentEntry.getHtml(), publishedFragmentEntry.getJs(), publishedFragmentEntry.isCacheable(), publishedFragmentEntry.getConfiguration(), publishedFragmentEntry.getIcon(), 0L, publishedFragmentEntry.getType(), publishedFragmentEntry.getTypeOptions(), 0, serviceContext);
            this._copyFragmentEntryPreviewFileEntry(userId, groupId, publishedFragmentEntry, copyPublishedFragmentEntry);
            this._copyFragmentEntryResources(publishedFragmentEntry, originalFragmentCollectionId, fragmentCollectionId);
        }
        FragmentEntry copyDraftFragmentEntry = null;
        if (draftFragmentEntry != null && copyPublishedFragmentEntry == null) {
            copyDraftFragmentEntry = this.addFragmentEntry(userId, groupId, fragmentCollectionId, null, name, draftFragmentEntry.getCss(), draftFragmentEntry.getHtml(), draftFragmentEntry.getJs(), draftFragmentEntry.isCacheable(), draftFragmentEntry.getConfiguration(), draftFragmentEntry.getIcon(), 0L, draftFragmentEntry.getType(), draftFragmentEntry.getTypeOptions(), 2, serviceContext);
            this._copyFragmentEntryPreviewFileEntry(userId, groupId, draftFragmentEntry, copyDraftFragmentEntry);
            this._copyFragmentEntryResources(draftFragmentEntry, originalFragmentCollectionId, fragmentCollectionId);
        }
        if (draftFragmentEntry != null && copyPublishedFragmentEntry != null) {
            copyDraftFragmentEntry = this.getDraft(copyPublishedFragmentEntry);
            copyDraftFragmentEntry.setCss(draftFragmentEntry.getCss());
            copyDraftFragmentEntry.setHtml(draftFragmentEntry.getHtml());
            copyDraftFragmentEntry.setJs(draftFragmentEntry.getJs());
            copyDraftFragmentEntry.setCacheable(draftFragmentEntry.isCacheable());
            copyDraftFragmentEntry.setConfiguration(draftFragmentEntry.getConfiguration());
            copyDraftFragmentEntry.setIcon(draftFragmentEntry.getIcon());
            copyDraftFragmentEntry.setTypeOptions(draftFragmentEntry.getTypeOptions());
            this.updateDraft(copyDraftFragmentEntry);
        }
        if (copyPublishedFragmentEntry != null) {
            return copyPublishedFragmentEntry;
        }
        return copyDraftFragmentEntry;
    }

    public FragmentEntry createFragmentEntry(long fragmentEntryId) {
        FragmentEntry draftFragmentEntry = this.fragmentEntryPersistence.create(fragmentEntryId);
        draftFragmentEntry.setHeadId(fragmentEntryId);
        return draftFragmentEntry;
    }

    @Override
    @SystemEvent(type=1)
    public FragmentEntry deleteFragmentEntry(FragmentEntry fragmentEntry) throws PortalException {
        long fragmentEntryLinkCount = this._fragmentEntryLinkPersistence.countByFragmentEntryId(fragmentEntry.getFragmentEntryId());
        if (fragmentEntryLinkCount > 0L) {
            throw new RequiredFragmentEntryException();
        }
        this._resourceLocalService.deleteResource(fragmentEntry.getCompanyId(), FragmentEntry.class.getName(), 4, fragmentEntry.getFragmentEntryId());
        if (fragmentEntry.getPreviewFileEntryId() > 0L) {
            FragmentEntry publishedFragmentEntry;
            boolean deletePreviewFileEntry = true;
            if (fragmentEntry.isDraft() && fragmentEntry.getHeadId() != fragmentEntry.getFragmentEntryId() && (publishedFragmentEntry = this.fetchFragmentEntry(fragmentEntry.getHeadId())) != null && fragmentEntry.getPreviewFileEntryId() == publishedFragmentEntry.getPreviewFileEntryId()) {
                deletePreviewFileEntry = false;
            }
            if (deletePreviewFileEntry) {
                PortletFileRepositoryUtil.deletePortletFileEntry((long)fragmentEntry.getPreviewFileEntryId());
            }
        }
        if (fragmentEntry.isDraft()) {
            return this.deleteDraft(fragmentEntry);
        }
        return this.delete(fragmentEntry);
    }

    @Override
    public FragmentEntry deleteFragmentEntry(long fragmentEntryId) throws PortalException {
        return this.fragmentEntryLocalService.deleteFragmentEntry(this.getFragmentEntry(fragmentEntryId));
    }

    @Override
    public FragmentEntry fetchFragmentEntry(long fragmentEntryId) {
        return this.fragmentEntryPersistence.fetchByPrimaryKey(fragmentEntryId);
    }

    public FragmentEntry fetchFragmentEntry(long groupId, String fragmentEntryKey) {
        FragmentEntry fragmentEntry = this.fragmentEntryPersistence.fetchByG_FEK_First(groupId, this._getFragmentEntryKey(fragmentEntryKey), null);
        if (fragmentEntry == null) {
            return null;
        }
        if (!fragmentEntry.isDraft()) {
            return fragmentEntry;
        }
        return this.fetchFragmentEntryByUuidAndGroupId(fragmentEntry.getUuid(), groupId);
    }

    public FragmentEntry fetchFragmentEntryByUuidAndGroupId(String uuid, long groupId) {
        FragmentEntry fragmentEntry = this.fragmentEntryPersistence.fetchByUUID_G_Head(uuid, groupId, true);
        if (fragmentEntry != null) {
            return fragmentEntry;
        }
        return this.fragmentEntryPersistence.fetchByUUID_G_Head(uuid, groupId, false);
    }

    public String generateFragmentEntryKey(long groupId, String name) {
        String fragmentEntryKey = this._getFragmentEntryKey(name);
        String curFragmentEntryKey = fragmentEntryKey = StringUtil.replace((String)fragmentEntryKey, (char)' ', (char)'-');
        int count = 0;
        FragmentEntry fragmentEntry;
        while ((fragmentEntry = this.fetchFragmentEntry(groupId, curFragmentEntryKey)) != null) {
            curFragmentEntryKey = fragmentEntryKey + '-' + count++;
        }
        return curFragmentEntryKey;
    }

    public List<FragmentEntry> getFragmentEntries(long fragmentCollectionId) {
        return this.fragmentEntryPersistence.findByFragmentCollectionId(fragmentCollectionId);
    }

    public List<FragmentEntry> getFragmentEntries(long fragmentCollectionId, int start, int end) {
        return this.fragmentEntryPersistence.findByFragmentCollectionId(fragmentCollectionId, start, end);
    }

    public List<FragmentEntry> getFragmentEntries(long groupId, long fragmentCollectionId, int status) {
        return this.fragmentEntryPersistence.findByG_FCI_S(groupId, fragmentCollectionId, status);
    }

    public List<FragmentEntry> getFragmentEntries(long groupId, long fragmentCollectionId, int start, int end, OrderByComparator<FragmentEntry> orderByComparator) {
        return this.fragmentEntryPersistence.findByG_FCI(groupId, fragmentCollectionId, start, end, orderByComparator);
    }

    public List<FragmentEntry> getFragmentEntries(long groupId, long fragmentCollectionId, String name, int start, int end, OrderByComparator<FragmentEntry> orderByComparator) {
        if (Validator.isNull((String)name)) {
            return this.fragmentEntryPersistence.findByG_FCI(groupId, fragmentCollectionId, start, end, orderByComparator);
        }
        return this.fragmentEntryPersistence.findByG_FCI_LikeN(groupId, fragmentCollectionId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], start, end, orderByComparator);
    }

    public List<FragmentEntry> getFragmentEntriesByUuidAndCompanyId(String uuid, long companyId) {
        return this.fragmentEntryPersistence.findByUuid_C(uuid, companyId);
    }

    public List<FragmentEntry> getFragmentEntriesByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<FragmentEntry> orderByComparator) {
        return this.fragmentEntryPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public int getFragmentEntriesCount(long fragmentCollectionId) {
        return this.fragmentEntryPersistence.countByFragmentCollectionId(fragmentCollectionId);
    }

    public FragmentEntry getFragmentEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        FragmentEntry fragmentEntry = this.fetchFragmentEntryByUuidAndGroupId(uuid, groupId);
        if (fragmentEntry == null) {
            throw new NoSuchEntryException();
        }
        return fragmentEntry;
    }

    public String[] getTempFileNames(long userId, long groupId, String folderName) throws PortalException {
        return TempFileEntryUtil.getTempFileNames((long)groupId, (long)userId, (String)folderName);
    }

    public FragmentEntry moveFragmentEntry(long fragmentEntryId, long fragmentCollectionId) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryPersistence.findByPrimaryKey(fragmentEntryId);
        if (fragmentEntry.getFragmentCollectionId() == fragmentCollectionId) {
            return fragmentEntry;
        }
        long originalFragmentCollectionId = fragmentEntry.getFragmentCollectionId();
        fragmentEntry.setFragmentCollectionId(fragmentCollectionId);
        this._copyFragmentEntryResources(fragmentEntry, originalFragmentCollectionId, fragmentCollectionId);
        return (FragmentEntry)this.fragmentEntryPersistence.update((BaseModel)fragmentEntry);
    }

    @Override
    public FragmentEntry publishDraft(FragmentEntry draftFragmentEntry) throws PortalException {
        FragmentEntry publishedFragmentEntry = this.fetchFragmentEntry(draftFragmentEntry.getHeadId());
        if (publishedFragmentEntry != null) {
            draftFragmentEntry.setName(publishedFragmentEntry.getName());
            draftFragmentEntry.setPreviewFileEntryId(publishedFragmentEntry.getPreviewFileEntryId());
        } else {
            this.validate(draftFragmentEntry.getName());
        }
        this._fragmentEntryValidator.validateConfiguration(draftFragmentEntry.getConfiguration());
        this._fragmentEntryValidator.validateTypeOptions(draftFragmentEntry.getType(), draftFragmentEntry.getTypeOptions());
        this.validateContent(draftFragmentEntry.getHtml(), draftFragmentEntry.getConfiguration());
        draftFragmentEntry.setStatus(0);
        FragmentEntry updatedPublishedFragmentEntry = super.publishDraft(draftFragmentEntry);
        FragmentServiceConfiguration fragmentServiceConfiguration = (FragmentServiceConfiguration)this._configurationProvider.getCompanyConfiguration(FragmentServiceConfiguration.class, draftFragmentEntry.getCompanyId());
        if (fragmentServiceConfiguration.propagateChanges() && !ExportImportThreadLocal.isStagingInProcess()) {
            this._propagateChanges(updatedPublishedFragmentEntry.getFragmentEntryId());
        }
        return updatedPublishedFragmentEntry;
    }

    @Override
    public FragmentEntry updateFragmentEntry(FragmentEntry fragmentEntry) throws PortalException {
        FragmentEntry draftFragmentEntry = null;
        if (fragmentEntry.isDraft()) {
            draftFragmentEntry = fragmentEntry;
        } else {
            draftFragmentEntry = this.fragmentEntryPersistence.fetchByHeadId(fragmentEntry.getFragmentEntryId());
            if (draftFragmentEntry == null) {
                draftFragmentEntry = this.getDraft(fragmentEntry);
            }
        }
        FragmentEntry updatedDraftFragmentEntry = (FragmentEntry)this.fragmentEntryPersistence.update((BaseModel)draftFragmentEntry);
        if (fragmentEntry.isDraft()) {
            return updatedDraftFragmentEntry;
        }
        return this.publishDraft(updatedDraftFragmentEntry);
    }

    public FragmentEntry updateFragmentEntry(long fragmentEntryId, long previewFileEntryId) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryPersistence.findByPrimaryKey(fragmentEntryId);
        fragmentEntry.setModifiedDate(new Date());
        fragmentEntry.setPreviewFileEntryId(previewFileEntryId);
        return (FragmentEntry)this.fragmentEntryPersistence.update((BaseModel)fragmentEntry);
    }

    public FragmentEntry updateFragmentEntry(long userId, long fragmentEntryId, long fragmentCollectionId, String name, String css, String html, String js, boolean cacheable, String configuration, String icon, long previewFileEntryId, int status) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryPersistence.findByPrimaryKey(fragmentEntryId);
        return this.fragmentEntryLocalService.updateFragmentEntry(userId, fragmentEntryId, fragmentCollectionId, name, css, html, js, cacheable, configuration, icon, previewFileEntryId, fragmentEntry.getTypeOptions(), status);
    }

    public FragmentEntry updateFragmentEntry(long userId, long fragmentEntryId, long fragmentCollectionId, String name, String css, String html, String js, boolean cacheable, String configuration, String icon, long previewFileEntryId, String typeOptions, int status) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryPersistence.findByPrimaryKey(fragmentEntryId);
        this.validate(name);
        if (0 == status) {
            this._fragmentEntryValidator.validateConfiguration(configuration);
            this._fragmentEntryValidator.validateTypeOptions(fragmentEntry.getType(), typeOptions);
            this.validateContent(html, configuration);
        }
        User user = this._userLocalService.getUser(userId);
        fragmentEntry.setModifiedDate(new Date());
        fragmentEntry.setFragmentCollectionId(fragmentCollectionId);
        fragmentEntry.setName(name);
        fragmentEntry.setCss(css);
        fragmentEntry.setHtml(html);
        fragmentEntry.setJs(js);
        fragmentEntry.setCacheable(cacheable);
        fragmentEntry.setConfiguration(configuration);
        fragmentEntry.setIcon(icon);
        fragmentEntry.setPreviewFileEntryId(previewFileEntryId);
        fragmentEntry.setTypeOptions(typeOptions);
        fragmentEntry.setStatus(status);
        fragmentEntry.setStatusByUserId(userId);
        fragmentEntry.setStatusByUserName(user.getFullName());
        fragmentEntry.setStatusDate(new Date());
        fragmentEntry = this.getDraft(fragmentEntry);
        if (status != 0) {
            return fragmentEntry;
        }
        FragmentServiceConfiguration fragmentServiceConfiguration = (FragmentServiceConfiguration)this._configurationProvider.getCompanyConfiguration(FragmentServiceConfiguration.class, (fragmentEntry = this.publishDraft(fragmentEntry)).getCompanyId());
        if (fragmentServiceConfiguration.propagateChanges() && !ExportImportThreadLocal.isStagingInProcess()) {
            this._propagateChanges(fragmentEntryId);
        }
        return fragmentEntry;
    }

    public FragmentEntry updateFragmentEntry(long fragmentEntryId, String name) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryPersistence.findByPrimaryKey(fragmentEntryId);
        if (Objects.equals(fragmentEntry.getName(), name)) {
            return fragmentEntry;
        }
        this.validate(name);
        fragmentEntry.setName(name);
        return (FragmentEntry)this.fragmentEntryPersistence.update((BaseModel)fragmentEntry);
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new FragmentEntryNameException("Name must not be null");
        }
        if (name.contains(".") || name.contains("/")) {
            throw new FragmentEntryNameException("Name contains invalid characters");
        }
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)FragmentEntry.class.getName(), (String)"name");
        if (name.length() > nameMaxLength) {
            throw new FragmentEntryNameException("Maximum length of name exceeded");
        }
    }

    protected void validateContent(String html, String configuration) throws PortalException {
        this._fragmentEntryProcessorRegistry.validateFragmentEntryHTML(html, configuration);
    }

    protected void validateFragmentEntryKey(long groupId, String fragmentEntryKey) throws PortalException {
        FragmentEntry fragmentEntry = this.fetchFragmentEntry(groupId, fragmentEntryKey = this._getFragmentEntryKey(fragmentEntryKey));
        if (fragmentEntry != null) {
            throw new DuplicateFragmentEntryKeyException();
        }
    }

    private void _copyFragmentEntryPreviewFileEntry(long userId, long groupId, FragmentEntry fragmentEntry, FragmentEntry copyFragmentEntry) throws PortalException {
        if (fragmentEntry.getPreviewFileEntryId() != 0L) {
            FileEntry fileEntry = this._dlAppLocalService.getFileEntry(fragmentEntry.getPreviewFileEntryId());
            Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet");
            if (repository == null) {
                ServiceContext addPortletRepositoryServiceContext = new ServiceContext();
                addPortletRepositoryServiceContext.setAddGroupPermissions(true);
                addPortletRepositoryServiceContext.setAddGuestPermissions(true);
                repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (ServiceContext)addPortletRepositoryServiceContext);
            }
            String fileName = copyFragmentEntry.getFragmentEntryId() + "_preview." + fileEntry.getExtension();
            fileEntry = PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)FragmentEntry.class.getName(), (long)copyFragmentEntry.getFragmentEntryId(), (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (long)repository.getDlFolderId(), (InputStream)fileEntry.getContentStream(), (String)fileName, (String)fileEntry.getMimeType(), (boolean)false);
            this.updateFragmentEntry(copyFragmentEntry.getFragmentEntryId(), fileEntry.getFileEntryId());
        }
    }

    private void _copyFragmentEntryResources(FragmentEntry fragmentEntry, long sourceFragmentCollectionId, long targetFragmentCollectionId) throws PortalException {
        block5: {
            if (sourceFragmentCollectionId == targetFragmentCollectionId) {
                return;
            }
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            Set<FileEntry> fileEntries = this._getFileEntries(sourceFragmentCollectionId, fragmentEntry);
            if (serviceContext == null || fileEntries.isEmpty()) {
                return;
            }
            FragmentCollection targetFragmentCollection = this._fragmentCollectionPersistence.fetchByPrimaryKey(targetFragmentCollectionId);
            try {
                for (FileEntry fileEntry : fileEntries) {
                    FileEntry existingFileEntry = PortletFileRepositoryUtil.fetchPortletFileEntry((long)fragmentEntry.getGroupId(), (long)targetFragmentCollection.getResourcesFolderId(), (String)fileEntry.getFileName());
                    if (existingFileEntry != null) continue;
                    PortletFileRepositoryUtil.addPortletFileEntry((long)serviceContext.getScopeGroupId(), (long)serviceContext.getUserId(), (String)FragmentCollection.class.getName(), (long)targetFragmentCollection.getFragmentCollectionId(), (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (long)targetFragmentCollection.getResourcesFolderId(), (InputStream)fileEntry.getContentStream(), (String)fileEntry.getFileName(), (String)fileEntry.getMimeType(), (boolean)false);
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)exception);
            }
        }
    }

    private Set<FileEntry> _getFileEntries(long fragmentCollectionId, FragmentEntry fragmentEntry) throws PortalException {
        HashSet<FileEntry> fileEntries = new HashSet<FileEntry>();
        FragmentCollection fragmentCollection = this._fragmentCollectionPersistence.fetchByPrimaryKey(fragmentCollectionId);
        Matcher matcher = _pattern.matcher(fragmentEntry.getHtml());
        while (matcher.find()) {
            FileEntry fileEntry = PortletFileRepositoryUtil.fetchPortletFileEntry((long)fragmentEntry.getGroupId(), (long)fragmentCollection.getResourcesFolderId(), (String)matcher.group(1));
            if (fileEntry == null) continue;
            fileEntries.add(fileEntry);
        }
        return fileEntries;
    }

    private String _getFragmentEntryKey(String fragmentEntryKey) {
        if (fragmentEntryKey != null) {
            fragmentEntryKey = fragmentEntryKey.trim();
            return StringUtil.toLowerCase((String)fragmentEntryKey);
        }
        return "";
    }

    private void _propagateChanges(long fragmentEntryId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._fragmentEntryLinkLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property fragmentEntryIdProperty = PropertyFactoryUtil.forName((String)"fragmentEntryId");
            dynamicQuery.add(fragmentEntryIdProperty.eq((Object)fragmentEntryId));
        });
        actionableDynamicQuery.setPerformActionMethod(fragmentEntryLink -> this._fragmentEntryLinkLocalService.updateLatestChanges(fragmentEntryLink.getFragmentEntryLinkId()));
        actionableDynamicQuery.performActions();
    }
}

