/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.exportimport.content.processor;

import com.liferay.asset.list.model.AssetListEntry;
import com.liferay.asset.list.service.AssetListEntryLocalService;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.fragment.internal.exportimport.content.processor.BaseEditableValuesConfigurationExportImportContentProcessor;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.xml.Element;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"content.processor.type=FragmentEntryLinkEditableValues"}, service={ExportImportContentProcessor.class})
public class CollectionSelectorEditableValuesConfigurationExportImportContentProcessor
extends BaseEditableValuesConfigurationExportImportContentProcessor {
    @Reference
    private AssetListEntryLocalService _assetListEntryLocalService;
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;

    @Override
    protected String getConfigurationType() {
        return "collectionSelector";
    }

    @Override
    protected FragmentEntryConfigurationParser getFragmentEntryConfigurationParser() {
        return this._fragmentEntryConfigurationParser;
    }

    @Override
    protected void replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, JSONObject configurationValueJSONObject, boolean exportReferencedContent) throws Exception {
        if (!configurationValueJSONObject.has("classPK")) {
            return;
        }
        AssetListEntry assetListEntry = this._assetListEntryLocalService.fetchAssetListEntry(configurationValueJSONObject.getLong("classPK"));
        if (assetListEntry == null) {
            return;
        }
        if (exportReferencedContent) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)assetListEntry, (StagedModel)stagedModel, (String)"dependency");
        } else {
            Element entityElement = portletDataContext.getExportDataElement((ClassedModel)assetListEntry);
            portletDataContext.addReferenceElement((ClassedModel)assetListEntry, entityElement, (ClassedModel)stagedModel, "dependency", true);
        }
    }

    @Override
    protected void replaceImportContentReferences(PortletDataContext portletDataContext, JSONObject configurationValueJSONObject) {
        if (!configurationValueJSONObject.has("classPK")) {
            return;
        }
        Map assetListEntryNewPrimaryKeys = portletDataContext.getNewPrimaryKeysMap(AssetListEntry.class.getName());
        configurationValueJSONObject.put("classPK", (Object)assetListEntryNewPrimaryKeys.getOrDefault(configurationValueJSONObject.getLong("classPK"), 0L));
    }
}

