/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.exportimport.content.processor;

import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.fragment.internal.exportimport.content.processor.BaseEditableValuesConfigurationExportImportContentProcessor;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"content.processor.type=FragmentEntryLinkEditableValues"}, service={ExportImportContentProcessor.class})
public class URLEditableValuesConfigurationExportImportContentProcessor
extends BaseEditableValuesConfigurationExportImportContentProcessor {
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    @Reference
    private LayoutLocalService _layoutLocalService;

    @Override
    protected String getConfigurationType() {
        return "url";
    }

    @Override
    protected FragmentEntryConfigurationParser getFragmentEntryConfigurationParser() {
        return this._fragmentEntryConfigurationParser;
    }

    @Override
    protected void replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, JSONObject configurationValueJSONObject, boolean exportReferencedContent) throws Exception {
        if (configurationValueJSONObject != null && configurationValueJSONObject.has("layout")) {
            this._exportLayoutReferences(portletDataContext, stagedModel, configurationValueJSONObject.getJSONObject("layout"), exportReferencedContent);
        }
    }

    @Override
    protected void replaceImportContentReferences(PortletDataContext portletDataContext, JSONObject configurationValueJSONObject) {
        if (configurationValueJSONObject != null && configurationValueJSONObject.has("layout")) {
            this._replaceImportLayoutReferences(configurationValueJSONObject.getJSONObject("layout"), portletDataContext);
        }
    }

    private void _exportLayoutReferences(PortletDataContext portletDataContext, StagedModel referrerStagedModel, JSONObject layoutJSONObject, boolean exportReferencedContent) throws Exception {
        if (layoutJSONObject.length() == 0) {
            return;
        }
        Layout layout = this._layoutLocalService.fetchLayout(layoutJSONObject.getLong("groupId"), layoutJSONObject.getBoolean("privateLayout"), layoutJSONObject.getLong("layoutId"));
        if (layout == null) {
            return;
        }
        layoutJSONObject.put("plid", layout.getPlid());
        if (exportReferencedContent) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)referrerStagedModel, (StagedModel)layout, (String)"dependency");
        } else {
            Element entityElement = portletDataContext.getExportDataElement((ClassedModel)referrerStagedModel);
            portletDataContext.addReferenceElement((ClassedModel)referrerStagedModel, entityElement, (ClassedModel)layout, "dependency", true);
        }
    }

    private void _replaceImportLayoutReferences(JSONObject layoutJSONObject, PortletDataContext portletDataContext) {
        if (layoutJSONObject.length() == 0) {
            return;
        }
        long plid = GetterUtil.getLong((Object)layoutJSONObject.remove("plid"));
        Map layoutNewPrimaryKeys = portletDataContext.getNewPrimaryKeysMap(Layout.class.getName());
        Layout layout = this._layoutLocalService.fetchLayout(layoutNewPrimaryKeys.getOrDefault(plid, 0L).longValue());
        if (layout == null) {
            return;
        }
        layoutJSONObject.put("groupId", layout.getGroupId()).put("layoutId", layout.getLayoutId()).put("layoutUuid", layout.getUuid()).put("privateLayout", layout.isPrivateLayout());
    }
}

