/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.xml.Element;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class FragmentCollectionStagedModelDataHandler
extends BaseStagedModelDataHandler<FragmentCollection> {
    public static final String[] CLASS_NAMES = new String[]{FragmentCollection.class.getName()};
    @Reference(target="(model.class.name=com.liferay.fragment.model.FragmentCollection)", unbind="-")
    private StagedModelRepository<FragmentCollection> _stagedModelRepository;

    public void deleteStagedModel(FragmentCollection fragmentCollection) throws PortalException {
        this._stagedModelRepository.deleteStagedModel((StagedModel)fragmentCollection);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        this._stagedModelRepository.deleteStagedModel(uuid, groupId, className, extraData);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(FragmentCollection fragmentCollection) {
        return fragmentCollection.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, FragmentCollection fragmentCollection) throws Exception {
        Element fragmentCollectionElement = portletDataContext.getExportDataElement((ClassedModel)fragmentCollection);
        portletDataContext.addClassedModel(fragmentCollectionElement, ExportImportPathUtil.getModelPath((StagedModel)fragmentCollection), (ClassedModel)fragmentCollection);
        for (FileEntry fileEntry : fragmentCollection.getResources()) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fragmentCollection, (StagedModel)fileEntry, (String)"weak");
        }
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, FragmentCollection fragmentCollection) throws Exception {
        FragmentCollection importedFragmentCollection = (FragmentCollection)fragmentCollection.clone();
        importedFragmentCollection.setGroupId(portletDataContext.getScopeGroupId());
        FragmentCollection existingFragmentCollection = (FragmentCollection)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(fragmentCollection.getUuid(), portletDataContext.getScopeGroupId());
        if (existingFragmentCollection == null || !portletDataContext.isDataStrategyMirror()) {
            importedFragmentCollection = (FragmentCollection)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedFragmentCollection);
        } else {
            importedFragmentCollection.setMvccVersion(existingFragmentCollection.getMvccVersion());
            importedFragmentCollection.setFragmentCollectionId(existingFragmentCollection.getFragmentCollectionId());
            importedFragmentCollection = (FragmentCollection)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)importedFragmentCollection);
        }
        portletDataContext.importClassedModel((ClassedModel)fragmentCollection, (ClassedModel)importedFragmentCollection);
    }

    protected StagedModelRepository<FragmentCollection> getStagedModelRepository() {
        return this._stagedModelRepository;
    }
}

