/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.exportimport.staged.model.repository;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryHelper;
import com.liferay.fragment.exception.RequiredFragmentEntryException;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.fragment.model.FragmentEntry"}, service={StagedModelRepository.class})
public class FragmentEntryStagedModelRepository
implements StagedModelRepository<FragmentEntry> {
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private StagedModelRepositoryHelper _stagedModelRepositoryHelper;

    public FragmentEntry addStagedModel(PortletDataContext portletDataContext, FragmentEntry fragmentEntry) throws PortalException {
        long userId = portletDataContext.getUserId(fragmentEntry.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)fragmentEntry);
        if (portletDataContext.isDataStrategyMirror()) {
            serviceContext.setUuid(fragmentEntry.getUuid());
        }
        return this._fragmentEntryLocalService.addFragmentEntry(userId, fragmentEntry.getGroupId(), fragmentEntry.getFragmentCollectionId(), fragmentEntry.getFragmentEntryKey(), fragmentEntry.getName(), fragmentEntry.getCss(), fragmentEntry.getHtml(), fragmentEntry.getJs(), fragmentEntry.isCacheable(), fragmentEntry.getConfiguration(), fragmentEntry.getIcon(), fragmentEntry.getPreviewFileEntryId(), fragmentEntry.getType(), fragmentEntry.getTypeOptions(), fragmentEntry.getStatus(), serviceContext);
    }

    public void deleteStagedModel(FragmentEntry fragmentEntry) throws PortalException {
        this._fragmentEntryLocalService.deleteFragmentEntry(fragmentEntry);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        FragmentEntry fragmentEntry = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (fragmentEntry != null) {
            this._deleteFragmentEntryLinks(extraData, fragmentEntry, groupId);
            this.deleteStagedModel(fragmentEntry);
        }
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
    }

    public FragmentEntry fetchMissingReference(String uuid, long groupId) {
        return (FragmentEntry)this._stagedModelRepositoryHelper.fetchMissingReference(uuid, groupId, (StagedModelRepository)this);
    }

    public FragmentEntry fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._fragmentEntryLocalService.fetchFragmentEntryByUuidAndGroupId(uuid, groupId);
    }

    public List<FragmentEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._fragmentEntryLocalService.getFragmentEntriesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        return this._fragmentEntryLocalService.getExportActionableDynamicQuery(portletDataContext);
    }

    public FragmentEntry getStagedModel(long id) throws PortalException {
        return this._fragmentEntryLocalService.getFragmentEntry(id);
    }

    public FragmentEntry saveStagedModel(FragmentEntry fragmentEntry) throws PortalException {
        return this._fragmentEntryLocalService.updateFragmentEntry(fragmentEntry);
    }

    public FragmentEntry updateStagedModel(PortletDataContext portletDataContext, FragmentEntry fragmentEntry) throws PortalException {
        return this._fragmentEntryLocalService.updateFragmentEntry(portletDataContext.getUserId(fragmentEntry.getUserUuid()), fragmentEntry.getFragmentEntryId(), fragmentEntry.getFragmentCollectionId(), fragmentEntry.getName(), fragmentEntry.getCss(), fragmentEntry.getHtml(), fragmentEntry.getJs(), fragmentEntry.isCacheable(), fragmentEntry.getConfiguration(), fragmentEntry.getIcon(), fragmentEntry.getPreviewFileEntryId(), fragmentEntry.getTypeOptions(), fragmentEntry.getStatus());
    }

    private void _deleteFragmentEntryLinks(String extraData, FragmentEntry fragmentEntry, long groupId) throws PortalException {
        if (extraData.isEmpty()) {
            return;
        }
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinksByFragmentEntryId(fragmentEntry.getFragmentEntryId());
        if (ListUtil.isEmpty((List)fragmentEntryLinks)) {
            return;
        }
        long[] plids = new long[]{};
        JSONObject extraDataJSONObject = this._jsonFactory.createJSONObject(extraData);
        boolean privateLayout = GetterUtil.getBoolean((Object)extraDataJSONObject.get("privateLayout"));
        for (String layoutUUID : JSONUtil.toStringArray((JSONArray)((JSONArray)extraDataJSONObject.get("layoutUUIDs")))) {
            Layout layout = this._layoutService.getLayoutByUuidAndGroupId(layoutUUID, groupId, privateLayout);
            plids = ArrayUtil.append((long[])plids, (long)layout.getPlid());
            Layout draftLayout = layout.fetchDraftLayout();
            if (draftLayout == null) continue;
            plids = ArrayUtil.append((long[])plids, (long)draftLayout.getPlid());
        }
        long[] fragmentEntryLinkIds = new long[fragmentEntryLinks.size()];
        for (int i = 0; i < fragmentEntryLinks.size(); ++i) {
            FragmentEntryLink fragmentEntryLink = (FragmentEntryLink)fragmentEntryLinks.get(i);
            if (!ArrayUtil.contains((long[])plids, (long)fragmentEntryLink.getPlid())) {
                throw new RequiredFragmentEntryException();
            }
            fragmentEntryLinkIds[i] = fragmentEntryLink.getFragmentEntryLinkId();
        }
        this._fragmentEntryLinkLocalService.deleteFragmentEntryLinks(fragmentEntryLinkIds);
    }
}

