/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.model.listener;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.CopyLayoutThreadLocal;
import java.util.Date;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class LayoutModelListener
extends BaseModelListener<Layout> {
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;

    public void onAfterUpdate(Layout originalLayout, Layout layout) throws ModelListenerException {
        if (CopyLayoutThreadLocal.isCopyLayout() || ExportImportThreadLocal.isImportInProcess() || !layout.isTypeAssetDisplay() && !layout.isTypeContent() || layout.isDraftLayout() || Objects.equals(originalLayout.getModifiedDate(), layout.getModifiedDate())) {
            return;
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(layout.getPlid());
        if (layoutPageTemplateEntry == null) {
            return;
        }
        layoutPageTemplateEntry.setModifiedDate(new Date());
        this._layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    public void onBeforeRemove(Layout layout) throws ModelListenerException {
        if (!layout.isTypeAssetDisplay() && !layout.isTypeContent()) {
            return;
        }
        this._fragmentEntryLinkLocalService.deleteLayoutPageTemplateEntryFragmentEntryLinks(layout.getGroupId(), layout.getPlid());
    }
}

