/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.upgrade.v2_10_1;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class FragmentCollectionUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(FragmentCollectionUpgradeProcess.class);
    private final DLFolderLocalService _dlFolderLocalService;

    public FragmentCollectionUpgradeProcess(DLFolderLocalService dlFolderLocalService) {
        this._dlFolderLocalService = dlFolderLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeFragmentCollectionResourceFolder();
    }

    private void _upgradeFragmentCollectionResourceFolder() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select groupId, fragmentCollectionId, fragmentCollectionKey from FragmentCollection");){
            ResultSet resultSet = preparedStatement1.executeQuery();
            while (resultSet.next()) {
                long groupId = resultSet.getLong("groupId");
                Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet");
                if (repository == null) continue;
                long fragmentCollectionId = resultSet.getLong("fragmentCollectionId");
                String fragmentCollectionKey = resultSet.getString("fragmentCollectionKey");
                try {
                    Folder portletFolder = PortletFileRepositoryUtil.getPortletFolder((long)repository.getRepositoryId(), (long)repository.getDlFolderId(), (String)String.valueOf(fragmentCollectionId));
                    if (!(portletFolder.getModel() instanceof DLFolder)) continue;
                    DLFolder dlFolder = (DLFolder)portletFolder.getModel();
                    dlFolder.setName(fragmentCollectionKey);
                    this._dlFolderLocalService.updateDLFolder(dlFolder);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)"Unable to get portlet folder", (Throwable)exception);
                }
            }
        }
    }
}

