/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.upgrade.v2_9_1;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class FragmentEntryLinkUpgradeProcess
extends UpgradeProcess {
    private static final String[] _FRAGMENT_ENTRY_PROCESSOR_KEYS = new String[]{"com.liferay.fragment.entry.processor.background.image.BackgroundImageFragmentEntryProcessor", "com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor", "com.liferay.fragment.entry.processor.freemarker.FreeMarkerFragmentEntryProcessor"};
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryLinkUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select fragmentEntryLinkId, editableValues from FragmentEntryLink");
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update FragmentEntryLink set editableValues = ? where fragmentEntryLinkId = ?");){
            while (resultSet.next()) {
                long fragmentEntryLinkId = resultSet.getLong("fragmentEntryLinkId");
                String editableValues = resultSet.getString("editableValues");
                preparedStatement2.setString(1, this._stripEmptyFragmentEntryProcessor(editableValues));
                preparedStatement2.setLong(2, fragmentEntryLinkId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private String _stripEmptyFragmentEntryProcessor(String editableValues) {
        try {
            JSONObject editableValuesJSONObject = JSONFactoryUtil.createJSONObject((String)editableValues);
            for (String fragmentEntryProcessorKey : _FRAGMENT_ENTRY_PROCESSOR_KEYS) {
                JSONObject fragmentEntryProcessorJSONObject = editableValuesJSONObject.getJSONObject(fragmentEntryProcessorKey);
                if (fragmentEntryProcessorJSONObject == null || fragmentEntryProcessorJSONObject.length() != 0) continue;
                editableValuesJSONObject.remove(fragmentEntryProcessorKey);
            }
            return editableValuesJSONObject.toString();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return editableValues;
        }
    }
}

