/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.upgrade.v2_9_4;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class FragmentEntryLinkUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryLinkUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        this._updateFragmentEntryType();
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"FragmentEntryLink", (String[])new String[]{"type_ INTEGER"})};
    }

    private int _getFragmentEntryType(long fragmentEntryId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select type_ from FragmentEntry where fragmentEntryId = ? ");){
            preparedStatement.setLong(1, fragmentEntryId);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt("type_");
                return n;
            }
        }
        return 1;
    }

    private int _getFragmentEntryType(String editableValues, long fragmentEntryId) throws Exception {
        block4: {
            if (Validator.isNotNull((String)editableValues)) {
                try {
                    JSONObject editableValuesJSONObject = JSONFactoryUtil.createJSONObject((String)editableValues);
                    if (editableValuesJSONObject.has("portletId")) {
                        return 4;
                    }
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Throwable)exception);
                }
            }
        }
        return this._getFragmentEntryType(fragmentEntryId);
    }

    private void _updateFragmentEntryType() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select fragmentEntryLinkId, fragmentEntryId, editableValues from FragmentEntryLink");
             ResultSet resultSet1 = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update FragmentEntryLink set type_ = ? where fragmentEntryLinkId = ?");){
            while (resultSet1.next()) {
                long fragmentEntryLinkId = resultSet1.getLong("fragmentEntryLinkId");
                long fragmentEntryId = resultSet1.getLong("fragmentEntryId");
                String editableValues = resultSet1.getString("editableValues");
                preparedStatement2.setInt(1, this._getFragmentEntryType(editableValues, fragmentEntryId));
                preparedStatement2.setLong(2, fragmentEntryLinkId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

