/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.internal.validator;

import com.liferay.fragment.exception.FragmentEntryConfigurationException;
import com.liferay.fragment.exception.FragmentEntryFieldTypesException;
import com.liferay.fragment.exception.FragmentEntryTypeOptionsException;
import com.liferay.fragment.validator.FragmentEntryValidator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.validator.JSONValidator;
import com.liferay.portal.json.validator.JSONValidatorException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashSet;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FragmentEntryValidator.class})
public class FragmentEntryValidatorImpl
implements FragmentEntryValidator {
    private static final JSONValidator _configurationJSONValidator = new JSONValidator(FragmentEntryValidatorImpl.class.getResource("dependencies/configuration-json-schema.json"));
    private static final JSONValidator _typeOptionsJSONValidator = new JSONValidator(FragmentEntryValidatorImpl.class.getResource("dependencies/type-options-json-schema.json"));
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;

    public void validateConfiguration(String configuration) throws FragmentEntryConfigurationException {
        this.validateConfigurationValues(configuration, null);
    }

    public void validateConfigurationValues(String configuration, JSONObject valuesJSONObject) throws FragmentEntryConfigurationException {
        if (Validator.isNull((String)configuration)) {
            return;
        }
        try {
            _configurationJSONValidator.validate(configuration);
            JSONObject configurationJSONObject = this._jsonFactory.createJSONObject(configuration);
            JSONArray fieldSetsJSONArray = configurationJSONObject.getJSONArray("fieldSets");
            HashSet<String> fieldNames = new HashSet<String>();
            for (int fieldSetIndex = 0; fieldSetIndex < fieldSetsJSONArray.length(); ++fieldSetIndex) {
                JSONObject fieldSetJSONObject = fieldSetsJSONArray.getJSONObject(fieldSetIndex);
                JSONArray fieldsJSONArray = fieldSetJSONObject.getJSONArray("fields");
                for (int fieldIndex = 0; fieldIndex < fieldsJSONArray.length(); ++fieldIndex) {
                    JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(fieldIndex);
                    String fieldName = fieldJSONObject.getString("name");
                    if (fieldNames.contains(fieldName)) {
                        throw new FragmentEntryConfigurationException("Field names must be unique");
                    }
                    JSONObject typeOptionsJSONObject = fieldJSONObject.getJSONObject("typeOptions");
                    if (typeOptionsJSONObject != null) {
                        String value;
                        String defaultValue = fieldJSONObject.getString("defaultValue");
                        if (!this._checkValidationRules(defaultValue, typeOptionsJSONObject.getJSONObject("validation"))) {
                            throw new FragmentEntryConfigurationException("Invalid default configuration value for field " + fieldName);
                        }
                        if (valuesJSONObject != null && !this._checkValidationRules(value = valuesJSONObject.getString(fieldName), typeOptionsJSONObject.getJSONObject("validation"))) {
                            throw new FragmentEntryConfigurationException("Invalid configuration value for field " + fieldName);
                        }
                    }
                    fieldNames.add(fieldName);
                }
            }
        }
        catch (JSONException jsonException) {
            throw new FragmentEntryConfigurationException(this._getMessage(jsonException.getMessage()), (Throwable)jsonException);
        }
        catch (JSONValidatorException jsonValidatorException) {
            throw new FragmentEntryConfigurationException(this._getMessage(jsonValidatorException.getMessage()), (Throwable)jsonValidatorException);
        }
    }

    public void validateTypeOptions(int fragmentEntryType, String typeOptions) throws FragmentEntryTypeOptionsException {
        if (Validator.isNull((String)typeOptions)) {
            return;
        }
        try {
            _typeOptionsJSONValidator.validate(typeOptions);
            JSONObject configurationJSONObject = this._jsonFactory.createJSONObject(typeOptions);
            JSONArray fieldTypesJSONArray = configurationJSONObject.getJSONArray("fieldTypes");
            if (!Objects.equals(3, fragmentEntryType)) {
                if (!JSONUtil.isEmpty((JSONArray)fieldTypesJSONArray)) {
                    throw new FragmentEntryFieldTypesException("Only fragment type input can have field types");
                }
                return;
            }
            if (JSONUtil.isEmpty((JSONArray)fieldTypesJSONArray)) {
                throw new FragmentEntryFieldTypesException("Fragment type input must have at least one field type");
            }
            if (fieldTypesJSONArray.length() > 1 && JSONUtil.hasValue((JSONArray)fieldTypesJSONArray, (Object)"captcha")) {
                throw new FragmentEntryFieldTypesException("Captcha field type cannot be mixed with other field types");
            }
        }
        catch (JSONException jsonException) {
            throw new FragmentEntryTypeOptionsException(this._getMessage(jsonException.getMessage()), (Throwable)jsonException);
        }
        catch (JSONValidatorException jsonValidatorException) {
            throw new FragmentEntryTypeOptionsException((Throwable)jsonValidatorException);
        }
    }

    private boolean _checkValidationRules(String value, JSONObject validationJSONObject) {
        if (Validator.isNull((String)value) || validationJSONObject == null) {
            return true;
        }
        String type = validationJSONObject.getString("type");
        if (Objects.equals(type, "email")) {
            return Validator.isEmailAddress((String)value);
        }
        if (Objects.equals(type, "number")) {
            long max = validationJSONObject.getLong("max", Long.MAX_VALUE);
            long min = validationJSONObject.getLong("min", Long.MIN_VALUE);
            boolean valid = false;
            if (Validator.isNumber((String)value) && GetterUtil.getLong((String)value) <= max && GetterUtil.getLong((String)value) >= min) {
                valid = true;
            }
            return valid;
        }
        if (Objects.equals(type, "pattern")) {
            String regexp = validationJSONObject.getString("regexp");
            return value.matches(regexp);
        }
        if (Objects.equals(type, "url")) {
            return Validator.isUrl((String)value);
        }
        long maxLength = validationJSONObject.getLong("maxLength", Long.MAX_VALUE);
        long minLength = validationJSONObject.getLong("minLength", Long.MIN_VALUE);
        return (long)value.length() <= maxLength && (long)value.length() >= minLength;
    }

    private String _getMessage(String message) {
        return StringBundler.concat((String[])new String[]{this._language.get(LocaleUtil.getDefault(), "fragment-configuration-is-invalid"), System.lineSeparator(), message});
    }
}

