/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.model.impl;

import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.impl.FragmentCollectionBaseImpl;
import com.liferay.fragment.service.FragmentCompositionLocalServiceUtil;
import com.liferay.fragment.service.FragmentEntryLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.zip.ZipWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FragmentCollectionImpl
extends FragmentCollectionBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(FragmentCollectionImpl.class);
    private Repository _repository;
    private long _resourcesFolderId;

    public FileEntry getResource(String path) {
        try {
            Repository repository = this._getRepository();
            return PortletFileRepositoryUtil.fetchPortletFileEntry((long)this.getGroupId(), (long)this._getResourcesFolderId(this.getResourcesFolderId(true), path, repository.getRepositoryId()), (String)this._getFileName(path));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to get file entry", (Throwable)portalException);
            }
            return null;
        }
    }

    public List<FileEntry> getResources() throws PortalException {
        Map<String, FileEntry> resourcesMap = this._getResourcesMap(PortletFileRepositoryUtil.getPortletFolder((long)this.getResourcesFolderId()), null);
        return new ArrayList<FileEntry>(resourcesMap.values());
    }

    public long getResourcesFolderId() throws PortalException {
        return this.getResourcesFolderId(true);
    }

    public long getResourcesFolderId(boolean createIfAbsent) throws PortalException {
        if (this._resourcesFolderId != 0L) {
            return this._resourcesFolderId;
        }
        Repository repository = this._getRepository();
        Folder folder = null;
        try {
            folder = PortletFileRepositoryUtil.getPortletFolder((long)repository.getRepositoryId(), (long)repository.getDlFolderId(), (String)this.getFragmentCollectionKey());
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            if (createIfAbsent) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddGroupPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                folder = PortletFileRepositoryUtil.addPortletFolder((long)PortalUtil.getValidUserId((long)this.getCompanyId(), (long)this.getUserId()), (long)repository.getRepositoryId(), (long)repository.getDlFolderId(), (String)this.getFragmentCollectionKey(), (ServiceContext)serviceContext);
            }
            return 0L;
        }
        this._resourcesFolderId = folder.getFolderId();
        return this._resourcesFolderId;
    }

    public Map<String, FileEntry> getResourcesMap() throws PortalException {
        return this._getResourcesMap(PortletFileRepositoryUtil.getPortletFolder((long)this.getResourcesFolderId()), null);
    }

    public boolean hasResources() throws PortalException {
        Repository repository = this._getRepository();
        int fileEntriesCount = DLAppServiceUtil.getFoldersAndFileEntriesAndFileShortcutsCount((long)repository.getRepositoryId(), (long)this.getResourcesFolderId(), (int)0, (boolean)false);
        return fileEntriesCount > 0;
    }

    public void populateZipWriter(ZipWriter zipWriter) throws Exception {
        this.populateZipWriter(zipWriter, "");
    }

    public void populateZipWriter(ZipWriter zipWriter, String path) throws Exception {
        path = path + "/" + this.getFragmentCollectionKey();
        zipWriter.addEntry(path + "/" + "collection.json", JSONUtil.put((String)"description", (Object)this.getDescription()).put("name", this.getName()).toString());
        List fragmentCompositions = FragmentCompositionLocalServiceUtil.getFragmentCompositions((long)this.getFragmentCollectionId());
        for (Object fragmentComposition : fragmentCompositions) {
            fragmentComposition.populateZipWriter(zipWriter, path + "/fragment-compositions");
        }
        List fragmentEntries = FragmentEntryLocalServiceUtil.getFragmentEntries((long)this.getFragmentCollectionId(), (int)-1, (int)-1);
        for (FragmentEntry fragmentEntry : fragmentEntries) {
            if (fragmentEntry.isTypeReact()) continue;
            fragmentEntry.populateZipWriter(zipWriter, path + "/fragments");
        }
        if (!this.hasResources()) {
            return;
        }
        Map<String, FileEntry> resourcesMap = this.getResourcesMap();
        for (Map.Entry<String, FileEntry> entry : resourcesMap.entrySet()) {
            FileEntry fileEntry = entry.getValue();
            zipWriter.addEntry(StringBundler.concat((String[])new String[]{path, "/resources/", entry.getKey()}), fileEntry.getContentStream());
        }
    }

    private String _getFileName(String path) {
        int index;
        if (Validator.isNull((String)path) || path.endsWith("/")) {
            return "";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((index = path.lastIndexOf("/")) == -1) {
            return path;
        }
        return path.substring(index + 1);
    }

    private Repository _getRepository() throws PortalException {
        Repository repository;
        if (this._repository != null) {
            return this._repository;
        }
        long groupId = this.getGroupId();
        if (groupId == 0L) {
            User user = UserLocalServiceUtil.getUser((long)this.getUserId());
            groupId = user.getGroupId();
        }
        if ((repository = PortletFileRepositoryUtil.fetchPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet")) == null) {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (ServiceContext)serviceContext);
        }
        this._repository = repository;
        return this._repository;
    }

    private long _getResourcesFolderId(long folderId, String path, long repositoryId) {
        String[] pathArray;
        if (Validator.isNull((String)path) || path.endsWith("/")) {
            return folderId;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((pathArray = path.split("/")).length == 1) {
            return folderId;
        }
        try {
            Folder folder = DLAppServiceUtil.getFolder((long)repositoryId, (long)folderId, (String)pathArray[0]);
            return this._getResourcesFolderId(folder.getFolderId(), path.substring(path.indexOf("/")), repositoryId);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No resource folder found with name " + pathArray[0]), (Throwable)exception);
            }
            return 0L;
        }
    }

    private Map<String, FileEntry> _getResourcesMap(Folder folder, String parentPath) throws PortalException {
        HashMap<String, FileEntry> resourcesMap = new HashMap<String, FileEntry>();
        Repository repository = this._getRepository();
        List foldersAndFileEntriesAndFileShortcuts = DLAppServiceUtil.getFoldersAndFileEntriesAndFileShortcuts((long)repository.getRepositoryId(), (long)folder.getFolderId(), (int)0, (boolean)false, (int)-1, (int)-1);
        for (Object object : foldersAndFileEntriesAndFileShortcuts) {
            if (object instanceof Folder) {
                Folder childFolder = (Folder)object;
                String childFolderPath = childFolder.getName();
                if (!Validator.isBlank((String)parentPath)) {
                    childFolderPath = parentPath + "/" + childFolderPath;
                }
                resourcesMap.putAll(this._getResourcesMap(childFolder, childFolderPath));
                continue;
            }
            if (!(object instanceof FileEntry)) continue;
            FileEntry fileEntry = (FileEntry)object;
            String fileEntryPath = fileEntry.getTitle();
            if (!Validator.isBlank((String)parentPath)) {
                fileEntryPath = parentPath + "/" + fileEntryPath;
            }
            resourcesMap.put(fileEntryPath, fileEntry);
        }
        return resourcesMap;
    }
}

