/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.service.impl;

import com.liferay.document.library.util.DLURLHelper;
import com.liferay.fragment.listener.FragmentEntryLinkListener;
import com.liferay.fragment.listener.FragmentEntryLinkListenerRegistry;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.model.FragmentEntryLinkTable;
import com.liferay.fragment.processor.DefaultFragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.service.base.FragmentEntryLinkLocalServiceBaseImpl;
import com.liferay.fragment.service.persistence.FragmentCollectionPersistence;
import com.liferay.fragment.service.persistence.FragmentEntryPersistence;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntryTable;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.LockedLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTable;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.GuestOrUserUtil;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.fragment.model.FragmentEntryLink"}, service={AopService.class})
public class FragmentEntryLinkLocalServiceImpl
extends FragmentEntryLinkLocalServiceBaseImpl {
    private static final String[] _FRAGMENT_ENTRY_PROCESSOR_KEYS = new String[]{"com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor"};
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryLinkLocalServiceImpl.class);
    private static final Pattern _pattern = Pattern.compile("\\[resources:(.+?)\\]");
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private FragmentCollectionPersistence _fragmentCollectionPersistence;
    @Reference
    private FragmentEntryLinkListenerRegistry _fragmentEntryLinkListenerRegistry;
    @Reference
    private FragmentEntryPersistence _fragmentEntryPersistence;
    @Reference
    private FragmentEntryProcessorRegistry _fragmentEntryProcessorRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public FragmentEntryLink addFragmentEntryLink(long userId, long groupId, long originalFragmentEntryLinkId, long fragmentEntryId, long segmentsExperienceId, long plid, String css, String html, String js, String configuration, String editableValues, String namespace, int position, String rendererKey, int type, ServiceContext serviceContext) throws PortalException {
        this._checkUnlockedLayout(plid, userId);
        User user = this._userLocalService.getUser(userId);
        long fragmentEntryLinkId = this.counterLocalService.increment();
        FragmentEntryLink fragmentEntryLink = this.fragmentEntryLinkPersistence.create(fragmentEntryLinkId);
        fragmentEntryLink.setUuid(serviceContext.getUuid());
        fragmentEntryLink.setGroupId(groupId);
        fragmentEntryLink.setCompanyId(user.getCompanyId());
        fragmentEntryLink.setUserId(user.getUserId());
        fragmentEntryLink.setUserName(user.getFullName());
        fragmentEntryLink.setCreateDate(serviceContext.getCreateDate(new Date()));
        fragmentEntryLink.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        fragmentEntryLink.setOriginalFragmentEntryLinkId(originalFragmentEntryLinkId);
        fragmentEntryLink.setFragmentEntryId(fragmentEntryId);
        fragmentEntryLink.setSegmentsExperienceId(segmentsExperienceId);
        fragmentEntryLink.setClassNameId(this._portal.getClassNameId(Layout.class));
        fragmentEntryLink.setClassPK(plid);
        fragmentEntryLink.setPlid(plid);
        fragmentEntryLink.setCss(css);
        html = this._replaceResources(fragmentEntryId, html);
        fragmentEntryLink.setHtml(html);
        fragmentEntryLink.setJs(js);
        fragmentEntryLink.setConfiguration(configuration);
        if (Validator.isNull((String)namespace)) {
            namespace = StringUtil.randomId();
        }
        fragmentEntryLink.setNamespace(namespace);
        fragmentEntryLink.setRendererKey(rendererKey);
        fragmentEntryLink.setType(type);
        String processedHTML = html;
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        HttpServletResponse httpServletResponse = serviceContext.getResponse();
        if (httpServletRequest != null && httpServletResponse != null) {
            DefaultFragmentEntryProcessorContext defaultFragmentEntryProcessorContext = new DefaultFragmentEntryProcessorContext(httpServletRequest, httpServletResponse, "EDIT", LocaleUtil.getMostRelevantLocale());
            defaultFragmentEntryProcessorContext.setFragmentElementId("");
            processedHTML = this._fragmentEntryProcessorRegistry.processFragmentEntryLinkHTML(fragmentEntryLink, (FragmentEntryProcessorContext)defaultFragmentEntryProcessorContext);
        }
        if (Validator.isNull((String)editableValues)) {
            editableValues = String.valueOf(this._fragmentEntryProcessorRegistry.getDefaultEditableValuesJSONObject(processedHTML, configuration));
        }
        fragmentEntryLink.setEditableValues(editableValues);
        fragmentEntryLink.setPosition(position);
        fragmentEntryLink.setLastPropagationDate(serviceContext.getCreateDate(new Date()));
        return (FragmentEntryLink)this.fragmentEntryLinkPersistence.update((BaseModel)fragmentEntryLink);
    }

    @Override
    @SystemEvent(type=1)
    public FragmentEntryLink deleteFragmentEntryLink(FragmentEntryLink fragmentEntryLink) {
        this.fragmentEntryLinkPersistence.remove((BaseModel)fragmentEntryLink);
        return fragmentEntryLink;
    }

    @Override
    public FragmentEntryLink deleteFragmentEntryLink(long fragmentEntryLinkId) throws PortalException {
        FragmentEntryLink fragmentEntryLink = this.fragmentEntryLinkPersistence.findByPrimaryKey(fragmentEntryLinkId);
        return this.fragmentEntryLinkLocalService.deleteFragmentEntryLink(fragmentEntryLink);
    }

    public void deleteFragmentEntryLinks(long groupId) {
        List fragmentEntryLinks = this.fragmentEntryLinkPersistence.findByGroupId(groupId);
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            this.fragmentEntryLinkLocalService.deleteFragmentEntryLink(fragmentEntryLink);
        }
    }

    public void deleteFragmentEntryLinks(long groupId, long plid, boolean deleted) {
        List fragmentEntryLinks = this.fragmentEntryLinkPersistence.findByG_P_D(groupId, plid, deleted);
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            this.fragmentEntryLinkLocalService.deleteFragmentEntryLink(fragmentEntryLink);
        }
    }

    public void deleteFragmentEntryLinks(long[] fragmentEntryLinkIds) throws PortalException {
        for (long fragmentEntryLinkId : fragmentEntryLinkIds) {
            this.fragmentEntryLinkLocalService.deleteFragmentEntryLink(fragmentEntryLinkId);
        }
    }

    public void deleteFragmentEntryLinksByFragmentEntryId(long fragmentEntryId) {
        List fragmentEntryLinks = this.fragmentEntryLinkPersistence.findByFragmentEntryId(fragmentEntryId);
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            this.fragmentEntryLinkLocalService.deleteFragmentEntryLink(fragmentEntryLink);
        }
    }

    public void deleteFragmentEntryLinksByFragmentEntryId(long fragmentEntryId, boolean deleted) {
        List fragmentEntryLinks = this.fragmentEntryLinkPersistence.findByF_D(fragmentEntryId, deleted);
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            this.fragmentEntryLinkLocalService.deleteFragmentEntryLink(fragmentEntryLink);
        }
    }

    public List<FragmentEntryLink> deleteLayoutPageTemplateEntryFragmentEntryLinks(long groupId, long plid) {
        List<FragmentEntryLink> fragmentEntryLinks = this.getFragmentEntryLinksByPlid(groupId, plid);
        if (ListUtil.isEmpty(fragmentEntryLinks)) {
            return Collections.emptyList();
        }
        ArrayList<FragmentEntryLink> deletedFragmentEntryLinks = new ArrayList<FragmentEntryLink>();
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            this.fragmentEntryLinkLocalService.deleteFragmentEntryLink(fragmentEntryLink);
            deletedFragmentEntryLinks.add(fragmentEntryLink);
        }
        return deletedFragmentEntryLinks;
    }

    @Deprecated
    public List<FragmentEntryLink> deleteLayoutPageTemplateEntryFragmentEntryLinks(long groupId, long classNameId, long classPK) {
        return this.deleteLayoutPageTemplateEntryFragmentEntryLinks(groupId, classPK);
    }

    public List<FragmentEntryLink> deleteLayoutPageTemplateEntryFragmentEntryLinks(long groupId, long[] segmentsExperienceIds, long plid) {
        List<FragmentEntryLink> fragmentEntryLinks = this.getFragmentEntryLinksBySegmentsExperienceId(groupId, segmentsExperienceIds, plid);
        if (ListUtil.isEmpty(fragmentEntryLinks)) {
            return Collections.emptyList();
        }
        ArrayList<FragmentEntryLink> deletedFragmentEntryLinks = new ArrayList<FragmentEntryLink>();
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            this.fragmentEntryLinkLocalService.deleteFragmentEntryLink(fragmentEntryLink);
            deletedFragmentEntryLinks.add(fragmentEntryLink);
        }
        return deletedFragmentEntryLinks;
    }

    public List<FragmentEntryLink> getAllFragmentEntryLinksByFragmentEntryId(long groupId, long fragmentEntryId, int start, int end, OrderByComparator<FragmentEntryLink> orderByComparator) {
        return this.fragmentEntryLinkFinder.findByG_F(groupId, fragmentEntryId, start, end, orderByComparator);
    }

    public int getAllFragmentEntryLinksCountByFragmentEntryId(long groupId, long fragmentEntryId) {
        return this.fragmentEntryLinkPersistence.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.count().from(DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{FragmentEntryLinkTable.INSTANCE.classNameId, FragmentEntryLinkTable.INSTANCE.classPK}).from((Table)FragmentEntryLinkTable.INSTANCE).where(FragmentEntryLinkTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)FragmentEntryLinkTable.INSTANCE.fragmentEntryId.eq((Object)fragmentEntryId)).and((Expression)FragmentEntryLinkTable.INSTANCE.deleted.eq((Object)false))).as("tempFragmentEntryLinkTable")));
    }

    @Deprecated
    public int getClassedModelFragmentEntryLinksCount(long groupId, long classNameId, long classPK) {
        return this.fragmentEntryLinkPersistence.countByG_C_C(groupId, classNameId, classPK);
    }

    public FragmentEntryLink getFragmentEntryLink(long groupId, long originalFragmentEntryLinkId, long plid) {
        return this.fragmentEntryLinkPersistence.fetchByG_OFELI_P_First(groupId, originalFragmentEntryLinkId, plid, null);
    }

    public List<FragmentEntryLink> getFragmentEntryLinks(int type, int start, int end, OrderByComparator<FragmentEntryLink> orderByComparator) {
        List fragmentEntries = this._fragmentEntryPersistence.findByType(type);
        if (fragmentEntries.isEmpty()) {
            return Collections.emptyList();
        }
        return this.fragmentEntryLinkPersistence.findByFragmentEntryId(ListUtil.toLongArray((List)fragmentEntries, (Accessor)FragmentEntry.FRAGMENT_ENTRY_ID_ACCESSOR), start, end, orderByComparator);
    }

    @Deprecated
    public List<FragmentEntryLink> getFragmentEntryLinks(long groupId, long classNameId, long classPK) {
        return this.fragmentEntryLinkPersistence.findByG_C_C(groupId, classNameId, classPK);
    }

    public List<FragmentEntryLink> getFragmentEntryLinks(long companyId, String rendererKey) {
        return this.fragmentEntryLinkPersistence.findByC_R(companyId, rendererKey);
    }

    public List<FragmentEntryLink> getFragmentEntryLinks(long companyId, String[] rendererKeys) {
        return this.fragmentEntryLinkPersistence.findByC_R(companyId, rendererKeys);
    }

    public List<FragmentEntryLink> getFragmentEntryLinks(String rendererKey) {
        return this.fragmentEntryLinkPersistence.findByRendererKey(rendererKey);
    }

    public List<FragmentEntryLink> getFragmentEntryLinksByFragmentEntryId(long fragmentEntryId) {
        return this.fragmentEntryLinkPersistence.findByFragmentEntryId(fragmentEntryId);
    }

    public List<FragmentEntryLink> getFragmentEntryLinksByFragmentEntryId(long fragmentEntryId, boolean deleted) {
        return this.fragmentEntryLinkPersistence.findByF_D(fragmentEntryId, deleted);
    }

    public List<FragmentEntryLink> getFragmentEntryLinksByPlid(long groupId, long plid) {
        return this.fragmentEntryLinkPersistence.findByG_P(groupId, plid);
    }

    public List<FragmentEntryLink> getFragmentEntryLinksBySegmentsExperienceId(long groupId, long segmentsExperienceId, long plid) {
        return this.fragmentEntryLinkPersistence.findByG_S_P(groupId, segmentsExperienceId, plid);
    }

    public List<FragmentEntryLink> getFragmentEntryLinksBySegmentsExperienceId(long groupId, long segmentsExperienceId, long plid, boolean deleted) {
        return this.fragmentEntryLinkPersistence.findByG_S_P_D(groupId, segmentsExperienceId, plid, deleted);
    }

    public List<FragmentEntryLink> getFragmentEntryLinksBySegmentsExperienceId(long groupId, long segmentsExperienceId, long plid, String rendererKey) {
        return this.fragmentEntryLinkPersistence.findByG_S_P_R(groupId, segmentsExperienceId, plid, rendererKey);
    }

    public List<FragmentEntryLink> getFragmentEntryLinksBySegmentsExperienceId(long groupId, long[] segmentsExperienceIds, long plid) {
        return this.fragmentEntryLinkPersistence.findByG_S_P(groupId, segmentsExperienceIds, plid);
    }

    public List<FragmentEntryLink> getFragmentEntryLinksBySegmentsExperienceId(long groupId, long[] segmentsExperienceIds, long plid, boolean deleted) {
        return this.fragmentEntryLinkPersistence.findByG_S_P_D(groupId, segmentsExperienceIds, plid, deleted);
    }

    public int getFragmentEntryLinksCountByFragmentEntryId(long fragmentEntryId) {
        return this.fragmentEntryLinkPersistence.countByFragmentEntryId(fragmentEntryId);
    }

    public int getFragmentEntryLinksCountByFragmentEntryId(long fragmentEntryId, boolean deleted) {
        return this.fragmentEntryLinkPersistence.countByF_D(fragmentEntryId, deleted);
    }

    public int getFragmentEntryLinksCountByPlid(long groupId, long plid) {
        return this.fragmentEntryLinkPersistence.countByG_P(groupId, plid);
    }

    public List<FragmentEntryLink> getLayoutFragmentEntryLinksByFragmentEntryId(long groupId, long fragmentEntryId, int start, int end, OrderByComparator<FragmentEntryLink> orderByComparator) {
        return this.fragmentEntryLinkFinder.findByG_F_P_L(groupId, fragmentEntryId, -1, start, end, orderByComparator);
    }

    public int getLayoutFragmentEntryLinksCountByFragmentEntryId(long groupId, long fragmentEntryId) {
        Table tempLayoutTableTable = DSLQueryFactoryUtil.select((Expression[])new Expression[]{LayoutTable.INSTANCE.plid}).from((Table)LayoutTable.INSTANCE).leftJoinOn((Table)LayoutPageTemplateEntryTable.INSTANCE, LayoutTable.INSTANCE.plid.eq((Expression)LayoutPageTemplateEntryTable.INSTANCE.plid).or((Expression)LayoutTable.INSTANCE.classPK.eq((Expression)LayoutPageTemplateEntryTable.INSTANCE.plid))).where(LayoutPageTemplateEntryTable.INSTANCE.plid.isNull()).as("tempLayoutTable", (Table)LayoutTable.INSTANCE);
        return this.fragmentEntryLinkPersistence.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.countDistinct((Expression)FragmentEntryLinkTable.INSTANCE.plid).from((Table)FragmentEntryLinkTable.INSTANCE).innerJoinON(tempLayoutTableTable, FragmentEntryLinkTable.INSTANCE.plid.eq((Expression)tempLayoutTableTable.getColumn("plid"))).where(FragmentEntryLinkTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)FragmentEntryLinkTable.INSTANCE.fragmentEntryId.eq((Object)fragmentEntryId)).and((Expression)FragmentEntryLinkTable.INSTANCE.deleted.eq((Object)false))));
    }

    public List<FragmentEntryLink> getLayoutPageTemplateFragmentEntryLinksByFragmentEntryId(long groupId, long fragmentEntryId, int layoutPageTemplateType, int start, int end, OrderByComparator<FragmentEntryLink> orderByComparator) {
        return this.fragmentEntryLinkFinder.findByG_F_P_L(groupId, fragmentEntryId, layoutPageTemplateType, start, end, orderByComparator);
    }

    public int getLayoutPageTemplateFragmentEntryLinksCountByFragmentEntryId(long groupId, long fragmentEntryId, int layoutPageTemplateType) {
        Table tempLayoutTableTable = DSLQueryFactoryUtil.select((Expression[])new Expression[]{LayoutTable.INSTANCE.plid}).from((Table)LayoutTable.INSTANCE).innerJoinON((Table)LayoutPageTemplateEntryTable.INSTANCE, LayoutTable.INSTANCE.plid.eq((Expression)LayoutPageTemplateEntryTable.INSTANCE.plid).or((Expression)LayoutTable.INSTANCE.classPK.eq((Expression)LayoutPageTemplateEntryTable.INSTANCE.plid))).where(LayoutPageTemplateEntryTable.INSTANCE.type.eq((Object)layoutPageTemplateType)).as("tempLayoutTable", (Table)LayoutTable.INSTANCE);
        return this.fragmentEntryLinkPersistence.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.countDistinct((Expression)FragmentEntryLinkTable.INSTANCE.plid).from((Table)FragmentEntryLinkTable.INSTANCE).innerJoinON(tempLayoutTableTable, FragmentEntryLinkTable.INSTANCE.plid.eq((Expression)tempLayoutTableTable.getColumn("plid"))).where(FragmentEntryLinkTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)FragmentEntryLinkTable.INSTANCE.fragmentEntryId.eq((Object)fragmentEntryId)).and((Expression)FragmentEntryLinkTable.INSTANCE.deleted.eq((Object)false))));
    }

    public void updateClassedModel(long plid) {
        block2: {
            try {
                this._layoutLocalService.updateStatus(PrincipalThreadLocal.getUserId(), plid, 2, ServiceContextThreadLocal.getServiceContext());
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)portalException);
            }
        }
    }

    public FragmentEntryLink updateDeleted(long fragmentEntryLinkId, boolean deleted) throws PortalException {
        FragmentEntryLink fragmentEntryLink = this.fragmentEntryLinkPersistence.findByPrimaryKey(fragmentEntryLinkId);
        this._checkUnlockedLayout(fragmentEntryLink.getPlid(), GuestOrUserUtil.getUserId());
        fragmentEntryLink.setDeleted(deleted);
        return (FragmentEntryLink)this.fragmentEntryLinkPersistence.update((BaseModel)fragmentEntryLink);
    }

    public FragmentEntryLink updateFragmentEntryLink(long fragmentEntryLinkId, int position) throws PortalException {
        FragmentEntryLink fragmentEntryLink = this.fetchFragmentEntryLink(fragmentEntryLinkId);
        this._checkUnlockedLayout(fragmentEntryLink.getPlid(), GuestOrUserUtil.getUserId());
        fragmentEntryLink.setPosition(position);
        return (FragmentEntryLink)this.fragmentEntryLinkPersistence.update((BaseModel)fragmentEntryLink);
    }

    public FragmentEntryLink updateFragmentEntryLink(long userId, long fragmentEntryLinkId, long originalFragmentEntryLinkId, long fragmentEntryId, long plid, String css, String html, String js, String configuration, String editableValues, String namespace, int position, int type, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        this._checkUnlockedLayout(plid, userId);
        FragmentEntryLink fragmentEntryLink = this.fetchFragmentEntryLink(fragmentEntryLinkId);
        fragmentEntryLink.setUserId(user.getUserId());
        fragmentEntryLink.setUserName(user.getFullName());
        fragmentEntryLink.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        fragmentEntryLink.setOriginalFragmentEntryLinkId(originalFragmentEntryLinkId);
        fragmentEntryLink.setFragmentEntryId(fragmentEntryId);
        fragmentEntryLink.setClassNameId(this._portal.getClassNameId(Layout.class));
        fragmentEntryLink.setClassPK(plid);
        fragmentEntryLink.setPlid(plid);
        fragmentEntryLink.setCss(css);
        fragmentEntryLink.setHtml(html);
        fragmentEntryLink.setJs(js);
        fragmentEntryLink.setConfiguration(configuration);
        fragmentEntryLink.setEditableValues(editableValues);
        if (Validator.isNotNull((String)namespace)) {
            fragmentEntryLink.setNamespace(namespace);
        }
        fragmentEntryLink.setPosition(position);
        fragmentEntryLink.setType(type);
        return (FragmentEntryLink)this.fragmentEntryLinkPersistence.update((BaseModel)fragmentEntryLink);
    }

    public FragmentEntryLink updateFragmentEntryLink(long fragmentEntryLinkId, String editableValues) throws PortalException {
        FragmentEntryLink fragmentEntryLink = this.fetchFragmentEntryLink(fragmentEntryLinkId);
        this._checkUnlockedLayout(fragmentEntryLink.getPlid(), GuestOrUserUtil.getUserId());
        fragmentEntryLink.setEditableValues(editableValues);
        return (FragmentEntryLink)this.fragmentEntryLinkPersistence.update((BaseModel)fragmentEntryLink);
    }

    public FragmentEntryLink updateFragmentEntryLink(long fragmentEntryLinkId, String editableValues, boolean updateClassedModel) throws PortalException {
        FragmentEntryLink fragmentEntryLink = this.fetchFragmentEntryLink(fragmentEntryLinkId);
        this._checkUnlockedLayout(fragmentEntryLink.getPlid(), GuestOrUserUtil.getUserId());
        fragmentEntryLink.setEditableValues(editableValues);
        if (updateClassedModel) {
            this.updateClassedModel(fragmentEntryLink.getPlid());
        }
        return (FragmentEntryLink)this.fragmentEntryLinkPersistence.update((BaseModel)fragmentEntryLink);
    }

    public void updateLatestChanges(FragmentEntry fragmentEntry, FragmentEntryLink fragmentEntryLink) throws PortalException {
        long fragmentEntryId = fragmentEntryLink.getFragmentEntryId();
        if (fragmentEntryId != fragmentEntry.getFragmentEntryId() || fragmentEntryId == 0L && !Objects.equals(fragmentEntry.getFragmentEntryKey(), fragmentEntryLink.getRendererKey())) {
            throw new UnsupportedOperationException("Unable to propagate fragment entry " + fragmentEntryId);
        }
        boolean modified = false;
        if (!Objects.equals(fragmentEntryLink.getConfiguration(), fragmentEntry.getConfiguration())) {
            fragmentEntryLink.setConfiguration(fragmentEntry.getConfiguration());
            modified = true;
        }
        if (!Objects.equals(fragmentEntryLink.getHtml(), fragmentEntry.getHtml())) {
            fragmentEntryLink.setHtml(this._replaceResources(fragmentEntry.getFragmentEntryId(), fragmentEntry.getHtml()));
            String defaultEditableValues = String.valueOf(this._fragmentEntryProcessorRegistry.getDefaultEditableValuesJSONObject(this._getProcessedHTML(fragmentEntryLink, ServiceContextThreadLocal.getServiceContext()), fragmentEntryLink.getConfiguration()));
            String newEditableValues = this._mergeEditableValues(defaultEditableValues, fragmentEntryLink.getEditableValues());
            fragmentEntryLink.setEditableValues(newEditableValues);
            modified = true;
        }
        if (!Objects.equals(fragmentEntryLink.getCss(), fragmentEntry.getCss())) {
            fragmentEntryLink.setCss(fragmentEntry.getCss());
            modified = true;
        }
        if (!Objects.equals(fragmentEntryLink.getJs(), fragmentEntry.getJs())) {
            fragmentEntryLink.setJs(fragmentEntry.getJs());
            modified = true;
        }
        if (fragmentEntryLink.getType() != fragmentEntry.getType()) {
            fragmentEntryLink.setType(fragmentEntry.getType());
            modified = true;
        }
        fragmentEntryLink.setLastPropagationDate(new Date());
        fragmentEntryLink = (FragmentEntryLink)this.fragmentEntryLinkPersistence.update((BaseModel)fragmentEntryLink);
        if (modified) {
            this._updateFragmentEntryLinkLayout(fragmentEntryLink);
            for (FragmentEntryLinkListener fragmentEntryLinkListener : this._fragmentEntryLinkListenerRegistry.getFragmentEntryLinkListeners()) {
                fragmentEntryLinkListener.onUpdateFragmentEntryLinkConfigurationValues(fragmentEntryLink);
            }
        }
    }

    public void updateLatestChanges(long fragmentEntryLinkId) throws PortalException {
        FragmentEntryLink fragmentEntryLink = this.fragmentEntryLinkPersistence.findByPrimaryKey(fragmentEntryLinkId);
        FragmentEntry fragmentEntry = this._fragmentEntryPersistence.findByPrimaryKey(fragmentEntryLink.getFragmentEntryId());
        this.updateLatestChanges(fragmentEntry, fragmentEntryLink);
    }

    private void _checkUnlockedLayout(long plid, long userId) throws PortalException {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        if (layout != null && !layout.isUnlocked("edit", userId)) {
            throw new LockedLayoutException();
        }
    }

    private String _getProcessedHTML(FragmentEntryLink fragmentEntryLink, ServiceContext serviceContext) throws PortalException {
        if (serviceContext == null) {
            return fragmentEntryLink.getHtml();
        }
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        HttpServletResponse httpServletResponse = serviceContext.getResponse();
        if (httpServletRequest == null || httpServletResponse == null) {
            return fragmentEntryLink.getHtml();
        }
        DefaultFragmentEntryProcessorContext fragmentEntryProcessorContext = new DefaultFragmentEntryProcessorContext(httpServletRequest, httpServletResponse, "EDIT", LocaleUtil.getMostRelevantLocale());
        return this._fragmentEntryProcessorRegistry.processFragmentEntryLinkHTML(fragmentEntryLink, (FragmentEntryProcessorContext)fragmentEntryProcessorContext);
    }

    private String _mergeEditableValues(String defaultEditableValues, String editableValues) {
        try {
            JSONObject defaultEditableValuesJSONObject = this._jsonFactory.createJSONObject(defaultEditableValues);
            JSONObject editableValuesJSONObject = this._jsonFactory.createJSONObject(editableValues);
            for (String fragmentEntryProcessorKey : _FRAGMENT_ENTRY_PROCESSOR_KEYS) {
                JSONObject defaultEditableFragmentEntryProcessorJSONObject;
                JSONObject editableFragmentEntryProcessorJSONObject = editableValuesJSONObject.getJSONObject(fragmentEntryProcessorKey);
                if (editableFragmentEntryProcessorJSONObject == null) {
                    editableFragmentEntryProcessorJSONObject = this._jsonFactory.createJSONObject();
                }
                if ((defaultEditableFragmentEntryProcessorJSONObject = defaultEditableValuesJSONObject.getJSONObject(fragmentEntryProcessorKey)) == null) continue;
                Iterator defaultEditableValuesIterator = defaultEditableFragmentEntryProcessorJSONObject.keys();
                while (defaultEditableValuesIterator.hasNext()) {
                    String key = (String)defaultEditableValuesIterator.next();
                    if (!editableFragmentEntryProcessorJSONObject.has(key)) continue;
                    defaultEditableFragmentEntryProcessorJSONObject.put(key, editableFragmentEntryProcessorJSONObject.get(key));
                }
                Iterator editableValuesIterator = editableFragmentEntryProcessorJSONObject.keys();
                while (editableValuesIterator.hasNext()) {
                    String key = (String)editableValuesIterator.next();
                    if (defaultEditableFragmentEntryProcessorJSONObject.has(key)) continue;
                    defaultEditableFragmentEntryProcessorJSONObject.put(key, editableFragmentEntryProcessorJSONObject.get(key));
                }
                editableValuesJSONObject.put(fragmentEntryProcessorKey, defaultEditableFragmentEntryProcessorJSONObject);
            }
            return editableValuesJSONObject.toString();
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            return editableValues;
        }
    }

    private String _replaceResources(long fragmentEntryId, String html) throws PortalException {
        FragmentEntry fragmentEntry = this._fragmentEntryPersistence.fetchByPrimaryKey(fragmentEntryId);
        if (fragmentEntry == null) {
            return html;
        }
        FragmentCollection fragmentCollection = this._fragmentCollectionPersistence.fetchByPrimaryKey(fragmentEntry.getFragmentCollectionId());
        Matcher matcher = _pattern.matcher(html);
        while (matcher.find()) {
            FileEntry fileEntry = fragmentCollection.getResource(matcher.group(1));
            String fileEntryURL = "";
            if (fileEntry != null) {
                fileEntryURL = this._dlURLHelper.getDownloadURL(fileEntry, fileEntry.getFileVersion(), null, "", false, false);
            }
            html = StringUtil.replace((String)html, (String)matcher.group(), (String)fileEntryURL);
        }
        return html;
    }

    private void _updateFragmentEntryLinkLayout(FragmentEntryLink fragmentEntryLink) {
        Layout layout = this._layoutLocalService.fetchLayout(fragmentEntryLink.getPlid());
        if (layout == null) {
            return;
        }
        layout.setModifiedDate(new Date());
        this._layoutLocalService.updateLayout(layout);
    }
}

