/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.service.impl;

import com.liferay.fragment.model.FragmentCompositionTable;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryTable;
import com.liferay.fragment.service.FragmentCompositionLocalService;
import com.liferay.fragment.service.base.FragmentEntryServiceBaseImpl;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.spi.expression.Scalar;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=fragment", "json.web.service.context.path=FragmentEntry"}, service={AopService.class})
public class FragmentEntryServiceImpl
extends FragmentEntryServiceBaseImpl {
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private FragmentCompositionLocalService _fragmentCompositionLocalService;
    @Reference(target="(resource.name=com.liferay.fragment)")
    private PortletResourcePermission _portletResourcePermission;

    public FragmentEntry addFragmentEntry(long groupId, long fragmentCollectionId, String fragmentEntryKey, String name, String css, String html, String js, boolean cacheable, String configuration, String icon, long previewFileEntryId, int type, String typeOptions, int status, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.addFragmentEntry(this.getUserId(), groupId, fragmentCollectionId, fragmentEntryKey, name, css, html, js, cacheable, configuration, icon, previewFileEntryId, type, typeOptions, status, serviceContext);
    }

    public FragmentEntry addFragmentEntry(long groupId, long fragmentCollectionId, String fragmentEntryKey, String name, String css, String html, String js, String configuration, long previewFileEntryId, int type, int status, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.addFragmentEntry(this.getUserId(), groupId, fragmentCollectionId, fragmentEntryKey, name, css, html, js, false, configuration, null, previewFileEntryId, type, null, status, serviceContext);
    }

    public FragmentEntry copyFragmentEntry(long groupId, long sourceFragmentEntryId, long fragmentCollectionId, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.copyFragmentEntry(this.getUserId(), groupId, sourceFragmentEntryId, fragmentCollectionId, serviceContext);
    }

    public void deleteFragmentEntries(long[] fragmentEntriesIds) throws PortalException {
        for (long fragmentEntryId : fragmentEntriesIds) {
            FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
            this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
            this.fragmentEntryLocalService.deleteFragmentEntry(fragmentEntry);
        }
    }

    public FragmentEntry deleteFragmentEntry(long fragmentEntryId) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.deleteFragmentEntry(fragmentEntryId);
    }

    public FragmentEntry fetchDraft(long primaryKey) {
        return this.fragmentEntryLocalService.fetchDraft(primaryKey);
    }

    public FragmentEntry fetchFragmentEntry(long fragmentEntryId) throws PortalException {
        return this.fragmentEntryLocalService.fetchFragmentEntry(fragmentEntryId);
    }

    public FragmentEntry getDraft(long primaryKey) throws PortalException {
        return this.fragmentEntryLocalService.getDraft(primaryKey);
    }

    public List<Object> getFragmentCompositionsAndFragmentEntries(long groupId, long fragmentCollectionId, int status, int start, int end, OrderByComparator<?> orderByComparator) {
        return this.getFragmentCompositionsAndFragmentEntries(groupId, fragmentCollectionId, "", status, start, end, orderByComparator);
    }

    public List<Object> getFragmentCompositionsAndFragmentEntries(long groupId, long fragmentCollectionId, String name, int status, int start, int end, OrderByComparator<?> orderByComparator) {
        ArrayList<Object> fragmentCompositionsAndFragmentEntries = new ArrayList<Object>();
        Table tempFragmentEntryTable = this._getFragmentCompositionGroupByStep(groupId, fragmentCollectionId, name, status).unionAll((DSLQuery)this._getFragmentEntryGroupByStep(groupId, fragmentCollectionId, name, status)).as("tempFragmentCompositionsAndFragmentEntriesTable");
        DSLQuery dslQuery = DSLQueryFactoryUtil.select((Table)tempFragmentEntryTable).from(tempFragmentEntryTable).orderBy(tempFragmentEntryTable, orderByComparator).limit(start, end);
        for (Object[] array : (List)this.fragmentEntryPersistence.dslQuery(dslQuery)) {
            long fragmentCompositionId = GetterUtil.getLong((Object)array[0]);
            if (fragmentCompositionId > 0L) {
                fragmentCompositionsAndFragmentEntries.add(this._fragmentCompositionLocalService.fetchFragmentComposition(fragmentCompositionId));
                continue;
            }
            fragmentCompositionsAndFragmentEntries.add(this.fragmentEntryLocalService.fetchFragmentEntry(GetterUtil.getLong((Object)array[1])));
        }
        return fragmentCompositionsAndFragmentEntries;
    }

    public int getFragmentCompositionsAndFragmentEntriesCount(long groupId, long fragmentCollectionId, int status) {
        return this.getFragmentCompositionsAndFragmentEntriesCount(groupId, fragmentCollectionId, null, status);
    }

    public int getFragmentCompositionsAndFragmentEntriesCount(long groupId, long fragmentCollectionId, String name, int status) {
        Table tempFragmentEntryTable = DSLQueryFactoryUtil.countDistinct((Expression)FragmentCompositionTable.INSTANCE.fragmentCompositionId).from((Table)FragmentCompositionTable.INSTANCE).where(() -> {
            Predicate predicate = FragmentCompositionTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)FragmentCompositionTable.INSTANCE.fragmentCollectionId.eq((Object)fragmentCollectionId).and((Expression)FragmentCompositionTable.INSTANCE.status.eq((Object)status)));
            if (Validator.isNotNull((String)name)) {
                return Predicate.withParentheses((Predicate)predicate.and((Expression)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)FragmentCompositionTable.INSTANCE.name), this._customSQL.keywords(name, true))));
            }
            return predicate;
        }).unionAll((DSLQuery)DSLQueryFactoryUtil.countDistinct((Expression)FragmentEntryTable.INSTANCE.fragmentEntryId).from((Table)FragmentEntryTable.INSTANCE).where(() -> {
            Predicate predicate = FragmentEntryTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)FragmentEntryTable.INSTANCE.fragmentCollectionId.eq((Object)fragmentCollectionId).and((Expression)Predicate.withParentheses((Predicate)Predicate.or((Predicate)FragmentEntryTable.INSTANCE.head.eq((Object)true), (Predicate)FragmentEntryTable.INSTANCE.headId.eq((Expression)FragmentEntryTable.INSTANCE.fragmentEntryId)))));
            if (Validator.isNotNull((String)name)) {
                return Predicate.withParentheses((Predicate)predicate.and((Expression)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)FragmentEntryTable.INSTANCE.name), this._customSQL.keywords(name, true))));
            }
            return predicate;
        })).as("tempFragmentCompositionsAndFragmentEntriesTable");
        JoinStep dslQuery = DSLQueryFactoryUtil.select().from(tempFragmentEntryTable);
        int count = 0;
        for (Object countValue : (List)this.fragmentEntryPersistence.dslQuery((DSLQuery)dslQuery)) {
            count += GetterUtil.getInteger(countValue);
        }
        return count;
    }

    public List<FragmentEntry> getFragmentEntries(long fragmentCollectionId) {
        return this.fragmentEntryLocalService.getFragmentEntries(fragmentCollectionId);
    }

    public List<FragmentEntry> getFragmentEntries(long groupId, long fragmentCollectionId, int start, int end) {
        return this.fragmentEntryPersistence.findByG_FCI(groupId, fragmentCollectionId, start, end);
    }

    public List<FragmentEntry> getFragmentEntries(long groupId, long fragmentCollectionId, int start, int end, OrderByComparator<FragmentEntry> orderByComparator) {
        return this.fragmentEntryPersistence.findByG_FCI(groupId, fragmentCollectionId, start, end, orderByComparator);
    }

    public List<FragmentEntry> getFragmentEntriesByName(long groupId, long fragmentCollectionId, String name, int start, int end, OrderByComparator<FragmentEntry> orderByComparator) {
        return this.fragmentEntryPersistence.findByG_FCI_LikeN(groupId, fragmentCollectionId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], start, end, orderByComparator);
    }

    public List<FragmentEntry> getFragmentEntriesByNameAndStatus(long groupId, long fragmentCollectionId, String name, int status, int start, int end, OrderByComparator<FragmentEntry> orderByComparator) {
        if (status == -1) {
            return this.fragmentEntryPersistence.findByG_FCI_LikeN(groupId, fragmentCollectionId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], start, end, orderByComparator);
        }
        return this.fragmentEntryPersistence.findByG_FCI_LikeN_S(groupId, fragmentCollectionId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], status, start, end, orderByComparator);
    }

    public List<FragmentEntry> getFragmentEntriesByStatus(long groupId, long fragmentCollectionId, int status) {
        if (status == -1) {
            return this.fragmentEntryPersistence.findByG_FCI(groupId, fragmentCollectionId);
        }
        return this.fragmentEntryLocalService.getFragmentEntries(groupId, fragmentCollectionId, status);
    }

    public List<FragmentEntry> getFragmentEntriesByStatus(long groupId, long fragmentCollectionId, int status, int start, int end, OrderByComparator<FragmentEntry> orderByComparator) {
        if (status == -1) {
            return this.fragmentEntryPersistence.findByG_FCI(groupId, fragmentCollectionId, start, end, orderByComparator);
        }
        return this.fragmentEntryPersistence.findByG_FCI_S(groupId, fragmentCollectionId, status, start, end, orderByComparator);
    }

    public List<FragmentEntry> getFragmentEntriesByType(long groupId, long fragmentCollectionId, int type, int start, int end, OrderByComparator<FragmentEntry> orderByComparator) {
        return this.fragmentEntryPersistence.findByG_FCI_T(groupId, fragmentCollectionId, type, start, end, orderByComparator);
    }

    public List<FragmentEntry> getFragmentEntriesByTypeAndStatus(long groupId, long fragmentCollectionId, int type, int status) {
        return this.fragmentEntryPersistence.findByG_FCI_T_S(groupId, fragmentCollectionId, type, status);
    }

    public List<FragmentEntry> getFragmentEntriesByTypeAndStatus(long groupId, long fragmentCollectionId, int type, int status, int start, int end, OrderByComparator<FragmentEntry> orderByComparator) {
        if (status == -1) {
            return this.fragmentEntryPersistence.findByG_FCI_T(groupId, fragmentCollectionId, type, start, end, orderByComparator);
        }
        return this.fragmentEntryPersistence.findByG_FCI_T_S(groupId, fragmentCollectionId, type, status, start, end, orderByComparator);
    }

    public int getFragmentEntriesCount(long groupId, long fragmentCollectionId) {
        return this.fragmentEntryPersistence.countByG_FCI(groupId, fragmentCollectionId);
    }

    public int getFragmentEntriesCountByName(long groupId, long fragmentCollectionId, String name) {
        return this.fragmentEntryPersistence.countByG_FCI_LikeN(groupId, fragmentCollectionId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0]);
    }

    public int getFragmentEntriesCountByNameAndStatus(long groupId, long fragmentCollectionId, String name, int status) {
        if (status == -1) {
            return this.fragmentEntryPersistence.countByG_FCI_LikeN(groupId, fragmentCollectionId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0]);
        }
        return this.fragmentEntryPersistence.countByG_FCI_LikeN_S(groupId, fragmentCollectionId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], status);
    }

    public int getFragmentEntriesCountByStatus(long groupId, long fragmentCollectionId, int status) {
        if (status == -1) {
            return this.fragmentEntryPersistence.countByG_FCI(groupId, fragmentCollectionId);
        }
        return this.fragmentEntryPersistence.countByG_FCI_S(groupId, fragmentCollectionId, status);
    }

    public int getFragmentEntriesCountByType(long groupId, long fragmentCollectionId, int type) {
        return this.fragmentEntryPersistence.countByG_FCI_T(groupId, fragmentCollectionId, type);
    }

    public int getFragmentEntriesCountByTypeAndStatus(long groupId, long fragmentCollectionId, int type, int status) {
        if (status == -1) {
            return this.fragmentEntryPersistence.countByG_FCI_T(groupId, fragmentCollectionId, type);
        }
        return this.fragmentEntryPersistence.countByG_FCI_T_S(groupId, fragmentCollectionId, type, status);
    }

    public String[] getTempFileNames(long groupId, String folderName) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.getTempFileNames(this.getUserId(), groupId, folderName);
    }

    public FragmentEntry moveFragmentEntry(long fragmentEntryId, long fragmentCollectionId) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.moveFragmentEntry(fragmentEntryId, fragmentCollectionId);
    }

    public FragmentEntry publishDraft(FragmentEntry draftFragmentEntry) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), draftFragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.publishDraft(draftFragmentEntry);
    }

    public FragmentEntry updateDraft(FragmentEntry draftFragmentEntry) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), draftFragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.updateDraft(draftFragmentEntry);
    }

    public FragmentEntry updateFragmentEntry(FragmentEntry fragmentEntry) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.updateFragmentEntry(fragmentEntry);
    }

    public FragmentEntry updateFragmentEntry(long fragmentEntryId, boolean cacheable) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.updateFragmentEntry(fragmentEntryId, cacheable);
    }

    public FragmentEntry updateFragmentEntry(long fragmentEntryId, long previewFileEntryId) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.updateFragmentEntry(fragmentEntryId, previewFileEntryId);
    }

    public FragmentEntry updateFragmentEntry(long fragmentEntryId, long fragmentCollectionId, String name, String css, String html, String js, boolean cacheable, String configuration, String icon, long previewFileEntryId, int status) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.updateFragmentEntry(this.getUserId(), fragmentEntryId, fragmentCollectionId, name, css, html, js, cacheable, configuration, icon, previewFileEntryId, fragmentEntry.getTypeOptions(), status);
    }

    public FragmentEntry updateFragmentEntry(long fragmentEntryId, long fragmentCollectionId, String name, String css, String html, String js, boolean cacheable, String configuration, String icon, long previewFileEntryId, String typeOptions, int status) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.updateFragmentEntry(this.getUserId(), fragmentEntryId, fragmentCollectionId, name, css, html, js, cacheable, configuration, icon, previewFileEntryId, typeOptions, status);
    }

    public FragmentEntry updateFragmentEntry(long fragmentEntryId, String name) throws PortalException {
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.getFragmentEntry(fragmentEntryId);
        this._portletResourcePermission.check(this.getPermissionChecker(), fragmentEntry.getGroupId(), "MANAGE_FRAGMENT_ENTRIES");
        return this.fragmentEntryLocalService.updateFragmentEntry(fragmentEntryId, name);
    }

    private GroupByStep _getFragmentCompositionGroupByStep(long groupId, long fragmentCollectionId, String name, int status) {
        return DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{FragmentCompositionTable.INSTANCE.fragmentCompositionId, new Scalar((Object)0L).as("fragmentEntryId"), FragmentCompositionTable.INSTANCE.createDate, FragmentCompositionTable.INSTANCE.modifiedDate, FragmentCompositionTable.INSTANCE.name}).from((Table)FragmentCompositionTable.INSTANCE).where(FragmentCompositionTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)FragmentCompositionTable.INSTANCE.fragmentCollectionId.eq((Object)fragmentCollectionId)).and(() -> {
            if (Validator.isNotNull((String)name)) {
                return DSLFunctionFactoryUtil.lower((Expression)FragmentCompositionTable.INSTANCE.name).like(this._customSQL.keywords(name, true, WildcardMode.SURROUND)[0]);
            }
            return null;
        }).and(() -> {
            if (status != -1) {
                return FragmentCompositionTable.INSTANCE.status.eq((Object)status);
            }
            return null;
        }));
    }

    private GroupByStep _getFragmentEntryGroupByStep(long groupId, long fragmentCollectionId, String name, int status) {
        return DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{new Scalar((Object)0L).as("fragmentCompositionId"), FragmentEntryTable.INSTANCE.fragmentEntryId, FragmentEntryTable.INSTANCE.createDate, FragmentEntryTable.INSTANCE.modifiedDate, FragmentEntryTable.INSTANCE.name}).from((Table)FragmentEntryTable.INSTANCE).where(FragmentEntryTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)FragmentEntryTable.INSTANCE.fragmentCollectionId.eq((Object)fragmentCollectionId)).and((Expression)FragmentEntryTable.INSTANCE.head.eq((Object)true).or((Expression)FragmentEntryTable.INSTANCE.headId.eq((Expression)FragmentEntryTable.INSTANCE.fragmentEntryId)).withParentheses()).and(() -> {
            if (Validator.isNotNull((String)name)) {
                return DSLFunctionFactoryUtil.lower((Expression)FragmentEntryTable.INSTANCE.name).like(this._customSQL.keywords(name, true, WildcardMode.SURROUND)[0]);
            }
            return null;
        }).and(() -> {
            if (status != -1) {
                return FragmentEntryTable.INSTANCE.status.eq((Object)status);
            }
            return null;
        }));
    }
}

