/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.friendly.url.internal.upgrade.v3_1_1;

import com.liferay.friendly.url.model.FriendlyURLEntryLocalization;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class FriendlyURLEntryLocalizationUpgradeProcess
extends UpgradeProcess {
    private static final long _CLASS_NAME_ID = PortalUtil.getClassNameId((String)"com.liferay.journal.model.JournalArticle");
    private static final Log _log = LogFactoryUtil.getLog(FriendlyURLEntryLocalizationUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        this._addMissingFriendlyURLEntryLocalizations();
    }

    private void _addMissingFriendlyURLEntryLocalization(long ctCollectionId, long companyId, long friendlyURLEntryId, String languageId, String urlTitle, long groupId, long classPK) throws Exception {
        block14: {
            long friendlyURLEntryLocalizationId = this.increment(FriendlyURLEntryLocalization.class.getName());
            String uniqueURLTitle = this._getUniqueURLTitle(ctCollectionId, urlTitle, groupId);
            StringBundler sb = new StringBundler(5);
            sb.append("insert into FriendlyURLEntryLocalization (mvccVersion, ");
            sb.append("ctCollectionId, friendlyURLEntryLocalizationId, ");
            sb.append("companyId, friendlyURLEntryId, languageId, urlTitle, ");
            sb.append("groupId, classNameId, classPK) values (?, ?, ?, ?, ?, ?, ");
            sb.append("?, ?, ?, ?)");
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(sb.toString());){
                preparedStatement.setLong(1, 0L);
                preparedStatement.setLong(2, ctCollectionId);
                preparedStatement.setLong(3, friendlyURLEntryLocalizationId);
                preparedStatement.setLong(4, companyId);
                preparedStatement.setLong(5, friendlyURLEntryId);
                preparedStatement.setString(6, languageId);
                preparedStatement.setString(7, uniqueURLTitle);
                preparedStatement.setLong(8, groupId);
                preparedStatement.setLong(9, _CLASS_NAME_ID);
                preparedStatement.setLong(10, classPK);
                preparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Object)"Unable to add friendly url entry localization", (Throwable)exception);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void _addMissingFriendlyURLEntryLocalizations() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long _getFriendlyURLEntryCTCollectionId(long friendlyURLEntryId) throws SQLException {
        StringBundler sb = new StringBundler(3);
        sb.append("select ctCollectionId from FriendlyURLEntry where ");
        sb.append("friendlyURLEntryId = ");
        sb.append(friendlyURLEntryId);
        try (Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery(sb.toString());){
            if (resultSet.next()) {
                long l = resultSet.getLong(1);
                return l;
            }
        }
        return -1L;
    }

    private long _getFriendlyURLEntryId(long resourcePrimKey) throws SQLException {
        StringBundler sb = new StringBundler(5);
        sb.append("select friendlyURLEntryId from FriendlyURLEntryMapping ");
        sb.append("where classNameId = ");
        sb.append(_CLASS_NAME_ID);
        sb.append(" and classPK = ");
        sb.append(resourcePrimKey);
        try (Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery(sb.toString());){
            if (resultSet.next()) {
                long l = resultSet.getLong(1);
                return l;
            }
        }
        return -1L;
    }

    private int _getFriendlyURLEntryLocalizationsCount(long ctCollectionId, String urlTitle, long groupId) throws Exception {
        int count = 0;
        StringBundler sb = new StringBundler(9);
        sb.append("select count(*) from FriendlyURLEntryLocalization where ");
        sb.append("ctCollectionId = ");
        sb.append(ctCollectionId);
        sb.append(" and urlTitle = '");
        sb.append(urlTitle);
        sb.append("' and groupId = ");
        sb.append(groupId);
        sb.append(" and classNameId = ");
        sb.append(_CLASS_NAME_ID);
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sb.toString());
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                count = resultSet.getInt(1);
            }
        }
        return count;
    }

    private String _getUniqueURLTitle(long ctCollectionId, String urlTitle, long groupId) throws Exception {
        int count;
        String curUrlTitle;
        String normalizedUrlTitle = FriendlyURLNormalizerUtil.normalizeWithEncoding((String)urlTitle);
        int maxLength = 255;
        String prefix = curUrlTitle = this._getURLEncodedSubstring(urlTitle, normalizedUrlTitle, maxLength);
        int i = 1;
        while ((count = this._getFriendlyURLEntryLocalizationsCount(ctCollectionId, curUrlTitle, groupId)) != 0) {
            String suffix = "-" + i;
            prefix = this._getURLEncodedSubstring(urlTitle, prefix, maxLength - suffix.length());
            curUrlTitle = FriendlyURLNormalizerUtil.normalizeWithEncoding((String)(prefix + suffix));
            ++i;
        }
        return curUrlTitle;
    }

    private String _getURLEncodedSubstring(String decodedString, String encodedString, int maxLength) {
        int endPos = decodedString.length();
        while (encodedString.length() > maxLength) {
            if (--endPos > 0 && Character.isHighSurrogate(decodedString.charAt(endPos - 1))) {
                --endPos;
            }
            encodedString = FriendlyURLNormalizerUtil.normalizeWithEncoding((String)decodedString.substring(0, endPos));
        }
        return encodedString;
    }

    private Map<String, String> _sortUrlTitleMap(long groupId, Map<String, String> urlTitleMap) {
        LinkedHashMap<String, String> sortedUrlTitleMap = new LinkedHashMap<String, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales((long)groupId)) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String value = urlTitleMap.get(languageId);
            if (value == null) continue;
            sortedUrlTitleMap.put(languageId, value);
        }
        return sortedUrlTitleMap;
    }
}

