/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.friendly.url.web.internal.servlet;

import com.liferay.friendly.url.info.item.provider.InfoItemFriendlyURLProvider;
import com.liferay.friendly.url.info.item.updater.InfoItemFriendlyURLUpdater;
import com.liferay.friendly.url.model.FriendlyURLEntryLocalization;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.info.item.provider.InfoItemPermissionProvider;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONSerializable;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.translation.info.item.provider.InfoItemLanguagesProvider;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.http.whiteboard.servlet.name=com.liferay.friendly.url.web.internal.servlet.FriendlyURLServlet", "osgi.http.whiteboard.servlet.pattern=/friendly-url/*", "servlet.init.httpMethods=DELETE,GET,HEAD,POST"}, service={Servlet.class})
public class FriendlyURLServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(FriendlyURLServlet.class);
    private static final InfoItemLanguagesProvider<Object> _defaultInfoItemLanguagesProvider = new InfoItemLanguagesProvider<Object>(){

        public String[] getAvailableLanguageIds(Object object) throws PortalException {
            return new String[]{this.getDefaultLanguageId(object)};
        }

        public String getDefaultLanguageId(Object object) {
            return LanguageUtil.getLanguageId((Locale)LocaleUtil.getSiteDefault());
        }
    };
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    @Reference
    private Portal _portal;

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            String className = this._getClassName(httpServletRequest);
            InfoItemPermissionProvider infoItemPermissionProvider = (InfoItemPermissionProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemPermissionProvider.class, className);
            if (!infoItemPermissionProvider.hasPermission(this._permissionCheckerFactory.create(this._portal.getUser(httpServletRequest)), new InfoItemReference(className, this._getClassPK(httpServletRequest)), "UPDATE")) {
                this._writeJSON(httpServletResponse, JSONUtil.put((String)"success", (Object)false));
            } else {
                this._friendlyURLEntryLocalService.deleteFriendlyURLLocalizationEntry(this._getEntryId(httpServletRequest), this._getLanguageId(httpServletRequest));
                this._writeJSON(httpServletResponse, JSONUtil.put((String)"success", (Object)true));
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            this._writeJSON(httpServletResponse, JSONUtil.put((String)"success", (Object)false));
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            User user = this._portal.getUser(httpServletRequest);
            if (user == null || user.isDefaultUser()) {
                this._writeJSON(httpServletResponse, JSONUtil.put((String)"success", (Object)false));
            } else {
                String className = this._getClassName(httpServletRequest);
                long classPK = this._getClassPK(httpServletRequest);
                InfoItemPermissionProvider infoItemPermissionProvider = (InfoItemPermissionProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemPermissionProvider.class, className);
                if (!infoItemPermissionProvider.hasPermission(this._permissionCheckerFactory.create(this._portal.getUser(httpServletRequest)), new InfoItemReference(className, classPK), "VIEW")) {
                    this._writeJSON(httpServletResponse, JSONUtil.put((String)"success", (Object)false));
                } else {
                    this._writeJSON(httpServletResponse, this._getFriendlyURLEntryLocalizationsJSONObject(className, classPK));
                }
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            this._writeJSON(httpServletResponse, JSONUtil.put((String)"success", (Object)false));
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            String className = this._getClassName(httpServletRequest);
            long classPK = this._getClassPK(httpServletRequest);
            InfoItemPermissionProvider infoItemPermissionProvider = (InfoItemPermissionProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemPermissionProvider.class, className);
            if (!infoItemPermissionProvider.hasPermission(this._permissionCheckerFactory.create(this._portal.getUser(httpServletRequest)), new InfoItemReference(className, classPK), "UPDATE")) {
                this._writeJSON(httpServletResponse, JSONUtil.put((String)"success", (Object)false));
            } else {
                InfoItemFriendlyURLUpdater infoItemFriendlyURLUpdater = (InfoItemFriendlyURLUpdater)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemFriendlyURLUpdater.class, className);
                infoItemFriendlyURLUpdater.restoreFriendlyURL(this._portal.getUserId(httpServletRequest), classPK, this._getEntryId(httpServletRequest), this._getLanguageId(httpServletRequest));
                this._writeJSON(httpServletResponse, JSONUtil.put((String)"success", (Object)true));
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            this._writeJSON(httpServletResponse, JSONUtil.put((String)"success", (Object)false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        ServiceContext serviceContext = this._getServiceContext(httpServletRequest);
        try {
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            super.service(httpServletRequest, httpServletResponse);
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }

    private String _getClassName(HttpServletRequest httpServletRequest) throws PortalException {
        List parts = StringUtil.split((String)httpServletRequest.getPathInfo(), (char)'/');
        return (String)parts.get(1);
    }

    private long _getClassPK(HttpServletRequest httpServletRequest) {
        List parts = StringUtil.split((String)httpServletRequest.getPathInfo(), (char)'/');
        return GetterUtil.getLong((String)((String)parts.get(2)));
    }

    private long _getEntryId(HttpServletRequest httpServletRequest) {
        List parts = StringUtil.split((String)httpServletRequest.getPathInfo(), (char)'/');
        return GetterUtil.getLong((String)((String)parts.get(3)));
    }

    private JSONObject _getFriendlyURLEntryLocalizationsJSONObject(String className, long classPK) throws Exception {
        JSONObject friendlyURLEntryLocalizationsJSONObject = JSONFactoryUtil.createJSONObject();
        InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemObjectProvider.class, className);
        Object object = infoItemObjectProvider.getInfoItem(classPK);
        InfoItemFriendlyURLProvider infoItemFriendlyURLProvider = (InfoItemFriendlyURLProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemFriendlyURLProvider.class, className);
        InfoItemLanguagesProvider<Object> infoItemLanguagesProvider = Optional.ofNullable(this._infoItemServiceTracker.getFirstInfoItemService(InfoItemLanguagesProvider.class, className)).orElse(_defaultInfoItemLanguagesProvider);
        for (String languageId : infoItemLanguagesProvider.getAvailableLanguageIds(object)) {
            List friendlyURLEntryLocalizations = infoItemFriendlyURLProvider.getFriendlyURLEntryLocalizations(object, languageId);
            String mainUrlTitle = infoItemFriendlyURLProvider.getFriendlyURL(object, languageId);
            friendlyURLEntryLocalizationsJSONObject.put(languageId, JSONUtil.put((String)"current", (Object)JSONUtil.put((String)"urlTitle", (Object)mainUrlTitle)).put("history", this._getJSONArray(ListUtil.filter((List)friendlyURLEntryLocalizations, friendlyURLEntryLocalization -> !Objects.equals(friendlyURLEntryLocalization.getUrlTitle(), mainUrlTitle)), this::_serializeFriendlyURLEntryLocalization)).put("success", true));
        }
        return friendlyURLEntryLocalizationsJSONObject;
    }

    private <T> JSONArray _getJSONArray(List<T> list, Function<T, JSONSerializable> serialize) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        list.forEach(t -> jsonArray.put(serialize.apply(t)));
        return jsonArray;
    }

    private String _getLanguageId(HttpServletRequest httpServletRequest) {
        List parts = StringUtil.split((String)httpServletRequest.getPathInfo(), (char)'/');
        return (String)parts.get(4);
    }

    private ServiceContext _getServiceContext(HttpServletRequest httpServletRequest) throws ServletException {
        try {
            ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
            List parts = StringUtil.split((String)httpServletRequest.getPathInfo(), (char)'/');
            serviceContext.setScopeGroupId(GetterUtil.getLong((String)((String)parts.get(0))));
            return serviceContext;
        }
        catch (PortalException portalException) {
            throw new ServletException((Throwable)portalException);
        }
    }

    private JSONObject _serializeFriendlyURLEntryLocalization(FriendlyURLEntryLocalization friendlyEntryLocalization) {
        if (friendlyEntryLocalization == null) {
            return null;
        }
        return JSONUtil.put((String)"friendlyURLEntryId", (Object)friendlyEntryLocalization.getFriendlyURLEntryId()).put("friendlyURLEntryLocalizationId", (Object)friendlyEntryLocalization.getFriendlyURLEntryLocalizationId()).put("urlTitle", friendlyEntryLocalization.getUrlTitle());
    }

    private void _writeJSON(HttpServletResponse httpServletResponse, JSONObject jsonObject) throws IOException {
        httpServletResponse.setContentType("application/json");
        if (jsonObject.has("success") && !jsonObject.getBoolean("success")) {
            httpServletResponse.setStatus(400);
        }
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        servletOutputStream.print(jsonObject.toString());
    }
}

