/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

import classNames from 'classnames';
import React, {useContext, useLayoutEffect, useRef} from 'react';

import TableContext from './TableContext';

function Table({children, className}) {
	const {draggingColumnName, isFixed, updateTableWidth} = useContext(
		TableContext
	);
	const dndTableRef = useRef(null);

	useLayoutEffect(() => {
		const tableWidth = dndTableRef.current.getBoundingClientRect().width;
		updateTableWidth(tableWidth);
	}, [updateTableWidth]);

	return (
		<div
			className={classNames(
				'dnd-table',
				{
					'fixed': isFixed,
					'is-dragging': draggingColumnName !== null,
				},
				className
			)}
			ref={dndTableRef}
		>
			{children}
		</div>
	);
}

export default Table;
