/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.editor.ckeditor.web.internal.editor.configuration;

import com.liferay.frontend.editor.ckeditor.web.internal.editor.configuration.BaseCKEditorConfigContributor;
import com.liferay.portal.kernel.editor.configuration.EditorConfigContributor;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(property={"editor.name=ckeditor_bbcode"}, service={EditorConfigContributor.class})
public class CKEditorBBCodeConfigContributor
extends BaseCKEditorConfigContributor {
    @Override
    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        super.populateConfigJSONObject(jsonObject, inputEditorTaglibAttributes, themeDisplay, requestBackedPortletURLFactory);
        jsonObject.put("allowedContent", (Object)Boolean.TRUE);
        jsonObject.put("enterMode", 2);
        jsonObject.put("extraPlugins", "a11yhelpbtn,bbcode,itemselector,wikilink");
        jsonObject.put("fontSize_defaultLabel", "14");
        jsonObject.put("fontSize_sizes", "10/10px;12/12px;14/14px;16/16px;18/18px;24/24px;32/32px;48/48px");
        jsonObject.put("format_tags", "p;pre");
        jsonObject.put("imagesPath", HtmlUtil.escape((String)themeDisplay.getPathThemeImages()) + "/message_boards/");
        jsonObject.put("lang", this.getLangJSONObject(inputEditorTaglibAttributes));
        jsonObject.put("newThreadURL", "${newThreadURL}");
        jsonObject.put("removePlugins", "bidi,div,elementspath,flash,forms,indentblock,keystrokes,link,maximize,newpage,pagebreak,preview,print,save,showblocks,templates,video");
        jsonObject.put("smiley_descriptions", this.toJSONArray(BBCodeTranslatorUtil.getEmoticonDescriptions()));
        jsonObject.put("smiley_images", this.toJSONArray(BBCodeTranslatorUtil.getEmoticonFiles()));
        jsonObject.put("smiley_path", HtmlUtil.escape((String)themeDisplay.getPathThemeImages()) + "/emoticons/");
        jsonObject.put("smiley_symbols", this.toJSONArray(BBCodeTranslatorUtil.getEmoticonSymbols()));
        jsonObject.put("toolbar_bbcode", this.getToolbarsBBCodeJSONArray(inputEditorTaglibAttributes));
        jsonObject.put("toolbar_phone", this.getToolbarsPhoneJSONArray(inputEditorTaglibAttributes));
        jsonObject.put("toolbar_tablet", this.getToolbarsTabletJSONArray(inputEditorTaglibAttributes));
    }

    protected JSONObject getLangJSONObject(Map<String, Object> inputEditorTaglibAttributes) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("code", LanguageUtil.get((Locale)this.getContentsLocale(inputEditorTaglibAttributes), (String)"code"));
        return jsonObject;
    }

    protected JSONArray getToolbarsBBCodeJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this.toJSONArray("['Bold', 'Italic', 'Underline', 'Strike']"));
        jsonArray.put(this.toJSONArray("['TextColor']"));
        jsonArray.put(this.toJSONArray("['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock']"));
        jsonArray.put(this.toJSONArray("['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'Blockquote', '-', 'Code']"));
        jsonArray.put("/");
        jsonArray.put(this.toJSONArray("['Format', 'Font', 'FontSize']"));
        jsonArray.put(this.toJSONArray("['Link', 'Unlink']"));
        jsonArray.put(this.toJSONArray("['ImageSelector', '-', 'Smiley']"));
        jsonArray.put("/");
        jsonArray.put(this.toJSONArray("['Cut', 'Copy', 'Paste', '-', 'SelectAll', '-', 'Undo', 'Redo']"));
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            jsonArray.put(this.toJSONArray("['Source']"));
        }
        jsonArray.put(this.toJSONArray("['A11YBtn']"));
        return jsonArray;
    }

    protected JSONArray getToolbarsPhoneJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this.toJSONArray("['Bold', 'Italic', 'Underline']"));
        jsonArray.put(this.toJSONArray("['NumberedList', 'BulletedList']"));
        jsonArray.put(this.toJSONArray("['Link', 'Unlink']"));
        jsonArray.put(this.toJSONArray("['ImageSelector']"));
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            jsonArray.put(this.toJSONArray("['Source']"));
        }
        return jsonArray;
    }

    protected JSONArray getToolbarsTabletJSONArray(Map<String, Object> inputEditorTaglibAttributes) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        jsonArray.put(this.toJSONArray("['Bold', 'Italic', 'Underline', 'Strike']"));
        jsonArray.put(this.toJSONArray("['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock']"));
        jsonArray.put(this.toJSONArray("['NumberedList', 'BulletedList']"));
        jsonArray.put(this.toJSONArray("['Styles', 'FontSize']"));
        jsonArray.put(this.toJSONArray("['Link', 'Unlink']"));
        jsonArray.put(this.toJSONArray("['ImageSelector']"));
        if (this.isShowSource(inputEditorTaglibAttributes)) {
            jsonArray.put(this.toJSONArray("['Source']"));
        }
        return jsonArray;
    }
}

