/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
(function () {
  var IE9AndLater = AUI.Env.UA.ie >= 9;
  var STR_FILE_ENTRY_RETURN_TYPE = 'com.liferay.item.selector.criteria.FileEntryItemSelectorReturnType';
  var TPL_AUDIO_SCRIPT = 'boundingBox: "#" + mediaId,' + 'oggUrl: "{oggUrl}",' + 'url: "{url}"';
  var TPL_VIDEO_SCRIPT = 'boundingBox: "#" + mediaId,' + 'height: {height},' + 'ogvUrl: "{ogvUrl}",' + 'poster: "{poster}",' + 'url: "{url}",' + 'width: {width}';
  var defaultVideoHeight = 300;
  var defaultVideoWidth = 400;
  CKEDITOR.plugins.add('itemselector', {
    _bindBrowseButton: function _bindBrowseButton(editor, dialogDefinition, tabName, commandName, targetField) {
      var tab = dialogDefinition.getContents(tabName);

      if (tab) {
        var browseButton = tab.get('browse');

        if (browseButton) {
          browseButton.onClick = function () {
            editor.execCommand(commandName, function (newVal) {
              dialogDefinition.dialog.setValueOf(tabName, targetField, newVal);
            });
          };
        }
      }
    },
    _commitAudioValue: function _commitAudioValue(value, node) {
      var instance = this;
      node.setAttribute('data-document-url', value);
      var audioUrl = Liferay.Util.addParams('audioPreview=1&type=mp3', value);
      node.setAttribute('data-audio-url', audioUrl);
      var audioOggUrl = Liferay.Util.addParams('audioPreview=1&type=ogg', value);
      node.setAttribute('data-audio-ogg-url', audioOggUrl);
      return instance._audioTPL.output({
        oggUrl: audioOggUrl,
        url: audioUrl
      });
    },
    _commitMediaValue: function _commitMediaValue(value, editor, type) {
      var instance = this;
      var mediaPlugin = editor.plugins.media;

      if (mediaPlugin) {
        mediaPlugin.onOkCallback({
          commitContent: instance._getCommitMediaValueFn(value, editor, type)
        }, editor, type);
      }
    },
    _commitVideoValue: function _commitVideoValue(value, node, extraStyles) {
      var instance = this;
      node.setAttribute('data-document-url', value);
      var videoUrl = Liferay.Util.addParams('videoPreview=1&type=mp4', value);
      node.setAttribute('data-video-url', videoUrl);
      var videoOgvUrl = Liferay.Util.addParams('videoPreview=1&type=ogv', value);
      node.setAttribute('data-video-ogv-url', videoOgvUrl);
      var videoHeight = defaultVideoHeight;
      node.setAttribute('data-height', videoHeight);
      var videoWidth = defaultVideoWidth;
      node.setAttribute('data-width', videoWidth);
      var poster = Liferay.Util.addParams('videoThumbnail=1', value);
      node.setAttribute('data-poster', poster);
      extraStyles.backgroundImage = 'url(' + poster + ')';
      extraStyles.height = videoHeight + 'px';
      extraStyles.width = videoWidth + 'px';
      return instance._videoTPL.output({
        height: videoHeight,
        ogvUrl: videoOgvUrl,
        poster: poster,
        url: videoUrl,
        width: videoWidth
      });
    },
    _getCommitMediaValueFn: function _getCommitMediaValueFn(value, editor, type) {
      var instance = this;

      var commitValueFn = function commitValueFn(node, extraStyles) {
        var mediaScript;

        if (type === 'audio') {
          mediaScript = instance._commitAudioValue(value, node, extraStyles);
        } else if (type === 'video') {
          mediaScript = instance._commitVideoValue(value, node, extraStyles);
        }

        var mediaPlugin = editor.plugins.media;

        if (mediaPlugin) {
          mediaPlugin.applyMediaScript(node, type, mediaScript);
        }
      };

      return commitValueFn;
    },
    _getItemSrc: function _getItemSrc(editor, selectedItem) {
      var itemSrc = selectedItem.value;

      if (selectedItem.returnType === STR_FILE_ENTRY_RETURN_TYPE) {
        try {
          var itemValue = JSON.parse(selectedItem.value);
          itemSrc = editor.config.attachmentURLPrefix ? editor.config.attachmentURLPrefix + encodeURIComponent(itemValue.title) : itemValue.url;
        } catch (e) {}
      }

      return itemSrc;
    },
    _isEmptySelection: function _isEmptySelection(editor) {
      var selection = editor.getSelection();
      var ranges = selection.getRanges();
      return selection.getType() === CKEDITOR.SELECTION_NONE || ranges.length === 1 && (ranges[0].collapsed || IE9AndLater);
    },
    _onSelectedAudioChange: function _onSelectedAudioChange(editor, callback, selectedItem) {
      var instance = this;

      if (selectedItem) {
        var audioSrc = instance._getItemSrc(editor, selectedItem);

        if (audioSrc) {
          if (typeof callback === 'function') {
            callback(audioSrc);
          } else {
            instance._commitMediaValue(audioSrc, editor, 'audio');
          }
        }
      }
    },
    _onSelectedImageChange: function _onSelectedImageChange(editor, callback, selectedItem) {
      var instance = this;

      if (selectedItem) {
        var imageSrc = instance._getItemSrc(editor, selectedItem);

        if (imageSrc) {
          if (typeof callback === 'function') {
            callback(imageSrc, selectedItem);
          } else {
            var imageElement = new CKEDITOR.dom.element.createFromHtml('<img src="' + imageSrc + '">');
            editor.insertElement(imageElement);

            if (IE9AndLater) {
              if (!editor.window.$.AlloyEditor) {
                editor.insertHtml('&nbsp;');
              }

              var element = new CKEDITOR.dom.element('br');
              editor.insertElement(element);
              editor.getSelection();
              editor.fire('editorInteraction', {
                nativeEvent: {},
                selectionData: {
                  element: element,
                  region: element.getClientRect()
                }
              });
            } else {
              editor.execCommand('enter');
            }

            editor.focus();
          }
        }
      }
    },
    _onSelectedLinkChange: function _onSelectedLinkChange(editor, callback, selectedItem) {
      if (selectedItem) {
        var linkUrl = selectedItem.value;

        if (typeof callback === 'function') {
          callback(linkUrl, selectedItem);
        }
      }
    },
    _onSelectedVideoChange: function _onSelectedVideoChange(editor, callback, selectedItem) {
      var instance = this;

      if (selectedItem) {
        var videoSrc = instance._getItemSrc(editor, selectedItem);

        if (videoSrc) {
          if (typeof callback === 'function') {
            callback(videoSrc);
          } else {
            instance._commitMediaValue(videoSrc, editor, 'video');
          }
        }
      }
    },
    _openSelectionModal: function _openSelectionModal(editor, url, callback) {
      Liferay.Util.openSelectionModal({
        onSelect: callback,
        selectEventName: editor.name + 'selectItem',
        title: Liferay.Language.get('select-item'),
        url: url,
        zIndex: CKEDITOR.getNextZIndex()
      });
    },
    init: function init(editor) {
      var instance = this;
      instance._audioTPL = new CKEDITOR.template(TPL_AUDIO_SCRIPT);
      instance._videoTPL = new CKEDITOR.template(TPL_VIDEO_SCRIPT);
      editor.addCommand('audioselector', {
        canUndo: false,
        exec: function exec(editor, callback) {
          var onSelectedAudioChangeFn = AUI().bind('_onSelectedAudioChange', instance, editor, callback);

          instance._openSelectionModal(editor, editor.config.filebrowserAudioBrowseUrl, onSelectedAudioChangeFn);
        }
      });
      editor.addCommand('imageselector', {
        canUndo: false,
        exec: function exec(editor, callback) {
          var onSelectedImageChangeFn = AUI().bind('_onSelectedImageChange', instance, editor, callback);

          instance._openSelectionModal(editor, editor.config.filebrowserImageBrowseUrl, onSelectedImageChangeFn);
        }
      });
      editor.addCommand('linkselector', {
        canUndo: false,
        exec: function exec(editor, callback) {
          var onSelectedLinkChangeFn = AUI().bind('_onSelectedLinkChange', instance, editor, callback);

          instance._openSelectionModal(editor, editor.config.filebrowserBrowseUrl, onSelectedLinkChangeFn);
        }
      });
      editor.addCommand('videoselector', {
        canUndo: false,
        exec: function exec(editor, callback) {
          var onSelectedVideoChangeFn = AUI().bind('_onSelectedVideoChange', instance, editor, callback);

          instance._openSelectionModal(editor, editor.config.filebrowserVideoBrowseUrl, onSelectedVideoChangeFn);
        }
      });

      if (editor.ui.addButton) {
        editor.ui.addButton('ImageSelector', {
          command: 'imageselector',
          icon: instance.path + 'assets/image.png',
          label: editor.lang.common.image
        });
        editor.ui.addButton('AudioSelector', {
          command: 'audioselector',
          icon: instance.path + 'assets/audio.png',
          label: Liferay.Language.get('audio')
        });
        editor.ui.addButton('VideoSelector', {
          command: 'videoselector',
          icon: instance.path + 'assets/video.png',
          label: Liferay.Language.get('video')
        });
      }

      CKEDITOR.on('dialogDefinition', function (event) {
        var dialogName = event.data.name;
        var dialogDefinition = event.data.definition;

        if (dialogName === 'audio') {
          instance._bindBrowseButton(event.editor, dialogDefinition, 'info', 'audioselector', 'url');
        } else if (dialogName === 'image') {
          instance._bindBrowseButton(event.editor, dialogDefinition, 'Link', 'linkselector', 'txtUrl');

          dialogDefinition.getContents('info').remove('browse');

          dialogDefinition.onLoad = function () {
            this.getContentElement('info', 'txtUrl').getInputElement().setAttribute('readOnly', true);
          };
        } else if (dialogName === 'image2') {
          instance._bindBrowseButton(event.editor, dialogDefinition, 'info', 'imageselector', 'txtUrl');
        } else if (dialogName === 'video') {
          instance._bindBrowseButton(event.editor, dialogDefinition, 'info', 'videoselector', 'poster');
        } else if (dialogName === 'link') {
          instance._bindBrowseButton(event.editor, dialogDefinition, 'info', 'linkselector', 'url');
        }
      });
    }
  });
})();
//# sourceMappingURL=plugin.js.map