function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
(function () {
  var IMAGE_HANDLES = ['tl', 'tr', 'bl', 'br'];

  var positionElement = function positionElement(el, left, top) {
    el.style.left = "".concat(left, "px");
    el.style.top = "".concat(top, "px");
  };

  var POSITION_ELEMENT_FN = {
    bl: function bl(handle, left, top, box) {
      positionElement(handle, -3 + left, box.height - 4 + top);
    },
    br: function br(handle, left, top, box) {
      positionElement(handle, box.width - 4 + left, box.height - 4 + top);
    },
    rm: function rm(handle, left, top, box) {
      positionElement(handle, box.width - 4 + left, Math.round(box.height / 2) - 3 + top);
    },
    tl: function tl(handle, left, top, _box) {
      positionElement(handle, left - 3, top - 3);
    },
    tr: function tr(handle, left, top, box) {
      positionElement(handle, box.width - 4 + left, -3 + top);
    }
  };

  var getBoundingBox = function getBoundingBox(window, el) {
    var rect = el.getBoundingClientRect();
    return {
      height: rect.height,
      left: rect.left + window.pageXOffset,
      top: rect.top + window.pageYOffset,
      width: rect.width
    };
  };

  var Resizer = /*#__PURE__*/function () {
    function Resizer(editor) {
      var cfg = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      _classCallCheck(this, Resizer);

      this.cfg = cfg;
      this.editor = editor;
      this.document = editor.document ? editor.document.$ : document;
      this.window = editor.window ? editor.window.$ : window;
      this.box = null;
      this.container = null;
      this.handles = {};
      this.preview = null;
      this.previewBox = null;
      this.result = null;
      this.init();
    }

    _createClass(Resizer, [{
      key: "init",
      value: function init() {
        var _this = this;

        this.container = this.document.createElement('div');
        this.container.id = 'ckimgrsz';
        this.preview = this.document.createElement('span');
        this.container.appendChild(this.preview);
        this.handles = {};
        IMAGE_HANDLES.forEach(function (handleName) {
          _this.handles[handleName] = _this.createHandle(handleName);
        });
        var keys = Object.keys(this.handles);

        for (var i = 0; i < keys.length; i++) {
          this.container.appendChild(this.handles[keys[i]]);
        }
      }
    }, {
      key: "createHandle",
      value: function createHandle(name) {
        var el = this.document.createElement('i');
        el.classList.add(name);
        return el;
      }
    }, {
      key: "isHandle",
      value: function isHandle(el) {
        var keys = Object.keys(this.handles);
        var result = false;

        for (var i = 0; i < keys.length; i++) {
          if (this.handles[keys[i]] === el) {
            result = true;
          }
        }

        return result;
      }
    }, {
      key: "show",
      value: function show(el) {
        var uiNode = this.editor.config.uiNode || this.document.body;
        this.el = el;
        this.box = getBoundingBox(this.window, this.el);
        positionElement(this.container, this.box.left, this.box.top + uiNode.scrollTop);
        uiNode.appendChild(this.container);
        this.el.classList.add('ckimgrsz');
        this.showHandles();
      }
    }, {
      key: "hide",
      value: function hide() {
        var elements = this.document.getElementsByClassName('ckimgrsz');

        for (var i = 0; i < elements.length; i++) {
          elements[i].classList.remove('ckimgrsz');
        }

        this.hideHandles();

        if (this.container.parentNode) {
          this.container.parentNode.removeChild(this.container);
        }
      }
    }, {
      key: "initDrag",
      value: function initDrag(event) {
        var _this2 = this;

        if (event.button !== 0) {
          return;
        }

        var drag = new Liferay.DragEventCKEditor(this.document);

        drag.onStart = function () {
          _this2.showPreview();

          _this2.isDragging = true;

          _this2.editor.getSelection().lock();
        };

        drag.onDrag = function () {
          _this2.calculateSize(drag);

          var body = _this2.editor.document.getBody();

          var editorBounds = body.$.getBoundingClientRect();

          if (_this2.previewBox.width >= editorBounds.width) {
            return;
          }

          _this2.updatePreview();

          var box = _this2.previewBox;

          _this2.updateHandles(box, box.left, box.top);
        };

        drag.onRelease = function () {
          _this2.hidePreview();

          _this2.isDragging = false;

          _this2.hide();

          _this2.editor.getSelection().unlock();
        };

        drag.onComplete = function () {
          _this2.resizeComplete();

          _this2.editor.fire('saveSnapshot');
        };

        drag.start(event);
      }
    }, {
      key: "updateHandles",
      value: function updateHandles(box) {
        var left = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
        var top = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
        var keys = Object.keys(this.handles);

        for (var i = 0; i < keys.length; i++) {
          POSITION_ELEMENT_FN[keys[i]](this.handles[keys[i]], left, top, box);
        }
      }
    }, {
      key: "showHandles",
      value: function showHandles() {
        this.updateHandles(this.box);
        var keys = Object.keys(this.handles);

        for (var i = 0; i < keys.length; i++) {
          this.handles[keys[i]].style.display = 'block';
        }
      }
    }, {
      key: "hideHandles",
      value: function hideHandles() {
        var keys = Object.keys(this.handles);

        for (var i = 0; i < keys.length; i++) {
          this.handles[keys[i]].style.display = 'none';
        }
      }
    }, {
      key: "showPreview",
      value: function showPreview() {
        this.calculateSize();
        this.updatePreview();
        this.preview.style.display = 'block';
      }
    }, {
      key: "updatePreview",
      value: function updatePreview() {
        positionElement(this.preview, this.previewBox.left, this.previewBox.top);
        this.preview.style.height = "".concat(this.previewBox.height, "px");
        this.preview.style.width = "".concat(this.previewBox.width, "px");
      }
    }, {
      key: "hidePreview",
      value: function hidePreview() {
        var box = getBoundingBox(this.window, this.preview);
        this.result = {
          height: Math.round(box.height),
          width: Math.round(box.width)
        };
        this.preview.style.display = 'none';
      }
    }, {
      key: "calculateSize",
      value: function calculateSize(data) {
        this.previewBox = {
          height: this.box.height,
          left: 0,
          top: 0,
          width: this.box.width
        };

        if (!data) {
          return;
        }

        var className = data.target.className;

        if (className.indexOf('r') >= 0) {
          this.previewBox.width = Math.max(32, this.box.width + data.delta.x);
        }

        if (className.indexOf('b') >= 0) {
          this.previewBox.height = Math.max(32, this.box.height + data.delta.y);
        }

        if (className.indexOf('l') >= 0) {
          this.previewBox.width = Math.max(32, this.box.width - data.delta.x);
        }

        if (className.indexOf('t') >= 0) {
          this.previewBox.height = Math.max(32, this.box.height - data.delta.y);
        }

        if (className.indexOf('m') < 0 && !data.keys.shift) {
          var ratio = this.box.width / this.box.height;

          if (this.previewBox.width / this.previewBox.height > ratio) {
            this.previewBox.height = Math.round(this.previewBox.width / ratio);
          } else {
            this.previewBox.width = Math.round(this.previewBox.height * ratio);
          }
        }

        if (className.indexOf('l') >= 0) {
          this.previewBox.left = this.box.width - this.previewBox.width;
        }

        if (className.indexOf('t') >= 0) {
          this.previewBox.top = this.box.height - this.previewBox.height;
        }
      }
    }, {
      key: "resizeComplete",
      value: function resizeComplete() {
        this.cfg.onComplete(this.el, this.result.width, this.result.height);
      }
    }]);

    return Resizer;
  }();

  Liferay.ResizerCKEditor = Resizer;
})();
//# sourceMappingURL=Resizer.es.js.map