if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/aui-widget-transition/aui-widget-transition.js']) {
   __coverage__['build/aui-widget-transition/aui-widget-transition.js'] = {"path":"build/aui-widget-transition/aui-widget-transition.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":33},"end":{"line":1,"column":52}}},"2":{"name":"WidgetTransition","line":21,"loc":{"start":{"line":21,"column":0},"end":{"line":21,"column":28}}},"3":{"name":"(anonymous_3)","line":124,"loc":{"start":{"line":124,"column":16},"end":{"line":124,"column":27}}},"4":{"name":"(anonymous_4)","line":137,"loc":{"start":{"line":137,"column":17},"end":{"line":137,"column":28}}},"5":{"name":"(anonymous_5)","line":149,"loc":{"start":{"line":149,"column":21},"end":{"line":149,"column":32}}},"6":{"name":"(anonymous_6)","line":164,"loc":{"start":{"line":164,"column":16},"end":{"line":164,"column":27}}},"7":{"name":"(anonymous_7)","line":179,"loc":{"start":{"line":179,"column":16},"end":{"line":179,"column":27}}},"8":{"name":"(anonymous_8)","line":195,"loc":{"start":{"line":195,"column":15},"end":{"line":195,"column":29}}},"9":{"name":"(anonymous_9)","line":212,"loc":{"start":{"line":212,"column":23},"end":{"line":212,"column":37}}},"10":{"name":"(anonymous_10)","line":227,"loc":{"start":{"line":227,"column":36},"end":{"line":227,"column":50}}},"11":{"name":"(anonymous_11)","line":250,"loc":{"start":{"line":250,"column":24},"end":{"line":250,"column":42}}},"12":{"name":"(anonymous_12)","line":273,"loc":{"start":{"line":273,"column":17},"end":{"line":273,"column":35}}},"13":{"name":"(anonymous_13)","line":281,"loc":{"start":{"line":281,"column":12},"end":{"line":281,"column":23}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":293,"column":56}},"2":{"start":{"line":10,"column":0},"end":{"line":10,"column":18}},"3":{"start":{"line":21,"column":0},"end":{"line":26,"column":1}},"4":{"start":{"line":22,"column":4},"end":{"line":22,"column":24}},"5":{"start":{"line":25,"column":4},"end":{"line":25,"column":56}},"6":{"start":{"line":35,"column":0},"end":{"line":105,"column":2}},"7":{"start":{"line":107,"column":0},"end":{"line":288,"column":2}},"8":{"start":{"line":125,"column":8},"end":{"line":125,"column":28}},"9":{"start":{"line":127,"column":8},"end":{"line":127,"column":35}},"10":{"start":{"line":138,"column":8},"end":{"line":138,"column":28}},"11":{"start":{"line":140,"column":8},"end":{"line":140,"column":81}},"12":{"start":{"line":150,"column":8},"end":{"line":150,"column":28}},"13":{"start":{"line":152,"column":8},"end":{"line":155,"column":9}},"14":{"start":{"line":153,"column":12},"end":{"line":153,"column":41}},"15":{"start":{"line":154,"column":12},"end":{"line":154,"column":39}},"16":{"start":{"line":165,"column":8},"end":{"line":166,"column":42}},"17":{"start":{"line":168,"column":8},"end":{"line":168,"column":43}},"18":{"start":{"line":170,"column":8},"end":{"line":170,"column":89}},"19":{"start":{"line":180,"column":8},"end":{"line":181,"column":42}},"20":{"start":{"line":183,"column":8},"end":{"line":183,"column":42}},"21":{"start":{"line":185,"column":8},"end":{"line":185,"column":66}},"22":{"start":{"line":196,"column":8},"end":{"line":201,"column":9}},"23":{"start":{"line":197,"column":12},"end":{"line":200,"column":14}},"24":{"start":{"line":203,"column":8},"end":{"line":203,"column":19}},"25":{"start":{"line":213,"column":8},"end":{"line":213,"column":28}},"26":{"start":{"line":215,"column":8},"end":{"line":215,"column":40}},"27":{"start":{"line":217,"column":8},"end":{"line":217,"column":19}},"28":{"start":{"line":228,"column":8},"end":{"line":228,"column":28}},"29":{"start":{"line":230,"column":8},"end":{"line":238,"column":9}},"30":{"start":{"line":231,"column":12},"end":{"line":236,"column":13}},"31":{"start":{"line":232,"column":16},"end":{"line":232,"column":38}},"32":{"start":{"line":235,"column":16},"end":{"line":235,"column":38}},"33":{"start":{"line":237,"column":12},"end":{"line":237,"column":38}},"34":{"start":{"line":251,"column":8},"end":{"line":252,"column":54}},"35":{"start":{"line":254,"column":8},"end":{"line":254,"column":35}},"36":{"start":{"line":256,"column":8},"end":{"line":261,"column":9}},"37":{"start":{"line":258,"column":12},"end":{"line":258,"column":45}},"38":{"start":{"line":260,"column":12},"end":{"line":260,"column":47}},"39":{"start":{"line":274,"column":8},"end":{"line":275,"column":54}},"40":{"start":{"line":277,"column":8},"end":{"line":286,"column":10}},"41":{"start":{"line":282,"column":16},"end":{"line":282,"column":55}},"42":{"start":{"line":284,"column":16},"end":{"line":284,"column":52}},"43":{"start":{"line":290,"column":0},"end":{"line":290,"column":38}}},"branchMap":{"1":{"line":152,"type":"if","locations":[{"start":{"line":152,"column":8},"end":{"line":152,"column":8}},{"start":{"line":152,"column":8},"end":{"line":152,"column":8}}]},"2":{"line":196,"type":"if","locations":[{"start":{"line":196,"column":8},"end":{"line":196,"column":8}},{"start":{"line":196,"column":8},"end":{"line":196,"column":8}}]},"3":{"line":230,"type":"if","locations":[{"start":{"line":230,"column":8},"end":{"line":230,"column":8}},{"start":{"line":230,"column":8},"end":{"line":230,"column":8}}]},"4":{"line":231,"type":"if","locations":[{"start":{"line":231,"column":12},"end":{"line":231,"column":12}},{"start":{"line":231,"column":12},"end":{"line":231,"column":12}}]},"5":{"line":256,"type":"if","locations":[{"start":{"line":256,"column":8},"end":{"line":256,"column":8}},{"start":{"line":256,"column":8},"end":{"line":256,"column":8}}]},"6":{"line":279,"type":"cond-expr","locations":[{"start":{"line":279,"column":35},"end":{"line":279,"column":58}},{"start":{"line":279,"column":61},"end":{"line":279,"column":62}}]}},"code":["(function () { YUI.add('aui-widget-transition', function (A, NAME) {","","/**"," * Provides a class extension which can be used to animate widget visibility"," * changes."," *"," * @module aui-widget-transition"," */","","var Lang = A.Lang;","","/**"," * Widget extension, which can be used to add toggle visibility support to the"," * base Widget class, through the [Base.build](Base.html#method_build)"," * method."," *"," * @class A.WidgetTransition"," * @constructor"," */","","function WidgetTransition() {","    var instance = this;","","    // Store reference for the host class _uiSetVisible during class creation.","    instance._uiSetVisibleHost = instance._uiSetVisible;","}","","/**"," * Static property used to define the default attribute configuration."," *"," * @property ATTRS"," * @type Object"," * @static"," */","WidgetTransition.ATTRS = {","    /**","     * Determine if the transitions will animate or not.","     *","     * @attribute animated","     * @default false","     * @type Boolean","     * @writeOnce","     */","    animated: {","        validator: Lang.isBoolean,","        value: false","    },","","    /**","     * Determine the `delay` (in milliseconds) after widget's transition","     * animation. By default there's no delay. Can pass as parameter","     * a object `{show: value, hide: value}` or a single value 'Number'.","     *","     * @attribute delay","     * @default { show: 0, hide: 0 }","     * @type Object","     * @writeOnce","     */","    delay: {","        setter: '_setDelay',","        value: {","            show: 0,","            hide: 0","        }","    },","","    /**","     * Determine the duration of the transition.","     *","     * @attribute duration","     * @default 0.15","     * @type Number","     */","    duration: {","        validator: Lang.isNumber,","        value: 0.15","    },","","    /**","     * Determine the opacity.","     *","     * @attribute opacity","     * @default 1","     * @type Number","     */","    opacity: {","        validator: Lang.isNumber,","        value: 1","    },","","    /**","     * Determine the duration (in milliseconds) for the widget to stick","     * visibility after the trigger element. By default the stick duration is","     * not specified.","     *","     * @deprecated As of 2.0.0 replaced by attribute `delay`.","     * @attribute stickDuration","     * @type Number","     */","    stickDuration: {","        lazyAdd: false,","        setter: '_setStickDuration',","        validator: Lang.isNumber","    }","};","","WidgetTransition.prototype = {","","    /**","     * Stores the `Y.later` context object.","     *","     * @property _hideTimer","     * @type Object","     * @protected","     */","    _hideTimer: null,","","    /**","     * Destructor lifecycle implementation for the `A.WidgetTransition` class.","     *","     * @method destructor","     * @protected","     */","    destructor: function() {","        var instance = this;","","        instance._clearHideTimer();","    },","","    /**","     * Construction logic executed during `A.WidgetTransition` instantiation.","     * Lifecycle.","     *","     * @method initializer","     * @protected","     */","    initializer: function() {","        var instance = this;","","        A.on(instance._onUiSetVisibleWidgetTranstion, instance, '_uiSetVisible');","    },","","    /**","     * Helper method called to clear the close timer.","     *","     * @method _clearHideTimer","     * @protected","     */","    _clearHideTimer: function() {","        var instance = this;","","        if (instance._hideTimer) {","            instance._hideTimer.cancel();","            instance._hideTimer = null;","        }","    },","","    /**","     * Maybe hides if `stickDuration` do not prevent.","     *","     * @method _maybeHide","     * @protected","     */","    _maybeHide: function() {","        var instance = this,","            delay = instance.get('delay');","","        instance._prepareTransition(false);","","        instance._hideTimer = A.later(delay.hide, instance, instance._transition, false);","    },","","    /**","     * Maybe shows if `stickDuration` do not prevent.","     *","     * @method _maybeShow","     * @protected","     */","    _maybeShow: function() {","        var instance = this,","            delay = instance.get('delay');","","        instance._prepareTransition(true);","","        A.later(delay.show, instance, instance._transition, true);","    },","","    /**","     * Set the `delay` attribute.","     *","     * @method _setDelay","     * @param {Object | Number} val Delay value","     * @protected","     */","    _setDelay: function(val) {","        if (Lang.isNumber(val)) {","            return {","                show: val,","                hide: val","            };","        }","","        return val;","    },","","    /**","     * Set `delay:hide` to `stickDuration` value.","     *","     * @method _onStickDurationChange","     * @protected","     */","    _setStickDuration: function(val) {","        var instance = this;","","        instance.set('delay.hide', val);","","        return val;","    },","","    /**","     * Fire after `boundingBox` style changes.","     *","     * @method _afterUiSetVisible","     * @param val","     * @protected","     */","    _onUiSetVisibleWidgetTranstion: function(val) {","        var instance = this;","","        if (instance.get('animated')) {","            if (val) {","                instance._maybeShow();","            }","            else {","                instance._maybeHide();","            }","            return new A.Do.Prevent();","        }","","    },","","    /**","     * Prepare the widget to be animated.","     *","     * @method _prepareTransition","     * @param {Boolean} visible When `true`, fade in the element, otherwise","     *     fades out.","     * @protected","     */","    _prepareTransition: function(visible) {","        var instance = this,","            boundingBox = instance.get('boundingBox');","","        instance._clearHideTimer();","","        if (visible) {","            // when transitioning to visible invoke the host _uiSetVisible implementation...","            instance._uiSetVisibleHost(true);","            // then make sure the opacity transition goes from 0 to 1.","            boundingBox.setStyle('opacity', 0);","        }","    },","","    /**","     * Shows or hides depending on the passed parameter, when no parameter is","     * specified the default behavior is to hide the element.","     *","     * @method _transition","     * @param {Boolean} visible When `true`, fade in the element, otherwise","     *     fades out.","     * @protected","     */","    _transition: function(visible) {","        var instance = this,","            boundingBox = instance.get('boundingBox');","","        boundingBox.transition({","                duration: instance.get('duration'),","                opacity: visible ? instance.get('opacity') : 0","            },","            function() {","                boundingBox.toggleClass('in', visible);","","                instance._uiSetVisibleHost(visible);","            }","        );","    }","};","","A.WidgetTransition = WidgetTransition;","","","}, '3.1.0-deprecated.82', {\"requires\": [\"transition\"]});","","}());"]};
}
var __cov_wAQrffYtJVokTP8NHZTKtw = __coverage__['build/aui-widget-transition/aui-widget-transition.js'];
__cov_wAQrffYtJVokTP8NHZTKtw.s['1']++;YUI.add('aui-widget-transition',function(A,NAME){__cov_wAQrffYtJVokTP8NHZTKtw.f['1']++;__cov_wAQrffYtJVokTP8NHZTKtw.s['2']++;var Lang=A.Lang;__cov_wAQrffYtJVokTP8NHZTKtw.s['3']++;function WidgetTransition(){__cov_wAQrffYtJVokTP8NHZTKtw.f['2']++;__cov_wAQrffYtJVokTP8NHZTKtw.s['4']++;var instance=this;__cov_wAQrffYtJVokTP8NHZTKtw.s['5']++;instance._uiSetVisibleHost=instance._uiSetVisible;}__cov_wAQrffYtJVokTP8NHZTKtw.s['6']++;WidgetTransition.ATTRS={animated:{validator:Lang.isBoolean,value:false},delay:{setter:'_setDelay',value:{show:0,hide:0}},duration:{validator:Lang.isNumber,value:0.15},opacity:{validator:Lang.isNumber,value:1},stickDuration:{lazyAdd:false,setter:'_setStickDuration',validator:Lang.isNumber}};__cov_wAQrffYtJVokTP8NHZTKtw.s['7']++;WidgetTransition.prototype={_hideTimer:null,destructor:function(){__cov_wAQrffYtJVokTP8NHZTKtw.f['3']++;__cov_wAQrffYtJVokTP8NHZTKtw.s['8']++;var instance=this;__cov_wAQrffYtJVokTP8NHZTKtw.s['9']++;instance._clearHideTimer();},initializer:function(){__cov_wAQrffYtJVokTP8NHZTKtw.f['4']++;__cov_wAQrffYtJVokTP8NHZTKtw.s['10']++;var instance=this;__cov_wAQrffYtJVokTP8NHZTKtw.s['11']++;A.on(instance._onUiSetVisibleWidgetTranstion,instance,'_uiSetVisible');},_clearHideTimer:function(){__cov_wAQrffYtJVokTP8NHZTKtw.f['5']++;__cov_wAQrffYtJVokTP8NHZTKtw.s['12']++;var instance=this;__cov_wAQrffYtJVokTP8NHZTKtw.s['13']++;if(instance._hideTimer){__cov_wAQrffYtJVokTP8NHZTKtw.b['1'][0]++;__cov_wAQrffYtJVokTP8NHZTKtw.s['14']++;instance._hideTimer.cancel();__cov_wAQrffYtJVokTP8NHZTKtw.s['15']++;instance._hideTimer=null;}else{__cov_wAQrffYtJVokTP8NHZTKtw.b['1'][1]++;}},_maybeHide:function(){__cov_wAQrffYtJVokTP8NHZTKtw.f['6']++;__cov_wAQrffYtJVokTP8NHZTKtw.s['16']++;var instance=this,delay=instance.get('delay');__cov_wAQrffYtJVokTP8NHZTKtw.s['17']++;instance._prepareTransition(false);__cov_wAQrffYtJVokTP8NHZTKtw.s['18']++;instance._hideTimer=A.later(delay.hide,instance,instance._transition,false);},_maybeShow:function(){__cov_wAQrffYtJVokTP8NHZTKtw.f['7']++;__cov_wAQrffYtJVokTP8NHZTKtw.s['19']++;var instance=this,delay=instance.get('delay');__cov_wAQrffYtJVokTP8NHZTKtw.s['20']++;instance._prepareTransition(true);__cov_wAQrffYtJVokTP8NHZTKtw.s['21']++;A.later(delay.show,instance,instance._transition,true);},_setDelay:function(val){__cov_wAQrffYtJVokTP8NHZTKtw.f['8']++;__cov_wAQrffYtJVokTP8NHZTKtw.s['22']++;if(Lang.isNumber(val)){__cov_wAQrffYtJVokTP8NHZTKtw.b['2'][0]++;__cov_wAQrffYtJVokTP8NHZTKtw.s['23']++;return{show:val,hide:val};}else{__cov_wAQrffYtJVokTP8NHZTKtw.b['2'][1]++;}__cov_wAQrffYtJVokTP8NHZTKtw.s['24']++;return val;},_setStickDuration:function(val){__cov_wAQrffYtJVokTP8NHZTKtw.f['9']++;__cov_wAQrffYtJVokTP8NHZTKtw.s['25']++;var instance=this;__cov_wAQrffYtJVokTP8NHZTKtw.s['26']++;instance.set('delay.hide',val);__cov_wAQrffYtJVokTP8NHZTKtw.s['27']++;return val;},_onUiSetVisibleWidgetTranstion:function(val){__cov_wAQrffYtJVokTP8NHZTKtw.f['10']++;__cov_wAQrffYtJVokTP8NHZTKtw.s['28']++;var instance=this;__cov_wAQrffYtJVokTP8NHZTKtw.s['29']++;if(instance.get('animated')){__cov_wAQrffYtJVokTP8NHZTKtw.b['3'][0]++;__cov_wAQrffYtJVokTP8NHZTKtw.s['30']++;if(val){__cov_wAQrffYtJVokTP8NHZTKtw.b['4'][0]++;__cov_wAQrffYtJVokTP8NHZTKtw.s['31']++;instance._maybeShow();}else{__cov_wAQrffYtJVokTP8NHZTKtw.b['4'][1]++;__cov_wAQrffYtJVokTP8NHZTKtw.s['32']++;instance._maybeHide();}__cov_wAQrffYtJVokTP8NHZTKtw.s['33']++;return new A.Do.Prevent();}else{__cov_wAQrffYtJVokTP8NHZTKtw.b['3'][1]++;}},_prepareTransition:function(visible){__cov_wAQrffYtJVokTP8NHZTKtw.f['11']++;__cov_wAQrffYtJVokTP8NHZTKtw.s['34']++;var instance=this,boundingBox=instance.get('boundingBox');__cov_wAQrffYtJVokTP8NHZTKtw.s['35']++;instance._clearHideTimer();__cov_wAQrffYtJVokTP8NHZTKtw.s['36']++;if(visible){__cov_wAQrffYtJVokTP8NHZTKtw.b['5'][0]++;__cov_wAQrffYtJVokTP8NHZTKtw.s['37']++;instance._uiSetVisibleHost(true);__cov_wAQrffYtJVokTP8NHZTKtw.s['38']++;boundingBox.setStyle('opacity',0);}else{__cov_wAQrffYtJVokTP8NHZTKtw.b['5'][1]++;}},_transition:function(visible){__cov_wAQrffYtJVokTP8NHZTKtw.f['12']++;__cov_wAQrffYtJVokTP8NHZTKtw.s['39']++;var instance=this,boundingBox=instance.get('boundingBox');__cov_wAQrffYtJVokTP8NHZTKtw.s['40']++;boundingBox.transition({duration:instance.get('duration'),opacity:visible?(__cov_wAQrffYtJVokTP8NHZTKtw.b['6'][0]++,instance.get('opacity')):(__cov_wAQrffYtJVokTP8NHZTKtw.b['6'][1]++,0)},function(){__cov_wAQrffYtJVokTP8NHZTKtw.f['13']++;__cov_wAQrffYtJVokTP8NHZTKtw.s['41']++;boundingBox.toggleClass('in',visible);__cov_wAQrffYtJVokTP8NHZTKtw.s['42']++;instance._uiSetVisibleHost(visible);});}};__cov_wAQrffYtJVokTP8NHZTKtw.s['43']++;A.WidgetTransition=WidgetTransition;},'3.1.0-deprecated.82',{'requires':['transition']});
