if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/aui-widget-toolbars/aui-widget-toolbars.js']) {
   __coverage__['build/aui-widget-toolbars/aui-widget-toolbars.js'] = {"path":"build/aui-widget-toolbars/aui-widget-toolbars.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":31},"end":{"line":1,"column":50}}},"2":{"name":"(anonymous_2)","line":17,"loc":{"start":{"line":17,"column":21},"end":{"line":17,"column":32}}},"3":{"name":"(anonymous_3)","line":76,"loc":{"start":{"line":76,"column":17},"end":{"line":76,"column":28}}},"4":{"name":"(anonymous_4)","line":94,"loc":{"start":{"line":94,"column":16},"end":{"line":94,"column":43}}},"5":{"name":"(anonymous_5)","line":130,"loc":{"start":{"line":130,"column":16},"end":{"line":130,"column":34}}},"6":{"name":"(anonymous_6)","line":145,"loc":{"start":{"line":145,"column":23},"end":{"line":145,"column":41}}},"7":{"name":"(anonymous_7)","line":155,"loc":{"start":{"line":155,"column":19},"end":{"line":155,"column":37}}},"8":{"name":"(anonymous_8)","line":172,"loc":{"start":{"line":172,"column":26},"end":{"line":172,"column":37}}},"9":{"name":"(anonymous_9)","line":189,"loc":{"start":{"line":189,"column":21},"end":{"line":189,"column":32}}},"10":{"name":"(anonymous_10)","line":201,"loc":{"start":{"line":201,"column":20},"end":{"line":201,"column":34}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":211,"column":75}},"2":{"start":{"line":9,"column":0},"end":{"line":9,"column":28}},"3":{"start":{"line":17,"column":0},"end":{"line":17,"column":35}},"4":{"start":{"line":26,"column":0},"end":{"line":64,"column":2}},"5":{"start":{"line":66,"column":0},"end":{"line":206,"column":2}},"6":{"start":{"line":77,"column":8},"end":{"line":77,"column":28}},"7":{"start":{"line":79,"column":8},"end":{"line":79,"column":31}},"8":{"start":{"line":81,"column":8},"end":{"line":81,"column":62}},"9":{"start":{"line":83,"column":8},"end":{"line":83,"column":72}},"10":{"start":{"line":95,"column":8},"end":{"line":95,"column":28}},"11":{"start":{"line":97,"column":8},"end":{"line":97,"column":54}},"12":{"start":{"line":99,"column":8},"end":{"line":99,"column":40}},"13":{"start":{"line":101,"column":8},"end":{"line":107,"column":9}},"14":{"start":{"line":102,"column":12},"end":{"line":106,"column":15}},"15":{"start":{"line":109,"column":8},"end":{"line":109,"column":36}},"16":{"start":{"line":111,"column":8},"end":{"line":111,"column":45}},"17":{"start":{"line":113,"column":8},"end":{"line":116,"column":56}},"18":{"start":{"line":118,"column":8},"end":{"line":118,"column":40}},"19":{"start":{"line":120,"column":8},"end":{"line":120,"column":23}},"20":{"start":{"line":131,"column":8},"end":{"line":131,"column":28}},"21":{"start":{"line":133,"column":8},"end":{"line":133,"column":70}},"22":{"start":{"line":146,"column":8},"end":{"line":146,"column":40}},"23":{"start":{"line":156,"column":8},"end":{"line":157,"column":77}},"24":{"start":{"line":159,"column":8},"end":{"line":161,"column":9}},"25":{"start":{"line":160,"column":12},"end":{"line":160,"column":30}},"26":{"start":{"line":163,"column":8},"end":{"line":163,"column":23}},"27":{"start":{"line":173,"column":8},"end":{"line":175,"column":56}},"28":{"start":{"line":177,"column":8},"end":{"line":180,"column":9}},"29":{"start":{"line":179,"column":12},"end":{"line":179,"column":46}},"30":{"start":{"line":190,"column":8},"end":{"line":190,"column":28}},"31":{"start":{"line":192,"column":8},"end":{"line":192,"column":54}},"32":{"start":{"line":202,"column":8},"end":{"line":202,"column":28}},"33":{"start":{"line":204,"column":8},"end":{"line":204,"column":59}},"34":{"start":{"line":208,"column":0},"end":{"line":208,"column":34}}},"branchMap":{"1":{"line":101,"type":"if","locations":[{"start":{"line":101,"column":8},"end":{"line":101,"column":8}},{"start":{"line":101,"column":8},"end":{"line":101,"column":8}}]},"2":{"line":103,"type":"binary-expr","locations":[{"start":{"line":103,"column":26},"end":{"line":103,"column":64}},{"start":{"line":103,"column":68},"end":{"line":103,"column":70}}]},"3":{"line":146,"type":"binary-expr","locations":[{"start":{"line":146,"column":15},"end":{"line":146,"column":22}},{"start":{"line":146,"column":26},"end":{"line":146,"column":39}}]},"4":{"line":159,"type":"if","locations":[{"start":{"line":159,"column":8},"end":{"line":159,"column":8}},{"start":{"line":159,"column":8},"end":{"line":159,"column":8}}]},"5":{"line":177,"type":"if","locations":[{"start":{"line":177,"column":8},"end":{"line":177,"column":8}},{"start":{"line":177,"column":8},"end":{"line":177,"column":8}}]}},"code":["(function () { YUI.add('aui-widget-toolbars', function (A, NAME) {","","/**"," * The Widget Toolbars Utility"," *"," * @module aui-widget-toolbars"," */","","var StdMod = A.WidgetStdMod;","","/**"," * A base class for Widget Toolbars."," *"," * @class A.WidgetToolbars"," * @constructor"," */","var WidgetToolbars = function() {};","","/**"," * Static property used to define the default attribute configuration."," *"," * @property ATTRS"," * @type Object"," * @static"," */","WidgetToolbars.ATTRS = {","","    /**","     * Collection of `A.Toolbar` instances.","     *","     * @attribute toolbars","     * @default {}","     * @type Object","     */","    toolbars: {},","","    /**","     * Collection of toolbar's header, body, and footer positions.","     *","     * @attribute toolbarPosition","     * @type Object","     */","    toolbarPosition: {","        value: {","            body: StdMod.AFTER,","            footer: StdMod.AFTER,","            header: StdMod.BEFORE","        }","    },","","    /**","     * Collection of toolbar's header, body, and footer CSS classes.","     *","     * @attribute toolbarCssClass","     * @type Object","     */","    toolbarCssClass: {","        value: {","            body: '',","            footer: '',","            header: ''","        }","    }","};","","WidgetToolbars.prototype = {","    toolbars: null,","","    /**","     * Construction logic executed during WidgetToolbars instantiation.","     * Lifecycle.","     *","     * @method initializer","     * @protected","     */","    initializer: function() {","        var instance = this;","","        instance.toolbars = {};","","        A.after(instance._syncUIToolbars, instance, 'syncUI');","","        instance.after('toolbarsChange', instance._afterToolbarsChange);","    },","","    /**","     * Includes a `A.Toolbar` instance into the widget.","     *","     * @method addToolbar","     * @param toolbar","     * @param section","     * @return {A.Toolbar}","     */","    addToolbar: function(toolbar, section) {","        var instance = this;","","        section = instance.getToolbarSection(section);","","        instance.removeToolbar(section);","","        if (!A.instanceOf(toolbar, A.Toolbar)) {","            toolbar = new A.Toolbar({","                cssClass: this.get('toolbarCssClass.' + section) || '',","                children: toolbar,","                render: instance.getStdModNode(section, true)","            });","        }","","        toolbar.addTarget(instance);","","        instance.toolbars[section] = toolbar;","","        instance.setStdModContent(","            section,","            toolbar.get('boundingBox'),","            instance.get('toolbarPosition.' + section));","","        instance._syncPrimaryButtonUI();","","        return toolbar;","    },","","    /**","     * Gets the `A.Toolbar` instance based on its section.","     *","     * @method getToolbar","     * @param section","     * @return {A.Toolbar}","     */","    getToolbar: function(section) {","        var instance = this;","","        return instance.toolbars[instance.getToolbarSection(section)];","    },","","    /**","     * Gets the toolbar's section. If no argument is passed, returns the","     * `StdMod.FOOTER`.","     *","     * @method getToolbarSection","     * @param section","     * @return {String}","     *","     */","    getToolbarSection: function(section) {","        return section || StdMod.FOOTER;","    },","","    /**","     * Destroys the `A.Toolbar` instance based on its section.","     *","     * @method removeToolbar","     * @param section","     */","    removeToolbar: function(section) {","        var instance = this,","            toolbar = instance.toolbars[instance.getToolbarSection(section)];","","        if (toolbar) {","            toolbar.destroy();","        }","","        return toolbar;","    },","","    /**","     * Sync the primary button on the UI.","     *","     * @method _syncPrimaryButtonUI","     * @protected","     */","    _syncPrimaryButtonUI: function() {","        var instance = this,","            primaryButtonNode = instance.get('boundingBox').one(","                '.' + A.ButtonCore.CLASS_NAMES.PRIMARY);","","        if (primaryButtonNode) {","            // TODO: Check double focus workaround","            primaryButtonNode.focus().focus();","        }","    },","","    /**","     * Sync `A.Toolbar` instances on the UI.","     *","     * @method _syncUIToolbars","     * @protected","     */","    _syncUIToolbars: function() {","        var instance = this;","","        instance._uiSetToolbars(this.get('toolbars'));","    },","","    /**","     * Set `A.Toolbar` instances.","     *","     * @method _uiSetToolbars","     * @protected","     */","    _uiSetToolbars: function(val) {","        var instance = this;","","        A.each(val, A.bind(instance.addToolbar, instance));","    }","};","","A.WidgetToolbars = WidgetToolbars;","","","}, '3.1.0-deprecated.112', {\"requires\": [\"widget-stdmod\", \"aui-toolbar\"]});","","}());"]};
}
var __cov_FTeW0We__fnPTc4jihbrxg = __coverage__['build/aui-widget-toolbars/aui-widget-toolbars.js'];
__cov_FTeW0We__fnPTc4jihbrxg.s['1']++;YUI.add('aui-widget-toolbars',function(A,NAME){__cov_FTeW0We__fnPTc4jihbrxg.f['1']++;__cov_FTeW0We__fnPTc4jihbrxg.s['2']++;var StdMod=A.WidgetStdMod;__cov_FTeW0We__fnPTc4jihbrxg.s['3']++;var WidgetToolbars=function(){__cov_FTeW0We__fnPTc4jihbrxg.f['2']++;};__cov_FTeW0We__fnPTc4jihbrxg.s['4']++;WidgetToolbars.ATTRS={toolbars:{},toolbarPosition:{value:{body:StdMod.AFTER,footer:StdMod.AFTER,header:StdMod.BEFORE}},toolbarCssClass:{value:{body:'',footer:'',header:''}}};__cov_FTeW0We__fnPTc4jihbrxg.s['5']++;WidgetToolbars.prototype={toolbars:null,initializer:function(){__cov_FTeW0We__fnPTc4jihbrxg.f['3']++;__cov_FTeW0We__fnPTc4jihbrxg.s['6']++;var instance=this;__cov_FTeW0We__fnPTc4jihbrxg.s['7']++;instance.toolbars={};__cov_FTeW0We__fnPTc4jihbrxg.s['8']++;A.after(instance._syncUIToolbars,instance,'syncUI');__cov_FTeW0We__fnPTc4jihbrxg.s['9']++;instance.after('toolbarsChange',instance._afterToolbarsChange);},addToolbar:function(toolbar,section){__cov_FTeW0We__fnPTc4jihbrxg.f['4']++;__cov_FTeW0We__fnPTc4jihbrxg.s['10']++;var instance=this;__cov_FTeW0We__fnPTc4jihbrxg.s['11']++;section=instance.getToolbarSection(section);__cov_FTeW0We__fnPTc4jihbrxg.s['12']++;instance.removeToolbar(section);__cov_FTeW0We__fnPTc4jihbrxg.s['13']++;if(!A.instanceOf(toolbar,A.Toolbar)){__cov_FTeW0We__fnPTc4jihbrxg.b['1'][0]++;__cov_FTeW0We__fnPTc4jihbrxg.s['14']++;toolbar=new A.Toolbar({cssClass:(__cov_FTeW0We__fnPTc4jihbrxg.b['2'][0]++,this.get('toolbarCssClass.'+section))||(__cov_FTeW0We__fnPTc4jihbrxg.b['2'][1]++,''),children:toolbar,render:instance.getStdModNode(section,true)});}else{__cov_FTeW0We__fnPTc4jihbrxg.b['1'][1]++;}__cov_FTeW0We__fnPTc4jihbrxg.s['15']++;toolbar.addTarget(instance);__cov_FTeW0We__fnPTc4jihbrxg.s['16']++;instance.toolbars[section]=toolbar;__cov_FTeW0We__fnPTc4jihbrxg.s['17']++;instance.setStdModContent(section,toolbar.get('boundingBox'),instance.get('toolbarPosition.'+section));__cov_FTeW0We__fnPTc4jihbrxg.s['18']++;instance._syncPrimaryButtonUI();__cov_FTeW0We__fnPTc4jihbrxg.s['19']++;return toolbar;},getToolbar:function(section){__cov_FTeW0We__fnPTc4jihbrxg.f['5']++;__cov_FTeW0We__fnPTc4jihbrxg.s['20']++;var instance=this;__cov_FTeW0We__fnPTc4jihbrxg.s['21']++;return instance.toolbars[instance.getToolbarSection(section)];},getToolbarSection:function(section){__cov_FTeW0We__fnPTc4jihbrxg.f['6']++;__cov_FTeW0We__fnPTc4jihbrxg.s['22']++;return(__cov_FTeW0We__fnPTc4jihbrxg.b['3'][0]++,section)||(__cov_FTeW0We__fnPTc4jihbrxg.b['3'][1]++,StdMod.FOOTER);},removeToolbar:function(section){__cov_FTeW0We__fnPTc4jihbrxg.f['7']++;__cov_FTeW0We__fnPTc4jihbrxg.s['23']++;var instance=this,toolbar=instance.toolbars[instance.getToolbarSection(section)];__cov_FTeW0We__fnPTc4jihbrxg.s['24']++;if(toolbar){__cov_FTeW0We__fnPTc4jihbrxg.b['4'][0]++;__cov_FTeW0We__fnPTc4jihbrxg.s['25']++;toolbar.destroy();}else{__cov_FTeW0We__fnPTc4jihbrxg.b['4'][1]++;}__cov_FTeW0We__fnPTc4jihbrxg.s['26']++;return toolbar;},_syncPrimaryButtonUI:function(){__cov_FTeW0We__fnPTc4jihbrxg.f['8']++;__cov_FTeW0We__fnPTc4jihbrxg.s['27']++;var instance=this,primaryButtonNode=instance.get('boundingBox').one('.'+A.ButtonCore.CLASS_NAMES.PRIMARY);__cov_FTeW0We__fnPTc4jihbrxg.s['28']++;if(primaryButtonNode){__cov_FTeW0We__fnPTc4jihbrxg.b['5'][0]++;__cov_FTeW0We__fnPTc4jihbrxg.s['29']++;primaryButtonNode.focus().focus();}else{__cov_FTeW0We__fnPTc4jihbrxg.b['5'][1]++;}},_syncUIToolbars:function(){__cov_FTeW0We__fnPTc4jihbrxg.f['9']++;__cov_FTeW0We__fnPTc4jihbrxg.s['30']++;var instance=this;__cov_FTeW0We__fnPTc4jihbrxg.s['31']++;instance._uiSetToolbars(this.get('toolbars'));},_uiSetToolbars:function(val){__cov_FTeW0We__fnPTc4jihbrxg.f['10']++;__cov_FTeW0We__fnPTc4jihbrxg.s['32']++;var instance=this;__cov_FTeW0We__fnPTc4jihbrxg.s['33']++;A.each(val,A.bind(instance.addToolbar,instance));}};__cov_FTeW0We__fnPTc4jihbrxg.s['34']++;A.WidgetToolbars=WidgetToolbars;},'3.1.0-deprecated.112',{'requires':['widget-stdmod','aui-toolbar']});
