Liferay.Loader.define("frontend-js-collapse-support-web@1.0.11/CollapseProvider", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-dom'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var CssClass = {
      COLLAPSE: 'collapse',
      COLLAPSED: 'collapsed',
      COLLAPSING: 'collapsing',
      SHOW: 'show'
    };
    var Dimension = {
      HEIGHT: 'height',
      WIDTH: 'width'
    };
    var Selector = {
      TRIGGER: '[data-toggle="liferay-collapse"]'
    };

    var CollapseProvider = /*#__PURE__*/function () {
      function CollapseProvider() {
        var _this = this;

        _classCallCheck(this, CollapseProvider);

        _defineProperty(this, "EVENT_HIDDEN", 'liferay.collapse.hidden');

        _defineProperty(this, "EVENT_HIDE", 'liferay.collapse.hide');

        _defineProperty(this, "EVENT_SHOW", 'liferay.collapse.show');

        _defineProperty(this, "EVENT_SHOWN", 'liferay.collapse.shown');

        _defineProperty(this, "hide", function (_ref) {
          var panel = _ref.panel,
              trigger = _ref.trigger;

          if (panel && !trigger) {
            trigger = _this._getTrigger(panel);
          }

          if (!panel) {
            panel = _this._getPanel(trigger);
          }

          if (_this._transitioning || !panel.classList.contains(CssClass.SHOW)) {
            return;
          }

          Liferay.fire(_this.EVENT_HIDE, {
            panel: panel,
            trigger: trigger
          });
          trigger.classList.add(CssClass.COLLAPSED);
          trigger.setAttribute('aria-expanded', false);

          var dimension = _this._getDimension(panel);

          panel.style[dimension] = "".concat(panel.getBoundingClientRect()[dimension], "px"); // Reflow to make sure dimention is set, without this transition may
          // not trigger.

          panel.getBoundingClientRect();
          panel.classList.remove(CssClass.COLLAPSE);
          _this._transitioning = true;

          var onHidden = function onHidden() {
            panel.classList.remove(CssClass.COLLAPSING);
            panel.classList.remove(CssClass.SHOW);
            panel.classList.add(CssClass.COLLAPSE);
            _this._transitioning = false;
            Liferay.fire(_this.EVENT_HIDDEN, {
              panel: panel,
              trigger: trigger
            });
          };

          if (_this._prefersReducedMotion()) {
            onHidden();
          } else {
            _metalDom.default.once(panel, _this._transitionEndEvent, onHidden);

            panel.classList.add(CssClass.COLLAPSING);
            panel.style[dimension] = 0;
          }
        });

        _defineProperty(this, "show", function (_ref2) {
          var panel = _ref2.panel,
              trigger = _ref2.trigger;

          if (panel && !trigger) {
            trigger = _this._getTrigger(panel);
          }

          if (!panel) {
            panel = _this._getPanel(trigger);
          }

          if (_this._transitioning || panel.classList.contains(CssClass.SHOW)) {
            return;
          }

          var parentId = trigger.dataset.parent;

          if (parentId) {
            var parent = document.querySelector(parentId);

            if (parent) {
              var expandedTriggers = parent.querySelectorAll(Selector.TRIGGER + ':not(.' + CssClass.COLLAPSED + ')');
              expandedTriggers.forEach(function (expandedTrigger) {
                if (expandedTrigger !== trigger && expandedTrigger.dataset.parent === parentId) {
                  _this.hide({
                    trigger: expandedTrigger
                  });
                }
              });
            }
          }

          Liferay.fire(_this.EVENT_SHOW, {
            panel: panel,
            trigger: trigger
          });
          trigger.classList.remove(CssClass.COLLAPSED);
          trigger.setAttribute('aria-expanded', true);

          var dimension = _this._getDimension(panel);

          panel.classList.remove(CssClass.COLLAPSE);
          panel.classList.add(CssClass.COLLAPSING);
          panel.style[dimension] = 0;
          _this._transitioning = true;

          var onShown = function onShown() {
            panel.classList.remove(CssClass.COLLAPSING);
            panel.classList.add(CssClass.COLLAPSE);
            panel.classList.add(CssClass.SHOW);
            panel.style[dimension] = '';
            _this._transitioning = false;
            Liferay.fire(_this.EVENT_SHOWN, {
              panel: panel,
              trigger: trigger
            });
          };

          if (_this._prefersReducedMotion()) {
            onShown();
          } else {
            _metalDom.default.once(panel, _this._transitionEndEvent, onShown);

            var capitalizedDimension = dimension[0].toUpperCase() + dimension.slice(1);
            var scrollSize = "scroll".concat(capitalizedDimension);
            panel.style[dimension] = "".concat(panel[scrollSize], "px");
          }
        });

        _defineProperty(this, "_onTriggerClick", function (event) {
          var trigger = event.delegateTarget;

          if (trigger.tagName === 'A') {
            event.preventDefault();
          }

          var panel = _this._getPanel(trigger);

          if (panel) {
            if (panel.classList.contains(CssClass.SHOW)) {
              _this.hide({
                panel: panel,
                trigger: trigger
              });
            } else {
              _this.show({
                panel: panel,
                trigger: trigger
              });
            }
          }
        });

        if (Liferay.CollapseProvider) {
          return Liferay.CollapseProvider;
        }

        this._setTransitionEndEvent();

        _metalDom.default.delegate(document.body, 'click', Selector.TRIGGER, this._onTriggerClick);

        Liferay.CollapseProvider = this;
      }

      _createClass(CollapseProvider, [{
        key: "_getDimension",
        value: function _getDimension(panel) {
          var hasWidth = panel.classList.contains(Dimension.WIDTH);
          return hasWidth ? Dimension.WIDTH : Dimension.HEIGHT;
        }
      }, {
        key: "_getPanel",
        value: function _getPanel(trigger) {
          return document.querySelector(trigger.getAttribute('href') || trigger.dataset.target);
        }
      }, {
        key: "_getTrigger",
        value: function _getTrigger(panel) {
          return document.querySelector("[href=\"#".concat(panel.getAttribute('id'), "\"]"));
        }
      }, {
        key: "_prefersReducedMotion",
        value: function _prefersReducedMotion() {
          return window.matchMedia('(prefers-reduced-motion: reduce)').matches;
        }
      }, {
        key: "_setTransitionEndEvent",
        value: function _setTransitionEndEvent() {
          var sampleElement = document.body;
          var transitionEndEvents = {
            MozTransition: 'transitionend',
            OTransition: 'oTransitionEnd otransitionend',
            WebkitTransition: 'webkitTransitionEnd',
            transition: 'transitionend'
          };
          var eventName = false;
          Object.keys(transitionEndEvents).some(function (name) {
            if (sampleElement.style[name] !== undefined) {
              eventName = transitionEndEvents[name];
              return true;
            }
          });
          this._transitionEndEvent = eventName;
        }
      }]);

      return CollapseProvider;
    }();

    var _default = CollapseProvider;
    exports.default = _default;
    //# sourceMappingURL=CollapseProvider.js.map
  }
});
//# sourceMappingURL=CollapseProvider.js.map