/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.portlet.extender.internal.portlet;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.cm.ManagedService;

public class JSPortlet
extends MVCPortlet
implements ManagedService {
    private static final String _TPL_HTML;
    private static final String _TPL_JAVA_SCRIPT;
    private static final Log _log;
    private final AtomicReference<Map<String, Object>> _configuration = new AtomicReference();
    private final JSONFactory _jsonFactory;
    private final String _packageName;
    private final String _packageVersion;
    private final Set<String> _portletPreferencesFieldNames;

    public JSPortlet(JSONFactory jsonFactory, String packageName, String packageVersion, Set<String> portletPreferencesFieldNames) {
        this._jsonFactory = jsonFactory;
        this._packageName = packageName;
        this._packageVersion = packageVersion;
        this._portletPreferencesFieldNames = portletPreferencesFieldNames;
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) {
        try {
            PrintWriter printWriter = renderResponse.getWriter();
            String portletElementId = "js-portlet-" + renderResponse.getNamespace();
            printWriter.print(StringUtil.replace((String)_TPL_HTML, (String[])new String[]{"[$PORTLET_ELEMENT_ID$]"}, (String[])new String[]{portletElementId}));
            printWriter.print(StringUtil.replace((String)_TPL_JAVA_SCRIPT, (String[])new String[]{"[$CONTEXT_PATH$]", "[$PACKAGE_NAME$]", "[$PACKAGE_VERSION$]", "[$PORTLET_ELEMENT_ID$]", "[$PORTLET_INSTANCE_CONFIGURATION$]", "[$PORTLET_NAMESPACE$]", "[$SYSTEM_CONFIGURATION$]"}, (String[])new String[]{renderRequest.getContextPath(), this._packageName, this._packageVersion, portletElementId, this._getPortletInstanceConfiguration(renderRequest), renderResponse.getNamespace(), this._getSystemConfiguration()}));
            printWriter.flush();
        }
        catch (IOException ioException) {
            _log.error((Object)"Unable to render HTML output", (Throwable)ioException);
        }
    }

    public void updated(Dictionary<String, ?> properties) {
        if (properties == null) {
            this._configuration.set(Collections.emptyMap());
            return;
        }
        HashMap configuration = new HashMap();
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key.equals("service.pid")) continue;
            Object value = properties.get(key);
            value = value instanceof Vector ? new ArrayList((Vector)value) : String.valueOf(value);
            configuration.put(key, value);
        }
        this._configuration.set(configuration);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String _loadTemplate(String name) {
        try (InputStream inputStream = JSPortlet.class.getResourceAsStream("dependencies/" + name);){
            String string = StringUtil.read((InputStream)inputStream);
            return string;
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to read template " + name), (Throwable)exception);
            return "";
        }
    }

    private String _getPortletInstanceConfiguration(RenderRequest renderRequest) {
        PortletPreferences portletPreferences = renderRequest.getPreferences();
        JSONObject portletPreferencesJSONObject = this._jsonFactory.createJSONObject();
        Enumeration portletPreferencesNames = portletPreferences.getNames();
        while (portletPreferencesNames.hasMoreElements()) {
            String key = (String)portletPreferencesNames.nextElement();
            if (!this._portletPreferencesFieldNames.contains(key)) continue;
            String[] values = portletPreferences.getValues(key, StringPool.EMPTY_ARRAY);
            if (values.length > 1) {
                portletPreferencesJSONObject.put(key, (Object)values);
                continue;
            }
            portletPreferencesJSONObject.put(key, values[0]);
        }
        return portletPreferencesJSONObject.toJSONString();
    }

    private String _getSystemConfiguration() {
        return this._jsonFactory.looseSerializeDeep(this._configuration.get());
    }

    static {
        _log = LogFactoryUtil.getLog(JSPortlet.class);
        _TPL_HTML = JSPortlet._loadTemplate("bootstrap.html.tpl");
        _TPL_JAVA_SCRIPT = JSPortlet._loadTemplate("bootstrap.js.tpl");
    }
}

