Liferay.Loader.define('liferay!frontend-js-react-web$lodash-es@4.17.15/_baseOrderBy', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import arrayMap from './_arrayMap.js';
    import baseIteratee from './_baseIteratee.js';
    import baseMap from './_baseMap.js';
    import baseSortBy from './_baseSortBy.js';
    import baseUnary from './_baseUnary.js';
    import compareMultiple from './_compareMultiple.js';
    import identity from './identity.js';

    /**
     * The base implementation of `_.orderBy` without param guards.
     *
     * @private
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function[]|Object[]|string[]} iteratees The iteratees to sort by.
     * @param {string[]} orders The sort orders of `iteratees`.
     * @returns {Array} Returns the new sorted array.
     */
    function baseOrderBy(collection, iteratees, orders) {
      var index = -1;
      iteratees = arrayMap(iteratees.length ? iteratees : [identity], baseUnary(baseIteratee));

      var result = baseMap(collection, function (value, key, collection) {
        var criteria = arrayMap(iteratees, function (iteratee) {
          return iteratee(value);
        });
        return { 'criteria': criteria, 'index': ++index, 'value': value };
      });

      return baseSortBy(result, function (object, other) {
        return compareMultiple(object, other, orders);
      });
    }

    export default baseOrderBy;
  }
});
//# sourceMappingURL=_baseOrderBy.js.map