Liferay.Loader.define('liferay!frontend-js-react-web$lodash-es@4.17.15/_createAggregator', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import arrayAggregator from './_arrayAggregator.js';
    import baseAggregator from './_baseAggregator.js';
    import baseIteratee from './_baseIteratee.js';
    import isArray from './isArray.js';

    /**
     * Creates a function like `_.groupBy`.
     *
     * @private
     * @param {Function} setter The function to set accumulator values.
     * @param {Function} [initializer] The accumulator object initializer.
     * @returns {Function} Returns the new aggregator function.
     */
    function createAggregator(setter, initializer) {
      return function (collection, iteratee) {
        var func = isArray(collection) ? arrayAggregator : baseAggregator,
            accumulator = initializer ? initializer() : {};

        return func(collection, setter, baseIteratee(iteratee, 2), accumulator);
      };
    }

    export default createAggregator;
  }
});
//# sourceMappingURL=_createAggregator.js.map