Liferay.Loader.define('liferay!frontend-js-react-web$lodash-es@4.17.15/_createRelationalOperation', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import toNumber from './toNumber.js';

    /**
     * Creates a function that performs a relational operation on two values.
     *
     * @private
     * @param {Function} operator The function to perform the operation.
     * @returns {Function} Returns the new relational operation function.
     */
    function createRelationalOperation(operator) {
      return function (value, other) {
        if (!(typeof value == 'string' && typeof other == 'string')) {
          value = toNumber(value);
          other = toNumber(other);
        }
        return operator(value, other);
      };
    }

    export default createRelationalOperation;
  }
});
//# sourceMappingURL=_createRelationalOperation.js.map