Liferay.Loader.define('liferay!frontend-js-react-web$lodash-es@4.17.15/nthArg', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import baseNth from './_baseNth.js';
    import baseRest from './_baseRest.js';
    import toInteger from './toInteger.js';

    /**
     * Creates a function that gets the argument at index `n`. If `n` is negative,
     * the nth argument from the end is returned.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Util
     * @param {number} [n=0] The index of the argument to return.
     * @returns {Function} Returns the new pass-thru function.
     * @example
     *
     * var func = _.nthArg(1);
     * func('a', 'b', 'c', 'd');
     * // => 'b'
     *
     * var func = _.nthArg(-2);
     * func('a', 'b', 'c', 'd');
     * // => 'c'
     */
    function nthArg(n) {
      n = toInteger(n);
      return baseRest(function (args) {
        return baseNth(args, n);
      });
    }

    export default nthArg;
  }
});
//# sourceMappingURL=nthArg.js.map