/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
'use strict';

Liferay.Loader.define("frontend-js-spa-web@4.0.36/liferay/init.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom', 'frontend-js-spa-web$senna', 'frontend-js-spa-web$senna/lib/globals/globals', './app/App.es', './screen/ActionURLScreen.es', './screen/RenderURLScreen.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _metal = require("frontend-js-metal-web$metal");

    var _metalDom = require("frontend-js-metal-web$metal-dom");

    var _senna = require("frontend-js-spa-web$senna");

    var _globals = _interopRequireDefault(require("frontend-js-spa-web$senna/lib/globals/globals"));

    var _App = _interopRequireDefault(require("./app/App.es"));

    var _ActionURLScreen = _interopRequireDefault(require("./screen/ActionURLScreen.es"));

    var _RenderURLScreen = _interopRequireDefault(require("./screen/RenderURLScreen.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Initializes a Senna App with routes that match both ActionURLs and RenderURLs.
     * It also overrides Liferay's default Liferay.Util.submitForm to makes sure
     * forms are properly submitted using SPA.
     * @return {!App} The Senna App initialized
     */
    var initSPA = function initSPA() {
      var app = new _App.default();
      app.addRoutes([{
        handler: _ActionURLScreen.default,
        path: function path(url) {
          var match = false;
          var uri = new URL(url, window.location.origin);
          var loginRedirect = new URL(Liferay.SPA.loginRedirect, window.location.origin);
          var host = loginRedirect.host || window.location.host;

          if (app.isLinkSameOrigin_(host)) {
            match = uri.searchParams.get('p_p_lifecycle') === '1';
          }

          return match;
        }
      }, {
        handler: _RenderURLScreen.default,
        path: function path(url) {
          var match = false;

          if ((url + '/').indexOf(themeDisplay.getPathMain() + '/') !== 0) {
            var excluded = Liferay.SPA.excludedPaths.some(function (excludedPath) {
              return url.indexOf(excludedPath) === 0;
            });

            if (!excluded) {
              var uri = new URL(url, window.location.origin);
              var lifecycle = uri.searchParams.get('p_p_lifecycle');
              match = lifecycle === '0' || !lifecycle;
            }
          }

          return match;
        }
      }]);

      Liferay.Util.submitForm = function (form) {
        _metal.async.nextTick(function () {
          var formElement = Object.isPrototypeOf.call(HTMLFormElement.prototype, form) ? form : form.getDOM();
          var formSelector = 'form' + Liferay.SPA.navigationExceptionSelectors;
          var url = formElement.action;

          if ((0, _metalDom.match)(formElement, formSelector) && app.canNavigate(url) && formElement.method !== 'get' && !app.isInPortletBlacklist(formElement)) {
            Liferay.Util._submitLocked = false;
            _globals.default.capturedFormElement = formElement;
            var buttonSelector = 'button:not([type]),button[type=submit],input[type=submit]';

            if ((0, _metalDom.match)(_globals.default.document.activeElement, buttonSelector)) {
              _globals.default.capturedFormButtonElement = _globals.default.document.activeElement;
            } else {
              _globals.default.capturedFormButtonElement = formElement.querySelector(buttonSelector);
            }

            app.navigate(_senna.utils.getUrlPath(url));
          } else {
            formElement.submit();
          }
        });
      };

      Liferay.initComponentCache();
      Liferay.SPA.app = app;
      Liferay.SPA.version = _senna.version;
      Liferay.fire('SPAReady');
      return app;
    };

    var _default = {
      init: function init(callback) {
        var _this = this;

        if (_globals.default.document.readyState == 'loading') {
          _globals.default.document.addEventListener('DOMContentLoaded', function () {
            callback.call(_this, initSPA());
          });
        } else {
          callback.call(this, initSPA());
        }
      }
    };
    exports.default = _default;
    //# sourceMappingURL=init.es.js.map
  }
});
//# sourceMappingURL=init.es.js.map